/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.OptionalSlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.misc.PartStorageBus;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerStorageBus
extends ContainerUpgradeable {
    private final PartStorageBus storageBus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo stickyMode = YesNo.NO;

    public ContainerStorageBus(InventoryPlayer ip, PartStorageBus te) {
        super(ip, te);
        this.storageBus = te;
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int xo = 8;
        int yo = 29;
        IInventory config = this.getUpgradeable().getInventoryByName("config");
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new OptionalSlotFakeTypeOnly(config, this, y * 9 + x, 8, 29, x, y, y));
            }
        }
        IInventory upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setFuzzyMode((FuzzyMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setReadWriteMode((AccessRestriction)this.getUpgradeable().getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)this.getUpgradeable().getConfigManager().getSetting(Settings.STORAGE_FILTER));
            this.setStickyMode((YesNo)this.getUpgradeable().getConfigManager().getSetting(Settings.STICKY_MODE));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (this.getUpgradeable().getInstalledUpgrades(Upgrades.ORE_FILTER) > 0) {
            return false;
        }
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx - 2;
    }

    public void clear() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    public void partition() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        MEInventoryHandler cellInv = this.storageBus.getInternalHandler();
        Iterator<Object> i = new NullIterator();
        if (cellInv != null) {
            IItemList<IAEItemStack> list = cellInv.getAvailableItems(AEApi.instance().storage().createItemList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                ItemStack g = ((IAEItemStack)i.next()).getItemStack();
                g.field_77994_a = 1;
                inv.func_70299_a(x, g);
                continue;
            }
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getStickyMode() {
        return this.stickyMode;
    }

    private void setStickyMode(YesNo stickyMode) {
        this.stickyMode = stickyMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }
}

