/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.mods.thaumcraft.recipe.MTInfusionRecipe;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

@ZenClass(value="mods.thaumcraft.Infusion")
public class Infusion {
    public static final String name = "Thaumcraft Infusion";
    public static final String enchName = "Thaumcraft Infusion Enchantment";

    @ZenMethod
    public static void addRecipe(String key, IItemStack input, IItemStack[] recipe, String aspects, IItemStack result, int instability) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new InfusionRecipe(key, (Object)InputHelper.toStack(result), instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStack(input), InputHelper.toStacks(recipe))));
    }

    @ZenMethod
    public static void addRecipe(String key, IItemStack input, IItemStack[] recipe, String aspects, IItemStack result, int instability, boolean fuzzyCentre, boolean[] fuzzyRecipe) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MTInfusionRecipe(key, InputHelper.toStack(result), instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStack(input), InputHelper.toStacks(recipe), fuzzyCentre, fuzzyRecipe)));
    }

    @ZenMethod
    public static void addEnchantment(String key, int enchantID, int instability, String aspects, IItemStack[] recipe) {
        MineTweakerAPI.apply((IUndoableAction)new AddEnchant(new InfusionEnchantmentRecipe(key, Enchantment.field_77331_b[enchantID], instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStacks(recipe))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<InfusionRecipe> recipes = new LinkedList<InfusionRecipe>();
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            InfusionRecipe r;
            if (!(o instanceof InfusionRecipe) || (r = (InfusionRecipe)o).getRecipeOutput() == null || !(r.getRecipeOutput() instanceof ItemStack) || !StackHelper.matches(output, InputHelper.toIItemStack((ItemStack)r.getRecipeOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void removeEnchant(int id) {
        LinkedList<InfusionEnchantmentRecipe> recipes = new LinkedList<InfusionEnchantmentRecipe>();
        Enchantment ench = Enchantment.field_77331_b[id];
        for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
            InfusionEnchantmentRecipe enchRecipe;
            if (!(recipe instanceof InfusionEnchantmentRecipe) || (enchRecipe = (InfusionEnchantmentRecipe)recipe).getEnchantment() != ench) continue;
            recipes.add(enchRecipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveEnchant(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", "Thaumcraft Infusion Enchantment Enchantment", ench.func_77320_a()));
        }
    }

    private static class RemoveEnchant
    extends BaseListRemoval<InfusionEnchantmentRecipe> {
        public RemoveEnchant(List<InfusionEnchantmentRecipe> recipes) {
            super(Infusion.enchName, ThaumcraftApi.getCraftingRecipes(), recipes);
        }

        @Override
        protected String getRecipeInfo(InfusionEnchantmentRecipe recipe) {
            return recipe.getEnchantment().func_77320_a();
        }
    }

    private static class Remove
    extends BaseListRemoval<InfusionRecipe> {
        public Remove(List<InfusionRecipe> recipes) {
            super(Infusion.name, ThaumcraftApi.getCraftingRecipes(), recipes);
        }

        @Override
        protected String getRecipeInfo(InfusionRecipe recipe) {
            Object o = recipe.getRecipeOutput();
            if (o instanceof ItemStack) {
                return LogHelper.getStackDescription((ItemStack)o);
            }
            return "Unknown Item";
        }
    }

    private static class AddEnchant
    extends BaseListAddition<InfusionEnchantmentRecipe> {
        public AddEnchant(InfusionEnchantmentRecipe inp) {
            super(Infusion.enchName, ThaumcraftApi.getCraftingRecipes());
            this.recipes.add(inp);
        }

        @Override
        protected String getRecipeInfo(InfusionEnchantmentRecipe recipe) {
            return recipe.getEnchantment().func_77320_a();
        }
    }

    private static class Add
    extends BaseListAddition<InfusionRecipe> {
        public Add(InfusionRecipe recipe) {
            super(Infusion.name, ThaumcraftApi.getCraftingRecipes());
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(InfusionRecipe recipe) {
            Object out = recipe.getRecipeOutput();
            if (out instanceof ItemStack) {
                return ((ItemStack)out).func_82833_r();
            }
            return "Unknown item";
        }
    }
}

