/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.crafting.CastingRecipe;

@ZenClass(value="mods.tconstruct.Casting")
public class Casting {
    protected static final String name = "TConstruct Casting";

    @ZenMethod
    public static void addBasinRecipe(IItemStack output, ILiquidStack metal, @Optional IItemStack cast, @Optional boolean consume, int delay) {
        if (metal == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CastingRecipe(InputHelper.toStack(output), InputHelper.toFluid(metal), InputHelper.toStack(cast), consume, delay, null), TConstructHelper.basinCasting));
    }

    @ZenMethod
    public static void addTableRecipe(IItemStack output, ILiquidStack metal, @Optional IItemStack cast, @Optional boolean consume, int delay) {
        if (metal == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CastingRecipe(InputHelper.toStack(output), InputHelper.toFluid(metal), InputHelper.toStack(cast), consume, delay, null), TConstructHelper.tableCasting));
    }

    @ZenMethod
    public static void removeTableRecipe(IIngredient output, @Optional IIngredient material, @Optional IIngredient cast) {
        Casting.removeRecipe(output, material, cast, TConstructHelper.tableCasting);
    }

    @ZenMethod
    public static void removeBasinRecipe(IIngredient output, @Optional IIngredient material, @Optional IIngredient cast) {
        Casting.removeRecipe(output, material, cast, TConstructHelper.basinCasting);
    }

    public static void removeRecipe(IIngredient output, IIngredient material, IIngredient cast, List<CastingRecipe> list) {
        if (output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (material == null) {
            material = IngredientAny.INSTANCE;
        }
        if (cast == null) {
            cast = IngredientAny.INSTANCE;
        }
        LinkedList<CastingRecipe> recipes = new LinkedList<CastingRecipe>();
        for (CastingRecipe recipe : list) {
            if (recipe == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.output)) || !StackHelper.matches(material, InputHelper.toILiquidStack(recipe.castingMetal)) || !StackHelper.matches(cast, InputHelper.toIItemStack(recipe.cast))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for output %s, material %s and cast %s. Command ignored!", name, output.toString(), material.toString(), cast.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<CastingRecipe> {
        public Remove(List<CastingRecipe> list, List<CastingRecipe> recipes) {
            super(Casting.name, list, recipes);
        }

        @Override
        protected String getRecipeInfo(CastingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }

    private static class Add
    extends BaseListAddition<CastingRecipe> {
        public Add(CastingRecipe recipe, ArrayList<CastingRecipe> list) {
            super(Casting.name, list);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(CastingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }
}

