/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Objects;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.util.UpdateCheck;
import li.cil.oc.util.UpdateCheck$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;

public final class UpdateCheck$ {
    public static final UpdateCheck$ MODULE$;
    private final URL releasesUrl;
    private Future<Option<UpdateCheck.Release>> info;

    static {
        new UpdateCheck$();
    }

    private URL releasesUrl() {
        return this.releasesUrl;
    }

    public Future<Option<UpdateCheck.Release>> info() {
        return this.info;
    }

    public void info_$eq(Future<Option<UpdateCheck.Release>> x$1) {
        this.info = x$1;
    }

    public Option<UpdateCheck.Release> li$cil$oc$util$UpdateCheck$$initialize() {
        if (Settings$.MODULE$.get().updateCheck() && !"1.7.7+3d2bec9".equals("@VERSION@")) {
            try {
                ComparableVersion localVersion;
                UpdateCheck.Release latest;
                ComparableVersion remoteVersion;
                OpenComputers$.MODULE$.log().info("Starting OpenComputers version check.");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(this.releasesUrl().openStream()));
                reader.beginArray();
                ArrayBuffer candidates = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                while (reader.hasNext()) {
                    String[] tagNameParts;
                    Object object;
                    UpdateCheck.Release release = (UpdateCheck.Release)new Gson().fromJson(reader, UpdateCheck.Release.class);
                    if (release.prerelease()) {
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    boolean versionMatch = true;
                    if (release.tag_name().contains("/") && (tagNameParts = release.tag_name().split("/", 2)).length >= 2) {
                        release.tag_name_$eq(tagNameParts[1]);
                        versionMatch = Objects.equals("1.7.10-forge", tagNameParts[0]);
                    }
                    object = versionMatch ? candidates.$plus$eq((Object)release) : BoxedUnit.UNIT;
                }
                reader.endArray();
                if (candidates.nonEmpty() && (remoteVersion = new ComparableVersion(new StringOps(Predef$.MODULE$.augmentString((latest = (UpdateCheck.Release)candidates.maxBy((Function1)new Serializable(){

                    public final ComparableVersion apply(UpdateCheck.Release release) {
                        return new ComparableVersion(new StringOps(Predef$.MODULE$.augmentString(release.tag_name())).stripPrefix("v"));
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).tag_name())).stripPrefix("v"))).compareTo(localVersion = new ComparableVersion(((ModContainer)Loader.instance().getIndexedModList().get("OpenComputers")).getVersion())) > 0) {
                    OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A newer version of OpenComputers is available: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{latest.tag_name()})));
                    return new Some((Object)latest);
                }
                OpenComputers$.MODULE$.log().info("Running the latest OpenComputers version.");
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn("Update check for OpenComputers failed.", throwable);
            }
        }
        return None$.MODULE$;
    }

    private UpdateCheck$() {
        MODULE$ = this;
        this.releasesUrl = new URL("https://api.github.com/repos/MightyPirates/OpenComputers/releases");
        this.info = Future$.MODULE$.apply((Function0)new anonfun.1(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }
}

