/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.plugins.nei.RecipeHandlerBase;

public abstract class RecipeHandlerCastingBase
extends RecipeHandlerBase {
    public static final Rectangle MOLTEN_FLOW = new Rectangle(60, 8, 6, 11);
    public static final Rectangle MOLTEN_FLOW_NO_ITEM = new Rectangle(60, 8, 6, 27);

    @Override
    public String getRecipeID() {
        return "tconstruct.smeltery.casting";
    }

    public String getGuiTexture() {
        return "tinker:textures/gui/nei/casting.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 18, 22, 15), this.getRecipeID(), new Object[0]));
    }

    public abstract List<CastingRecipe> getCastingRecipes();

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (CastingRecipe recipe : this.getCastingRecipes()) {
                this.arecipes.add(new CachedCastingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)recipe.getResult())) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.cast, (ItemStack)ingred)) continue;
            CachedCastingRecipe irecipe = new CachedCastingRecipe(recipe);
            irecipe.setIngredientPermutation(irecipe.resources, ingred);
            this.arecipes.add(irecipe);
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!RecipeHandlerCastingBase.areFluidsEqual(recipe.castingMetal, ingredient)) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    public class CachedCastingRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        private final List<PositionedStack> resources;
        private final RecipeHandlerBase.FluidTankElement metal;
        private PositionedStack output;

        public CachedCastingRecipe(CastingRecipe recipe) {
            this.metal = new RecipeHandlerBase.FluidTankElement(MOLTEN_FLOW, recipe.castingMetal.amount, recipe.castingMetal);
            this.metal.flowingTexture = true;
            this.resources = new ArrayList<PositionedStack>();
            if (recipe.cast != null) {
                this.resources.add(new PositionedStack((Object)recipe.cast, 55, 19));
            } else {
                this.metal.position = MOLTEN_FLOW_NO_ITEM;
            }
            this.output = new PositionedStack((Object)recipe.output, 110, 18);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerCastingBase.this.cycleticks / 20, this.resources);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public List<RecipeHandlerBase.FluidTankElement> getFluidTanks() {
            ArrayList<RecipeHandlerBase.FluidTankElement> res = new ArrayList<RecipeHandlerBase.FluidTankElement>();
            res.add(this.metal);
            return res;
        }
    }
}

