/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.builders.gui.SlotBuilderRequirement;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation REGULAR_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder_blueprint.png");
    private TileBuilder builder;
    private GuiButton selectedButton;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super((BuildCraftContainer)new ContainerBuilder(playerInventory, builder), (IInventory)builder, BLUEPRINT_TEXTURE);
        this.builder = builder;
        this.field_146999_f = 256;
        this.field_147000_g = 225;
        this.resetNullSlots(24);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new SlotBuilderRequirement(this, 179 + j * 18, 18 + i * 18));
            }
        }
    }

    private ContainerBuilder getContainerBuilder() {
        return (ContainerBuilder)this.getContainer();
    }

    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.drawCenteredString(StringUtils.localize((String)"tile.builderBlock.name"), 89, 16, 0x404040);
        if (this.builder.func_70301_a(0) != null) {
            this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.building.resources"), 8, 60, 0x404040);
            this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
            this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.needed"), 178, 7, 0x404040);
            this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.building.fluids"), 178, 133, 0x404040);
        }
        this.drawTooltips(par1, par2);
    }

    private void drawTooltips(int par1, int par2) {
        int top = this.field_147009_r + 145;
        for (int i = 0; i < this.builder.fluidTanks.length; ++i) {
            int left = this.field_147003_i + 179 + 18 * i;
            if (par1 < left || par2 < top || par1 >= left + 16 || par2 >= left + 47) continue;
            ArrayList<String> fluidTip = new ArrayList<String>();
            Tank tank = this.builder.fluidTanks[i];
            if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                fluidTip.add(tank.getFluid().getLocalizedName());
                if (!BuildCraftCore.hideFluidNumbers) {
                    fluidTip.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + tank.getFluid().amount + " mB");
                }
            } else {
                fluidTip.add(StatCollector.func_74838_a((String)"gui.fluidtank.empty"));
            }
            this.drawHoveringText(fluidTip, par1 - this.field_147003_i, par2 - this.field_147009_r, this.field_146289_q);
            return;
        }
        this.drawTooltipForSlotAt(par1, par2);
    }

    protected void func_146976_a(float f, int x, int y) {
        List<RequirementItemStack> needs;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean isBlueprint = this.builder.func_70301_a(0) != null;
        this.field_146297_k.field_71446_o.func_110577_a(REGULAR_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, this.field_147000_g);
        this.field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
        if (isBlueprint) {
            this.func_73729_b(this.field_147003_i + 169, this.field_147009_r, 169, 0, 87, this.field_147000_g);
        }
        if ((needs = this.builder.getNeededItems()) != null) {
            if (needs.size() > this.slots.size()) {
                this.getContainerBuilder().scrollbarWidget.hidden = false;
                this.getContainerBuilder().scrollbarWidget.setLength((needs.size() - this.slots.size() + 3) / 4);
            } else {
                this.getContainerBuilder().scrollbarWidget.hidden = true;
            }
            int offset = this.getContainerBuilder().scrollbarWidget.getPosition() * 4;
            for (int s = 0; s < this.slots.size(); ++s) {
                int ts = offset + s;
                ((SlotBuilderRequirement)((Object)this.slots.get((int)s))).stack = ts >= needs.size() ? null : needs.get(ts);
            }
            for (GuiButton b : this.field_146292_n) {
                b.field_146125_m = true;
            }
        } else {
            this.getContainerBuilder().scrollbarWidget.hidden = true;
            for (AdvancedSlot slot : this.slots) {
                ((SlotBuilderRequirement)slot).stack = null;
            }
            for (GuiButton b : this.field_146292_n) {
                b.field_146125_m = false;
            }
        }
        this.drawWidgets(x, y);
        if (isBlueprint) {
            this.drawBackgroundSlots(x, y);
        }
        if (isBlueprint) {
            Tank tank;
            int i;
            for (i = 0; i < this.builder.fluidTanks.length; ++i) {
                tank = this.builder.fluidTanks[i];
                if (tank.getFluid() == null || tank.getFluid().amount <= 0) continue;
                this.drawFluid(tank.getFluid(), this.field_147003_i + 179 + 18 * i, this.field_147009_r + 145, 16, 47, tank.getCapacity());
            }
            this.field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
            for (i = 0; i < this.builder.fluidTanks.length; ++i) {
                tank = this.builder.fluidTanks[i];
                if (tank.getFluid() == null || tank.getFluid().amount <= 0) continue;
                this.func_73729_b(this.field_147003_i + 179 + 18 * i, this.field_147009_r + 145, 0, 54, 16, 47);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 4; ++i) {
            this.field_146292_n.add(new BuilderEraseButton(i, this.field_147003_i + 178 + 18 * i, this.field_147009_r + 197, 18, 18));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        if (this.selectedButton != null && eventType == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    private class BuilderEraseButton
    extends GuiButton {
        private boolean clicked;

        public BuilderEraseButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
        }

        public boolean func_146116_c(Minecraft mc, int x, int y) {
            if (super.func_146116_c(mc, x, y)) {
                GuiBuilder.this.selectedButton = this;
                this.clicked = true;
                BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)GuiBuilder.this.builder, "eraseFluidTank", new CommandWriter(){

                    public void write(ByteBuf data) {
                        data.writeInt(BuilderEraseButton.this.field_146127_k);
                    }
                }));
                return true;
            }
            return false;
        }

        public void func_146118_a(int x, int y) {
            super.func_146118_a(x, y);
            this.clicked = false;
        }

        public void func_146112_a(Minecraft mc, int x, int y) {
            if (!this.field_146125_m) {
                return;
            }
            this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
            mc.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, (this.clicked ? 1 : (this.field_146123_n ? 2 : 0)) * 18, 18, 18);
            this.func_146119_b(mc, x, y);
        }
    }
}

