/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.builders.EntityMechanicalArm;
import buildcraft.core.Box;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.utils.BlockMiner;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class TileQuarry
extends TileAbstractBuilder
implements IHasWork,
ISidedInventory,
IDropControlInventory,
IPipeConnection,
IControllable,
ILEDProvider {
    public EntityMechanicalArm arm;
    public EntityPlayer placedBy;
    protected Box box = new Box();
    private int targetX;
    private int targetY;
    private int targetZ;
    private double headPosX;
    private double headPosY;
    private double headPosZ;
    private double speed = 0.03;
    private Stage stage = Stage.BUILDING;
    private boolean movingHorizontally;
    private boolean movingVertically;
    private float headTrajectory;
    private SafeTimeTracker updateTracker = new SafeTimeTracker((long)BuildCraftCore.updateFactor);
    private BptBuilderBase builder;
    private final LinkedList<int[]> visitList = Lists.newLinkedList();
    private boolean loadDefaultBoundaries = false;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean frameProducer = true;
    private NBTTagCompound initNBT = null;
    private BlockMiner miner;
    private int ledState;

    public TileQuarry() {
        this.box.kind = Box.Kind.STRIPES;
        this.setBattery(new RFBattery((int)(20480.0f * BuildCraftCore.miningMultiplier), (int)(1000.0f * BuildCraftCore.miningMultiplier), 0));
    }

    public void createUtilsIfNeeded() {
        if (!this.field_145850_b.field_72995_K && this.builder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBlueprintBuilder();
        }
        if (this.stage != Stage.BUILDING) {
            this.box.isVisible = false;
            if (this.arm == null) {
                this.createArm();
            }
            if (this.findTarget(false) && (this.headPosX < (double)this.box.xMin || this.headPosX > (double)this.box.xMax || this.headPosZ < (double)this.box.zMin || this.headPosZ > (double)this.box.zMax)) {
                this.setHead(this.box.xMin + 1, this.field_145848_d + 2, this.box.zMin + 1);
            }
        } else {
            this.box.isVisible = true;
        }
    }

    private void createArm() {
        this.field_145850_b.func_72838_d((Entity)new EntityMechanicalArm(this.field_145850_b, (float)this.box.xMin + 0.75f, (float)(this.field_145848_d + this.box.sizeY() - 1) + 0.25f, (float)this.box.zMin + 0.75f, (float)(this.box.sizeX() - 2) + 0.5f, (float)(this.box.sizeZ() - 2) + 0.5f, this));
    }

    public void setArm(EntityMechanicalArm arm) {
        this.arm = arm;
    }

    public boolean areChunksLoaded() {
        if (!BuildCraftBuilders.quarryLoadsChunks) {
            for (int chunkX = this.box.xMin >> 4; chunkX <= this.box.xMax >> 4; ++chunkX) {
                for (int chunkZ = this.box.zMin >> 4; chunkZ <= this.box.zMax >> 4; ++chunkZ) {
                    if (this.field_145850_b.func_72899_e(chunkX << 4, this.box.yMax, chunkZ << 4)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.stage != Stage.DONE) {
                this.moveHead(this.speed);
            }
            return;
        }
        if (this.stage == Stage.DONE) {
            if (this.mode == IControllable.Mode.Loop) {
                this.stage = Stage.IDLE;
            } else {
                return;
            }
        }
        if (!this.areChunksLoaded()) {
            return;
        }
        if (this.mode == IControllable.Mode.Off && this.stage != Stage.MOVING) {
            return;
        }
        this.createUtilsIfNeeded();
        if (this.stage == Stage.BUILDING) {
            if (this.builder != null && !this.builder.isDone((IBuildingItemsProvider)this)) {
                this.builder.buildNextSlot(this.field_145850_b, (TileAbstractBuilder)this, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
            } else {
                this.stage = Stage.IDLE;
            }
        } else if (this.stage == Stage.DIGGING) {
            this.dig();
        } else {
            if (this.stage == Stage.IDLE) {
                this.idling();
                return;
            }
            if (this.stage == Stage.MOVING) {
                int energyUsed = this.getBattery().useEnergy(20, (int)Math.ceil(20.0 + (double)this.getBattery().getEnergyStored() / 10.0), false);
                if (energyUsed >= 20) {
                    this.speed = 0.1 + (double)((float)energyUsed / 2000.0f);
                    if (this.field_145850_b.func_72896_J()) {
                        int headBPX = (int)this.headPosX;
                        int headBPY = (int)this.headPosY;
                        int headBPZ = (int)this.headPosZ;
                        if (this.field_145850_b.func_72976_f(headBPX, headBPZ) < headBPY) {
                            this.speed *= 0.7;
                        }
                    }
                    this.moveHead(this.speed);
                } else {
                    this.speed = 0.0;
                }
            }
        }
        if (this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
    }

    protected void dig() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.miner == null) {
            this.stage = Stage.IDLE;
            return;
        }
        int rfTaken = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
        this.getBattery().useEnergy(rfTaken, rfTaken, false);
        if (this.miner.hasMined()) {
            double[] head = this.getHead();
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(head[0] - 2.0), (double)(head[1] - 2.0), (double)(head[2] - 2.0), (double)(head[0] + 3.0), (double)(head[1] + 3.0), (double)(head[2] + 3.0));
            List result = this.field_145850_b.func_72872_a(EntityItem.class, axis);
            for (EntityItem entity : result) {
                if (entity.field_70128_L) continue;
                ItemStack mineable = entity.func_92059_d();
                if (mineable.field_77994_a <= 0) continue;
                CoreProxy.proxy.removeEntity((Entity)entity);
                this.miner.mineStack(mineable);
            }
        }
        if (this.miner.hasMined() || this.miner.hasFailed()) {
            this.miner = null;
            if (!this.findFrame()) {
                this.initializeBlueprintBuilder();
                this.stage = Stage.BUILDING;
            } else {
                this.stage = Stage.IDLE;
            }
        }
    }

    protected boolean findFrame() {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection o = ForgeDirection.getOrientation((int)i);
            if (!this.box.contains(this.field_145851_c + o.offsetX, this.field_145848_d + o.offsetY, this.field_145849_e + o.offsetZ)) continue;
            return this.field_145850_b.func_147439_a(this.field_145851_c + o.offsetX, this.field_145848_d + o.offsetY, this.field_145849_e + o.offsetZ) == BuildCraftBuilders.frameBlock;
        }
        return true;
    }

    protected void idling() {
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.setTarget(this.box.xMin + 1, this.field_145848_d + 2, this.box.zMin + 1);
            }
            this.stage = Stage.DONE;
        } else {
            this.stage = Stage.MOVING;
        }
        this.movingHorizontally = true;
        this.movingVertically = true;
        double[] head = this.getHead();
        int[] target = this.getTarget();
        this.headTrajectory = (float)Math.atan2((double)target[2] - head[2], (double)target[0] - head[0]);
        this.sendNetworkUpdate();
    }

    public boolean findTarget(boolean doSet) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        boolean columnVisitListIsUpdated = false;
        if (this.visitList.isEmpty()) {
            this.createColumnVisitList();
            columnVisitListIsUpdated = true;
        }
        if (!doSet) {
            return !this.visitList.isEmpty();
        }
        if (this.visitList.isEmpty()) {
            return false;
        }
        int[] nextTarget = this.visitList.removeFirst();
        if (!columnVisitListIsUpdated) {
            for (int y = nextTarget[1] + 1; y < this.field_145848_d + 3; ++y) {
                if (!this.isQuarriableBlock(nextTarget[0], y, nextTarget[2])) continue;
                this.createColumnVisitList();
                columnVisitListIsUpdated = true;
                nextTarget = null;
                break;
            }
        }
        if (columnVisitListIsUpdated && nextTarget == null && !this.visitList.isEmpty()) {
            nextTarget = this.visitList.removeFirst();
        } else if (columnVisitListIsUpdated && nextTarget == null) {
            return false;
        }
        this.setTarget(nextTarget[0], nextTarget[1] + 1, nextTarget[2]);
        return true;
    }

    private void createColumnVisitList() {
        this.visitList.clear();
        boolean[][] blockedColumns = new boolean[this.builder.blueprint.sizeX - 2][this.builder.blueprint.sizeZ - 2];
        for (int searchY = this.field_145848_d + 3; searchY >= 1; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.builder.blueprint.sizeX - 2;
                incX = 1;
            } else {
                startX = this.builder.blueprint.sizeX - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.builder.blueprint.sizeZ - 2;
                    incZ = 1;
                } else {
                    startZ = this.builder.blueprint.sizeZ - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    int bx = this.box.xMin + searchX + 1;
                    int by = searchY;
                    int bz = this.box.zMin + searchZ + 1;
                    Block block = this.field_145850_b.func_147439_a(bx, by, bz);
                    if (!BlockUtils.canChangeBlock((Block)block, (World)this.field_145850_b, (int)bx, (int)by, (int)bz)) {
                        blockedColumns[searchX][searchZ] = true;
                    } else if (!(BuildCraftAPI.isSoftBlock((World)this.field_145850_b, (int)bx, (int)by, (int)bz) || block instanceof BlockLiquid || block instanceof IFluidBlock)) {
                        this.visitList.add(new int[]{bx, by, bz});
                    }
                    if (this.visitList.size() <= this.builder.blueprint.sizeZ * this.builder.blueprint.sizeX * 2) continue;
                    return;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.func_74764_b("xSize")) {
            int xMin = nbttagcompound.func_74762_e("xMin");
            int zMin = nbttagcompound.func_74762_e("zMin");
            int xSize = nbttagcompound.func_74762_e("xSize");
            int ySize = nbttagcompound.func_74762_e("ySize");
            int zSize = nbttagcompound.func_74762_e("zSize");
            this.box.initialize(xMin, this.field_145848_d, zMin, xMin + xSize - 1, this.field_145848_d + ySize - 1, zMin + zSize - 1);
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.headPosX = nbttagcompound.func_74769_h("headPosX");
        this.headPosY = nbttagcompound.func_74769_h("headPosY");
        this.headPosZ = nbttagcompound.func_74769_h("headPosZ");
        this.initNBT = (NBTTagCompound)nbttagcompound.func_74775_l("bpt").func_74737_b();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74780_a("headPosX", this.headPosX);
        nbttagcompound.func_74780_a("headPosY", this.headPosY);
        nbttagcompound.func_74780_a("headPosZ", this.headPosZ);
        NBTTagCompound boxTag = new NBTTagCompound();
        this.box.writeToNBT(boxTag);
        nbttagcompound.func_74782_a("box", (NBTBase)boxTag);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.builder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.builder.saveBuildStateToNBT(builderCpt, (IBuildingItemsProvider)this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbttagcompound.func_74782_a("bpt", (NBTBase)bptNBT);
    }

    public void positionReached() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isQuarriableBlock(this.targetX, this.targetY - 1, this.targetZ)) {
            this.miner = new BlockMiner(this.field_145850_b, (TileEntity)this, this.targetX, this.targetY - 1, this.targetZ);
            this.stage = Stage.DIGGING;
        } else {
            this.stage = Stage.IDLE;
        }
    }

    private boolean isQuarriableBlock(int bx, int by, int bz) {
        Block block = this.field_145850_b.func_147439_a(bx, by, bz);
        return BlockUtils.canChangeBlock((Block)block, (World)this.field_145850_b, (int)bx, (int)by, (int)bz) && !BuildCraftAPI.isSoftBlock((World)this.field_145850_b, (int)bx, (int)by, (int)bz) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock);
    }

    protected int getNetworkUpdateRange() {
        return DefaultProps.NETWORK_UPDATE_RANGE + (int)Math.ceil(Math.sqrt(this.field_145848_d * this.field_145848_d + this.box.sizeX() * this.box.sizeX() + this.box.sizeZ() * this.box.sizeZ()));
    }

    public void func_145843_s() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.func_145843_s();
        this.destroy();
    }

    public void onChunkUnload() {
        this.destroy();
    }

    public void destroy() {
        if (this.arm != null) {
            this.arm.func_70106_y();
        }
        this.arm = null;
        this.frameProducer = false;
        if (this.miner != null) {
            this.miner.invalidate();
        }
    }

    public boolean hasWork() {
        return this.stage != Stage.DONE;
    }

    private void setBoundaries(boolean useDefaultI) {
        boolean useDefault = useDefaultI;
        if (BuildCraftBuilders.quarryLoadsChunks && this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)((Object)BuildCraftBuilders.instance), (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket != null) {
            this.chunkTicket.getModData().func_74768_a("quarryX", this.field_145851_c);
            this.chunkTicket.getModData().func_74768_a("quarryY", this.field_145848_d);
            this.chunkTicket.getModData().func_74768_a("quarryZ", this.field_145849_e);
        }
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c + 10, this.field_145848_d + 4, this.field_145849_e + 10);
            useDefault = true;
        }
        int xSize = a.xMax() - a.xMin() + 1;
        int zSize = a.zMax() - a.zMin() + 1;
        if (xSize < 3 || zSize < 3 || this.chunkTicket != null && xSize * zSize >> 8 >= this.chunkTicket.getMaxChunkListDepth()) {
            if (this.placedBy != null) {
                this.placedBy.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.buildcraft.quarry.tooSmall", new Object[]{xSize, zSize, this.chunkTicket != null ? this.chunkTicket.getMaxChunkListDepth() : 0}));
            }
            a = new DefaultAreaProvider(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c + 10, this.field_145848_d + 4, this.field_145849_e + 10);
            useDefault = true;
        }
        xSize = a.xMax() - a.xMin() + 1;
        int ySize = a.yMax() - a.yMin() + 1;
        zSize = a.zMax() - a.zMin() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.yMax = this.box.yMin + ySize - 1;
        }
        if (useDefault) {
            int zMin;
            int xMin;
            int dir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ForgeDirection o = ForgeDirection.getOrientation((int)(dir > 6 ? 6 : dir)).getOpposite();
            switch (o) {
                case EAST: {
                    xMin = this.field_145851_c + 1;
                    zMin = this.field_145849_e - 4 - 1;
                    break;
                }
                case WEST: {
                    xMin = this.field_145851_c - 9 - 2;
                    zMin = this.field_145849_e - 4 - 1;
                    break;
                }
                case SOUTH: {
                    xMin = this.field_145851_c - 4 - 1;
                    zMin = this.field_145849_e + 1;
                    break;
                }
                default: {
                    xMin = this.field_145851_c - 4 - 1;
                    zMin = this.field_145849_e - 9 - 2;
                }
            }
            this.box.initialize(xMin, this.field_145848_d, zMin, xMin + xSize - 1, this.field_145848_d + ySize - 1, zMin + zSize - 1);
        }
        a.removeFromWorld();
        if (this.chunkTicket != null) {
            this.forceChunkLoading(this.chunkTicket);
        }
        this.sendNetworkUpdate();
    }

    private void initializeBlueprintBuilder() {
        Blueprint bpt = ((FillerPattern)FillerManager.registry.getPattern("buildcraft:frame")).getBlueprint(this.box, this.field_145850_b, new IStatementParameter[0], (Block)BuildCraftBuilders.frameBlock, 0);
        if (bpt != null) {
            this.builder = new BptBuilderBlueprint(bpt, this.field_145850_b, this.box.xMin, this.field_145848_d, this.box.zMin);
            this.speed = 0.0;
            this.stage = Stage.BUILDING;
            this.sendNetworkUpdate();
        }
    }

    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        stream.writeInt(this.targetX);
        stream.writeShort(this.targetY);
        stream.writeInt(this.targetZ);
        stream.writeDouble(this.headPosX);
        stream.writeDouble(this.headPosY);
        stream.writeDouble(this.headPosZ);
        stream.writeFloat((float)this.speed);
        stream.writeFloat(this.headTrajectory);
        int flags = this.stage.ordinal();
        flags |= this.movingHorizontally ? 16 : 0;
        stream.writeByte(flags |= this.movingVertically ? 32 : 0);
        this.ledState = (this.hasWork() && this.mode != IControllable.Mode.Off && this.getTicksSinceEnergyReceived() < 12 ? 16 : 0) | this.getBattery().getEnergyStored() * 15 / this.getBattery().getMaxEnergyStored();
        stream.writeByte(this.ledState);
    }

    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        this.targetX = stream.readInt();
        this.targetY = stream.readUnsignedShort();
        this.targetZ = stream.readInt();
        this.headPosX = stream.readDouble();
        this.headPosY = stream.readDouble();
        this.headPosZ = stream.readDouble();
        this.speed = stream.readFloat();
        this.headTrajectory = stream.readFloat();
        short flags = stream.readUnsignedByte();
        this.stage = Stage.values()[flags & 7];
        this.movingHorizontally = (flags & 0x10) != 0;
        this.movingVertically = (flags & 0x20) != 0;
        short newLedState = stream.readUnsignedByte();
        if (newLedState != this.ledState) {
            this.ledState = newLedState;
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.func_145831_w().field_72995_K && !this.box.initialized) {
            this.setBoundaries(false);
        }
        this.createUtilsIfNeeded();
        if (this.initNBT != null && this.builder != null) {
            this.builder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), (IBuildingItemsProvider)this);
        }
        this.initNBT = null;
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.initializeBlueprintBuilder();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftBuilders.frameBlock);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftBuilders.frameBlock, j);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    public void moveHead(double instantSpeed) {
        int[] target = this.getTarget();
        double[] head = this.getHead();
        if (this.movingHorizontally) {
            if (Math.abs((double)target[0] - head[0]) < instantSpeed * 2.0 && Math.abs((double)target[2] - head[2]) < instantSpeed * 2.0) {
                head[0] = target[0];
                head[2] = target[2];
                this.movingHorizontally = false;
                if (!this.movingVertically) {
                    this.positionReached();
                    head[1] = target[1];
                }
            } else {
                head[0] = head[0] + (double)MathHelper.func_76134_b((float)this.headTrajectory) * instantSpeed;
                head[2] = head[2] + (double)MathHelper.func_76126_a((float)this.headTrajectory) * instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        if (this.movingVertically) {
            if (Math.abs((double)target[1] - head[1]) < instantSpeed * 2.0) {
                head[1] = target[1];
                this.movingVertically = false;
                if (!this.movingHorizontally) {
                    this.positionReached();
                    head[0] = target[0];
                    head[2] = target[2];
                }
            } else {
                head[1] = (double)target[1] > head[1] ? head[1] + instantSpeed : head[1] - instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.arm != null && this.field_145850_b.field_72995_K) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    private void setHead(double x, double y, double z) {
        this.headPosX = x;
        this.headPosY = y;
        this.headPosZ = z;
    }

    private double[] getHead() {
        return new double[]{this.headPosX, this.headPosY, this.headPosZ};
    }

    private int[] getTarget() {
        return new int[]{this.targetX, this.targetY, this.targetZ};
    }

    private void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
        for (int chunkX = this.box.xMin >> 4; chunkX <= this.box.xMax >> 4; ++chunkX) {
            for (int chunkZ = this.box.zMin >> 4; chunkZ <= this.box.zMax >> 4; ++chunkZ) {
                ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                chunks.add(chunk);
            }
        }
        if (this.placedBy != null && !(this.placedBy instanceof FakePlayer)) {
            this.placedBy.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.buildcraft.quarry.chunkloadInfo", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, chunks.size()}));
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box((TileEntity)this).extendToEncompass(this.box).expand(50).getBoundingBox();
    }

    public Box getBox() {
        return this.box;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int p1, ItemStack p2, int p3) {
        return false;
    }

    public boolean func_102008_b(int p1, ItemStack p2, int p3) {
        return false;
    }

    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On || mode == IControllable.Mode.Loop;
    }

    public boolean doDrop() {
        return false;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public int getLEDLevel(int led) {
        if (led == 0) {
            return this.ledState & 0xF;
        }
        return this.ledState >> 4 > 0 ? 15 : 0;
    }

    private static enum Stage {
        BUILDING,
        DIGGING,
        MOVING,
        IDLE,
        DONE;

    }
}

