/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.ItemBlueprint;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileConstructionMarker
extends TileBuildCraft
implements IBuildingItemsProvider,
IBoxProvider,
ICommandReceiver {
    public static HashSet<TileConstructionMarker> currentMarkers = new HashSet();
    public ForgeDirection direction = ForgeDirection.UNKNOWN;
    public LaserData laser;
    public ItemStack itemBlueprint;
    public Box box = new Box();
    public BptBuilderBase bluePrintBuilder;
    public BptContext bptContext;
    private ArrayList<BuildingItem> buildersInAction = new ArrayList();
    private NBTTagCompound initNBT;

    public void initialize() {
        super.initialize();
        this.box.kind = Box.Kind.BLUE_STRIPES;
        if (this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "uploadBuildersInAction", null));
        }
    }

    private Packet createLaunchItemPacket(final BuildingItem i) {
        return new PacketCommand((Object)this, "launchItem", new CommandWriter(){

            public void write(ByteBuf data) {
                i.writeData(data);
            }
        });
    }

    public void func_145845_h() {
        super.func_145845_h();
        BuildingItem toRemove = null;
        for (BuildingItem i : this.buildersInAction) {
            i.update();
            if (!i.isDone) continue;
            toRemove = i;
        }
        if (toRemove != null) {
            this.buildersInAction.remove(toRemove);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.itemBlueprint != null && ItemBlueprint.getId(this.itemBlueprint) != null && this.bluePrintBuilder == null) {
            BlueprintBase bpt = ItemBlueprint.loadBlueprint(this.itemBlueprint);
            if (bpt != null && bpt instanceof Blueprint) {
                if ((bpt = bpt.adjustToWorld(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.direction)) != null) {
                    this.bluePrintBuilder = new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.bptContext = this.bluePrintBuilder.getContext();
                    this.box.initialize((IAreaProvider)this.bluePrintBuilder);
                    this.sendNetworkUpdate();
                }
            } else {
                return;
            }
        }
        if (this.laser == null && this.direction != ForgeDirection.UNKNOWN) {
            this.laser = new LaserData();
            this.laser.head = new Position((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f));
            this.laser.tail = new Position((double)((float)this.field_145851_c + 0.5f + (float)this.direction.offsetX * 0.5f), (double)((float)this.field_145848_d + 0.5f + (float)this.direction.offsetY * 0.5f), (double)((float)this.field_145849_e + 0.5f + (float)this.direction.offsetZ * 0.5f));
            this.laser.isVisible = true;
            this.sendNetworkUpdate();
        }
        if (this.initNBT != null) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), (IBuildingItemsProvider)this);
            }
            this.initNBT = null;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound bptNBT;
        super.func_145841_b(nbt);
        nbt.func_74774_a("direction", (byte)this.direction.ordinal());
        if (this.itemBlueprint != null) {
            bptNBT = new NBTTagCompound();
            this.itemBlueprint.func_77955_b(bptNBT);
            nbt.func_74782_a("itemBlueprint", (NBTBase)bptNBT);
        }
        bptNBT = new NBTTagCompound();
        if (this.bluePrintBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.bluePrintBuilder.saveBuildStateToNBT(builderCpt, (IBuildingItemsProvider)this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbt.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.direction = ForgeDirection.getOrientation((int)nbt.func_74771_c("direction"));
        if (nbt.func_74764_b("itemBlueprint")) {
            this.itemBlueprint = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemBlueprint"));
        }
        this.initNBT = (NBTTagCompound)nbt.func_74775_l("bptBuilder").func_74737_b();
    }

    public void setBlueprint(ItemStack currentItem) {
        this.itemBlueprint = currentItem;
        this.sendNetworkUpdate();
    }

    public ArrayList<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.add(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.remove((Object)this);
        }
    }

    public boolean needsToBuild() {
        return !this.func_145837_r() && this.bluePrintBuilder != null && !this.bluePrintBuilder.isDone((IBuildingItemsProvider)this);
    }

    public BptContext getContext() {
        return this.bptContext;
    }

    public void addAndLaunchBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        BuildCraftCore.instance.sendToPlayersNear(this.createLaunchItemPacket(item), (TileEntity)this);
    }

    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "uploadBuildersInAction".equals(command)) {
            for (BuildingItem i : this.buildersInAction) {
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, this.createLaunchItemPacket(i));
            }
        } else if (side.isClient() && "launchItem".equals(command)) {
            BuildingItem item = new BuildingItem();
            item.readData(stream);
            this.buildersInAction.add(item);
        }
    }

    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box((TileEntity)this).extendToEncompass(this.box);
        return renderBox.expand(50).getBoundingBox();
    }

    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        stream.writeByte((this.laser != null ? 1 : 0) | (this.itemBlueprint != null ? 2 : 0));
        if (this.laser != null) {
            this.laser.writeData(stream);
        }
        if (this.itemBlueprint != null) {
            NetworkUtils.writeStack((ByteBuf)stream, (ItemStack)this.itemBlueprint);
        }
    }

    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        short flags = stream.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.laser = new LaserData();
            this.laser.readData(stream);
        } else {
            this.laser = null;
        }
        this.itemBlueprint = (flags & 2) != 0 ? NetworkUtils.readStack((ByteBuf)stream) : null;
    }
}

