/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.items.IBlueprintItem;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.StringUtils;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public abstract class ItemBlueprint
extends ItemBuildCraft
implements IBlueprintItem {
    public ItemBlueprint() {
        super((CreativeTabs)BCCreativeTab.get((String)"main"));
    }

    public String getName(ItemStack stack) {
        return NBTUtils.getItemData((ItemStack)stack).func_74779_i("name");
    }

    public boolean setName(ItemStack stack, String name) {
        NBTUtils.getItemData((ItemStack)stack).func_74778_a("name", name);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        boolean isComplete;
        if (NBTUtils.getItemData((ItemStack)stack).func_74764_b("name")) {
            String name = NBTUtils.getItemData((ItemStack)stack).func_74779_i("name");
            if ("".equals(name)) {
                list.add(StringUtils.localize((String)"item.blueprint.unnamed"));
            } else {
                list.add(name);
            }
            list.add(StringUtils.localize((String)"item.blueprint.author") + " " + NBTUtils.getItemData((ItemStack)stack).func_74779_i("author"));
        } else {
            list.add(StringUtils.localize((String)"item.blueprint.blank"));
        }
        if (NBTUtils.getItemData((ItemStack)stack).func_74764_b("permission")) {
            BuildingPermission p = BuildingPermission.values()[NBTUtils.getItemData((ItemStack)stack).func_74771_c("permission")];
            if (p == BuildingPermission.CREATIVE_ONLY) {
                list.add(StringUtils.localize((String)"item.blueprint.creative_only"));
            } else if (p == BuildingPermission.NONE) {
                list.add(StringUtils.localize((String)"item.blueprint.no_build"));
            }
        }
        if (NBTUtils.getItemData((ItemStack)stack).func_74764_b("isComplete") && !(isComplete = NBTUtils.getItemData((ItemStack)stack).func_74767_n("isComplete"))) {
            list.add(StringUtils.localize((String)"item.blueprint.incomplete"));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData((ItemStack)stack).func_74764_b("name") ? 1 : 16;
    }

    public abstract String getIconType();

    public String[] getIconNames() {
        return new String[]{this.getIconType() + "/clean", this.getIconType() + "/used"};
    }

    public IIcon func_77650_f(ItemStack stack) {
        this.field_77791_bV = !NBTUtils.getItemData((ItemStack)stack).func_74764_b("name") ? this.icons[0] : this.icons[1];
        return this.field_77791_bV;
    }

    public static boolean isContentReadable(ItemStack stack) {
        return ItemBlueprint.getId(stack) != null;
    }

    public static LibraryId getId(ItemStack stack) {
        NBTTagCompound nbt = NBTUtils.getItemData((ItemStack)stack);
        if (nbt == null) {
            return null;
        }
        LibraryId id = new LibraryId();
        id.read(nbt);
        if (BuildCraftBuilders.serverDB.exists(id)) {
            return id;
        }
        return null;
    }

    public static BlueprintBase loadBlueprint(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IBlueprintItem)) {
            return null;
        }
        LibraryId id = ItemBlueprint.getId(stack);
        if (id == null) {
            return null;
        }
        NBTTagCompound nbt = BuildCraftBuilders.serverDB.load(id);
        Object base = ((IBlueprintItem)stack.func_77973_b()).getType(stack) == IBlueprintItem.Type.TEMPLATE ? new Template() : new Blueprint();
        base.readFromNBT(nbt);
        base.id = id;
        return base;
    }
}

