/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicFluid;
import buildcraft.builders.schematics.SchematicStairs;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.schematics.SchematicBlockFloored;
import buildcraft.core.builders.schematics.SchematicIgnore;
import buildcraft.core.builders.schematics.SchematicTileCreative;
import buildcraft.core.builders.schematics.SchematicWallSide;
import buildcraft.core.lib.utils.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidStack;

public final class HeuristicBlockDetection {
    private HeuristicBlockDetection() {
    }

    public static void start() {
        for (Block block : Block.field_149771_c) {
            if (block == null || block == Blocks.field_150350_a) continue;
            for (int meta = 0; meta < 16; ++meta) {
                if (SchematicRegistry.INSTANCE.isSupported(block, meta)) continue;
                try {
                    if (block.hasTileEntity(meta)) {
                        SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicTileCreative.class, new Object[0]);
                        continue;
                    }
                    try {
                        if (block instanceof BlockDynamicLiquid) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicIgnore.class, new Object[0]);
                            continue;
                        }
                        if (block instanceof BlockBush || block instanceof IPlantable || block instanceof IGrowable || block instanceof BlockBasePressurePlate) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlockFloored.class, new Object[0]);
                            continue;
                        }
                        if (block instanceof BlockLever || block instanceof BlockTorch || block instanceof BlockButton) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicWallSide.class, new Object[0]);
                            continue;
                        }
                        if (block instanceof BlockStairs) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicStairs.class, new Object[0]);
                            continue;
                        }
                        FluidStack fstack = FluidUtils.getFluidStackFromBlock((Block)block);
                        if (fstack != null) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicFluid.class, new Object[]{fstack});
                            continue;
                        }
                        SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlock.class, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

