/*
 * Decompiled with CFR 0.152.
 */
package info.mmpa.pipeblocker;

import info.mmpa.pipeblocker.CheckStatus;
import info.mmpa.pipeblocker.FilterHook;
import info.mmpa.pipeblocker.FilterMatchType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PipeBlocker {
    private static final Logger LOGGER = LogManager.getLogger((String)"PipeBlocker");
    private static final List<Pattern> allowedPatterns = new ArrayList<Pattern>();
    private static final List<Pattern> rejectedPatterns = new ArrayList<Pattern>();
    private static final List<Pattern> softAllowedPatterns = new ArrayList<Pattern>();
    private static final HashMap<Class<?>, CheckStatus> cache = new HashMap();
    private static final Set<Class<?>> REJECTED_CLASSES = Collections.synchronizedSet(new HashSet());
    private static int numEntriesLoaded = 0;
    private static String filterURL = "https://minecraft-malware-prevention-alliance.github.io/PipeBlocker/pipeblocker_filter.txt?t=" + new Date().getTime();
    private static boolean logOnly = Objects.equals(System.getProperty("info.mmpa.pipeblocker.log-only"), "true");
    private static FilterHook filterHook = null;
    private static boolean initialized = false;
    private static boolean allowUnsafe = false;

    private static void clearFilter() {
        numEntriesLoaded = 0;
        allowedPatterns.clear();
        rejectedPatterns.clear();
        softAllowedPatterns.clear();
        cache.clear();
    }

    private static void loadFilter() {
        try (InputStream filterStream = new URL(filterURL).openStream();){
            PipeBlocker.processFilter(filterStream);
            LOGGER.info("Successfully loaded online PipeBlocker filter with {} entries.", new Object[]{numEntriesLoaded});
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load online filter, using local version", (Throwable)e);
            try (InputStream localFilterStream = PipeBlocker.class.getResourceAsStream("/pipeblocker_filter.txt");){
                if (localFilterStream == null) {
                    throw new FileNotFoundException("pipeblocker_filter.txt");
                }
                PipeBlocker.processFilter(localFilterStream);
                LOGGER.info("Successfully loaded local PipeBlocker filter with {} entries.", new Object[]{numEntriesLoaded});
            }
            catch (IOException e2) {
                LOGGER.error("Failed to load local filter, this will mean no deserialization is permitted", (Throwable)e2);
            }
        }
        if (!allowUnsafe && (PipeBlocker.isMatchingName("info.mmpa.pipeblocker.test.UnsafeObject", allowedPatterns) || PipeBlocker.isMatchingName("info.mmpa.pipeblocker.test.UnsafeObject", softAllowedPatterns) || !PipeBlocker.isMatchingName("info.mmpa.pipeblocker.test.UnsafeObject", rejectedPatterns))) {
            throw new RuntimeException("Broken PipeBlocker list detected -- please file an issue!");
        }
    }

    private static void processFilter(InputStream filterStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(filterStream));){
            PipeBlocker.clearFilter();
            String line = reader.readLine();
            while (line != null) {
                PipeBlocker.processLine(line.trim());
                line = reader.readLine();
            }
        }
    }

    private static void processLine(String line) {
        if (line.length() == 0 || line.charAt(0) == '#') {
            return;
        }
        String type = null;
        List<Pattern> list = null;
        switch (line.charAt(0)) {
            case '+': {
                type = "allow";
                list = allowedPatterns;
                break;
            }
            case '-': {
                type = "deny";
                list = rejectedPatterns;
                break;
            }
            case '~': {
                type = "soft allow";
                list = softAllowedPatterns;
            }
        }
        if (list != null) {
            String glob = line.substring(1);
            LOGGER.debug("Adding {} rule for glob '{}'", new Object[]{type, glob});
            Pattern desiredPattern = Pattern.compile(PipeBlocker.convertGlobToRegex(glob));
            list.add(desiredPattern);
            ++numEntriesLoaded;
        }
    }

    private static Stream<Class<?>> inheritanceStream(Class<?> clz) {
        if (clz == null) {
            return Stream.empty();
        }
        Stream.Builder<Class<?>> streamBuilder = Stream.builder();
        while (clz != null) {
            streamBuilder.add(clz);
            clz = clz.getSuperclass();
        }
        return streamBuilder.build();
    }

    private static boolean isMatchingName(String name, List<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(name).matches()) continue;
            System.out.println(p + " " + name);
            return true;
        }
        return false;
    }

    private static FilterMatchType matchClass(Class<?> clazz) {
        if (PipeBlocker.inheritanceStream(clazz).map(Class::getCanonicalName).anyMatch(n -> PipeBlocker.isMatchingName(n, rejectedPatterns))) {
            return FilterMatchType.REJECT;
        }
        if (PipeBlocker.inheritanceStream(clazz).map(Class::getCanonicalName).anyMatch(n -> PipeBlocker.isMatchingName(n, allowedPatterns))) {
            return FilterMatchType.ALLOW;
        }
        if (PipeBlocker.isMatchingName(clazz.getCanonicalName(), softAllowedPatterns)) {
            return FilterMatchType.SOFT_ALLOW;
        }
        return FilterMatchType.DEFAULT;
    }

    public static CheckStatus check(Class<?> clazz) {
        CheckStatus status;
        if (clazz == null) {
            return CheckStatus.UNDECIDED;
        }
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        Class<?> underlyingClass = clazz;
        while (underlyingClass.isArray()) {
            underlyingClass = underlyingClass.getComponentType();
        }
        FilterMatchType matchType = PipeBlocker.matchClass(underlyingClass);
        if (matchType == FilterMatchType.SOFT_ALLOW || matchType == FilterMatchType.ALLOW) {
            CheckStatus status2 = CheckStatus.UNDECIDED;
            if (filterHook != null) {
                status2 = filterHook.check(underlyingClass, matchType, status2);
            }
            cache.put(clazz, status2);
            return status2;
        }
        CheckStatus checkStatus = status = logOnly ? CheckStatus.UNDECIDED : CheckStatus.REJECTED;
        if (filterHook != null) {
            status = filterHook.check(underlyingClass, matchType, status);
        }
        if (filterHook != null && REJECTED_CLASSES.add(underlyingClass)) {
            LOGGER.warn("Blocked class {} from being deserialized as it's not allowed", new Object[]{underlyingClass.getName()});
        }
        cache.put(clazz, status);
        return status;
    }

    public static void apply() {
        String className;
        if (initialized) {
            throw new RuntimeException("PipeBlocker is already initialized!");
        }
        initialized = true;
        if (Objects.equals(System.getProperty("info.mmpa.pipeblocker.log-only"), "true")) {
            LOGGER.fatal("**************************************************************");
            LOGGER.fatal("*  WARNING: You are running PipeBlocker with log only mode.  *");
            LOGGER.fatal("*                                                            *");
            LOGGER.fatal("* This means the protections of PipeBlocker are disabled and *");
            LOGGER.fatal("* would be blocked deserialization attempts are only logged. *");
            LOGGER.fatal("* While this useful for figuring out what is broken, you     *");
            LOGGER.fatal("* SHOULD NOT use this mode while playing on multiplayer      *");
            LOGGER.fatal("* servers.                                                   *");
            LOGGER.fatal("*                                                            *");
            LOGGER.fatal("* You should disable this unless you are trying to figure    *");
            LOGGER.fatal("* out what mod is causing issues using the instructions on   *");
            LOGGER.fatal("* GitHub, or you were asked to on our issue tracker.         *");
            LOGGER.fatal("**************************************************************");
        }
        PipeBlocker.loadFilter();
        String javaVersion = System.getProperties().getProperty("java.specification.version");
        if ("1.8".equals(javaVersion)) {
            className = "info.mmpa.pipeblocker.java8.FilterSetter";
        } else if (javaVersion.chars().allMatch(Character::isDigit) && Integer.parseInt(javaVersion) > 8) {
            className = "info.mmpa.pipeblocker.java9.FilterSetter";
        } else {
            System.err.println("Unsupported java version: " + javaVersion);
            throw new RuntimeException("Unsupported java version: " + javaVersion);
        }
        try {
            Class.forName(className).getMethod("apply", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            System.out.println("Unable to invoke setter");
            throw new RuntimeException(ex);
        }
    }

    public static void setFilterURL(String url) {
        if (initialized) {
            throw new RuntimeException("Filter URL must be set before initialization");
        }
        filterURL = url;
    }

    public static void setFilterHook(FilterHook hook) {
        if (initialized) {
            throw new RuntimeException("Filter hook must be set before initialization");
        }
        filterHook = hook;
    }

    public static void setLogOnly(boolean logOnly) {
        if (initialized) {
            throw new RuntimeException("Log-only status must be set before initialization");
        }
        PipeBlocker.logOnly = logOnly;
    }

    public static void setAllowUnsafe(boolean allowUnsafe) {
        if (initialized) {
            throw new RuntimeException("Log-only status must be set before initialization");
        }
        PipeBlocker.allowUnsafe = allowUnsafe;
    }

    public static String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length() + 2);
        sb.append('^');
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

