/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.network.message;

import com.black_dog20.servertabinfo.network.message.MessageResponse;
import com.black_dog20.servertabinfo.network.message.MessageResponseServerInfo;
import com.black_dog20.servertabinfo.reference.Constants;
import com.black_dog20.servertabinfo.utility.Helper;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class MessageRequest
implements IMessage,
IMessageHandler<MessageRequest, IMessage> {
    private int version;

    public IMessage onMessage(MessageRequest message, MessageContext context) {
        ArrayList<TpsDimension> dims = new ArrayList<TpsDimension>();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        int ping = context.getServerHandler().field_147369_b.field_71138_i;
        if (message.version == 0) {
            dims.add(new TpsDimension("gui.servertabinfo.overall", (Double)(Helper.mean(server.field_71311_j) * 1.0E-6), 0));
            for (WorldServer world : server.field_71305_c) {
                String name = world.field_73011_w.func_80007_l();
                if (name.equals(null)) {
                    name = "";
                }
                dims.add(new TpsDimension(name, (Double)(Helper.mean((long[])server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6), world.field_73011_w.field_76574_g));
            }
            return new MessageResponse(dims);
        }
        dims.add(new TpsDimension("gui.servertabinfo.overall", (Double)Helper.mean(server.field_71311_j), Constants.VERSION));
        for (WorldServer world : server.field_71305_c) {
            String name = world.field_73011_w.func_80007_l();
            if (name.equals(null)) {
                name = "";
            }
            dims.add(new TpsDimension(name, (Double)Helper.mean((long[])server.worldTickTimes.get(world.field_73011_w.field_76574_g)), world.field_73011_w.field_76574_g));
        }
        return new MessageResponseServerInfo(Constants.VERSION, dims, ping);
    }

    public MessageRequest() {
    }

    public MessageRequest(int version) {
        this.version = version;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.version);
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.isReadable()) {
            this.version = buf.readInt();
        }
    }
}

