/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBasicGrowthCraft;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableBasicGrowthCraft
implements IFarmable {
    private final Block block;
    private final int matureMeta;
    private final boolean isRice;
    private final boolean isGrape;

    public FarmableBasicGrowthCraft(Block block, int matureMeta, boolean isRice, boolean isGrape) {
        this.block = block;
        this.matureMeta = matureMeta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this.block) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.matureMeta) {
            return null;
        }
        return new CropBasicGrowthCraft(world, this.block, this.matureMeta, new Vect(x, y, z), this.isRice, this.isGrape);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.func_147465_d(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

