/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource {
    public static final int SLOT_SPECIMEN = 0;
    public static final int SLOT_ANALYZE_1 = 1;
    public static final int SLOT_ANALYZE_2 = 2;
    public static final int SLOT_ANALYZE_3 = 3;
    public static final int SLOT_ANALYZE_4 = 4;
    public static final int SLOT_ANALYZE_5 = 6;
    public static final int SLOT_ENERGY = 5;
    private final ISpeciesRoot speciesRoot;

    public ItemInventoryAlyzer(ISpeciesRoot speciesRoot, EntityPlayer player, ItemStack itemstack) {
        super(player, 7, itemstack);
        this.speciesRoot = speciesRoot;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 5) {
            return ItemInventoryAlyzer.isEnergy(itemStack);
        }
        if (!this.speciesRoot.isMember(itemStack)) {
            return false;
        }
        if (this.hasSpecimen() && this.func_70301_a(slotIndex) == null) {
            return false;
        }
        if (slotIndex == 0) {
            return true;
        }
        IIndividual individual = this.speciesRoot.getMember(itemStack);
        return individual.isAnalyzed();
    }

    @Override
    public void onSlotClick(EntityPlayer player) {
        ItemStack specimen = this.func_70301_a(0);
        if (specimen == null) {
            return;
        }
        IIndividual individual = this.speciesRoot.getMember(specimen);
        if (individual == null) {
            return;
        }
        if (!individual.isAnalyzed()) {
            if (PluginManager.Module.APICULTURE.isEnabled() && !ItemInventoryAlyzer.isEnergy(this.func_70301_a(5))) {
                return;
            }
            individual.analyze();
            if (player != null) {
                IBreedingTracker breedingTracker = this.speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            individual.writeToNBT(nbttagcompound);
            specimen.func_77982_d(nbttagcompound);
            this.func_70298_a(5, 1);
        }
        this.func_70299_a(1, specimen);
        this.func_70299_a(0, null);
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.hasSpecimen()) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        }
        if (!ItemInventoryAlyzer.isEnergy(this.func_70301_a(5))) {
            errorStates.add((Object)EnumErrorCode.NO_HONEY);
        }
        return errorStates.build();
    }

    private static boolean isEnergy(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        return beeItems.honeyDrop == item || beeItems.honeydew == item;
    }

    private boolean hasSpecimen() {
        for (int i = 0; i <= 6; ++i) {
            ItemStack itemStack;
            if (i == 5 || (itemStack = this.func_70301_a(i)) == null) continue;
            return true;
        }
        return false;
    }
}

