/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.mixin.MixinInfoCompatCompanion;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.launchwrapper.Launch;

@StableAPI(since="0.10.2")
public final class MixinInfo {
    @StableAPI.Expose
    public static final MixinBootstrapperType mixinBootstrapper;

    @StableAPI.Expose
    public static boolean isMixinsInstalled() {
        return mixinBootstrapper != MixinBootstrapperType.None;
    }

    @StableAPI.Expose
    public static boolean isOfficialSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.11");
    }

    @StableAPI.Expose
    public static boolean isTamperedSpongeMixins() {
        return mixinBootstrapper == MixinBootstrapperType.SpongeMixins && MixinInfo.getVerUnsafe().equals("0.7.12");
    }

    @StableAPI.Expose
    public static boolean isGrimoire() {
        return mixinBootstrapper == MixinBootstrapperType.Grimoire;
    }

    @StableAPI.Expose
    public static boolean isMixinBooterLegacy() {
        return mixinBootstrapper == MixinBootstrapperType.MixinBooterLegacy;
    }

    @StableAPI.Expose(since="0.10.14")
    public static boolean isGasStation() {
        return mixinBootstrapper == MixinBootstrapperType.GasStation;
    }

    @StableAPI.Expose(since="0.10.15")
    public static boolean isUniMixin() {
        return mixinBootstrapper == MixinBootstrapperType.UniMixin;
    }

    @StableAPI.Expose
    public static MixinBootstrapperType bootstrapperType() {
        return mixinBootstrapper;
    }

    @StableAPI.Expose
    public static Optional<String> mixinVersion() {
        return mixinBootstrapper != MixinBootstrapperType.None ? Optional.of(MixinInfo.getVerUnsafe()) : Optional.empty();
    }

    private static String getVerUnsafe() {
        return "0.8.5";
    }

    public static boolean isClassPresentSafe(String clazz) {
        try {
            byte[] bytes = Launch.classLoader.getClassBytes(clazz);
            if (bytes == null || bytes.length == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static MixinBootstrapperType detect() {
        if (!MixinInfo.isClassPresentSafe("org.spongepowered.asm.launch.MixinBootstrap")) {
            return MixinBootstrapperType.None;
        }
        for (String candidate : MixinInfoCompatCompanion.UNIMIXIN_CANDIDATES) {
            if (!MixinInfo.isClassPresentSafe(candidate)) continue;
            return MixinBootstrapperType.UniMixin;
        }
        if (MixinInfo.isClassPresentSafe("com.falsepattern.gasstation.GasStation")) {
            return MixinBootstrapperType.GasStation;
        }
        if (MixinInfo.isClassPresentSafe("ru.timeconqueror.spongemixins.core.SpongeMixinsCore")) {
            return MixinBootstrapperType.SpongeMixins;
        }
        if (MixinInfo.isClassPresentSafe("io.github.crucible.grimoire.Grimoire") || MixinInfo.isClassPresentSafe("io.github.crucible.grimoire.common.GrimoireCore")) {
            return MixinBootstrapperType.Grimoire;
        }
        if (MixinInfo.isClassPresentSafe("io.github.tox1cozz.mixinbooterlegacy.MixinBooterLegacyPlugin")) {
            return MixinBootstrapperType.MixinBooterLegacy;
        }
        return MixinBootstrapperType.Other;
    }

    static {
        MixinInfoCompatCompanion.mixinInfoClassLoaded = true;
        mixinBootstrapper = MixinInfo.detect();
    }

    @StableAPI(since="0.10.2")
    public static enum MixinBootstrapperType {
        None,
        GasStation,
        SpongeMixins,
        Grimoire,
        MixinBooterLegacy,
        Other,
        UniMixin;

    }
}

