/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.mixin.IMixin;
import com.falsepattern.lib.mixin.ITargetedMod;
import com.falsepattern.lib.mixin.MinecraftURLClassPath;
import com.falsepattern.lib.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@StableAPI(since="0.8.0")
public interface IMixinPlugin
extends IMixinConfigPlugin {
    @StableAPI.Expose
    public static final Path MODS_DIRECTORY_PATH = FileUtil.getMinecraftHome().toPath().resolve("mods");

    @StableAPI.Expose
    public static Logger createLogger(String modName) {
        return LogManager.getLogger((String)(modName + " Mixin Loader"));
    }

    @StableAPI.Expose
    public static File findJarOf(ITargetedMod mod) {
        File result = null;
        try {
            Stream<Path> stream = Files.walk(MODS_DIRECTORY_PATH, new FileVisitOption[0]);
            Object object = null;
            try {
                result = stream.filter(mod::isMatchingJar).map(Path::toFile).findFirst().orElse(null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            File found = null;
            for (URL url : Launch.classLoader.getURLs()) {
                try {
                    String file = url.getFile();
                    Path path = Paths.get(file, new String[0]);
                    if (!mod.isMatchingJar(path)) continue;
                    found = path.toFile();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = found;
        }
        return result;
    }

    @StableAPI.Expose
    public Logger getLogger();

    @StableAPI.Expose
    public IMixin[] getMixinEnumValues();

    @StableAPI.Expose
    public ITargetedMod[] getTargetedModEnumValues();

    @StableAPI.Expose(since="__INTERNAL__")
    default public void onLoad(String mixinPackage) {
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public String getRefMapperConfig() {
        return null;
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public List<String> getMixins() {
        final boolean isDevelopmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        ITargetedMod[] targetedMods = this.getTargetedModEnumValues();
        List<ITargetedMod> loadedMods = Arrays.stream(targetedMods).filter(new Predicate<ITargetedMod>(){

            @Override
            public boolean test(ITargetedMod mod) {
                return mod.isLoadInDevelopment() && isDevelopmentEnvironment || IMixinPlugin.this.loadJarOf(mod);
            }
        }).collect(Collectors.toList());
        for (ITargetedMod mod : targetedMods) {
            if (loadedMods.contains(mod)) {
                this.getLogger().info("Found " + mod.getModName() + "! Integrating now...");
                continue;
            }
            this.getLogger().info("Could not find " + mod.getModName() + "! Skipping integration....");
        }
        ArrayList<String> mixins = new ArrayList<String>();
        for (IMixin mixin : this.getMixinEnumValues()) {
            if (!mixin.shouldLoad(loadedMods)) continue;
            String mixinClass = mixin.getSide().name().toLowerCase() + "." + mixin.getMixin();
            mixins.add(mixinClass);
            this.getLogger().info("Loading mixin: " + mixinClass);
        }
        return mixins;
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public boolean loadJarOf(ITargetedMod mod) {
        boolean success = false;
        try {
            File jar = IMixinPlugin.findJarOf(mod);
            if (jar == null) {
                this.getLogger().info("Jar not found for " + mod);
                return false;
            }
            this.getLogger().info("Attempting to add " + jar + " to the URL Class Path");
            success = true;
            if (!jar.exists()) {
                success = false;
                throw new FileNotFoundException(jar.toString());
            }
            MinecraftURLClassPath.addJar(jar);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return success;
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @StableAPI.Expose(since="__INTERNAL__")
    default public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

