/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping.types;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.internal.ReflectionUtil;
import com.falsepattern.lib.mapping.storage.MappedString;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import java.lang.reflect.Field;
import java.util.Map;
import lombok.NonNull;
import org.objectweb.asm.tree.FieldInsnNode;

@StableAPI(since="0.10.0")
public class UniversalField {
    public final UniversalClass parent;
    public final MappedString name;
    private Field javaFieldCache = null;

    private UniversalField(@NonNull UniversalClass parent, String[] names, Map<String, String> stringPool) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.parent = parent;
        this.name = new MappedString(names, 0, 1, str -> str.substring(str.lastIndexOf(47) + 1), stringPool);
        parent.addField(this);
    }

    @StableAPI.Expose
    public static void createAndAddToParent(@NonNull UniversalClass parent, String[] names, Map<String, String> stringPool) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        new UniversalField(parent, names, stringPool);
    }

    @StableAPI.Expose
    public String getName(MappingType mappingType) {
        return this.name.get(mappingType);
    }

    @StableAPI.Expose
    public Field asJavaField() throws ClassNotFoundException, NoSuchFieldException {
        if (this.javaFieldCache != null) {
            return this.javaFieldCache;
        }
        Class<?> parentClass = this.parent.asJavaClass();
        this.javaFieldCache = parentClass.getDeclaredField(this.getName(this.parent.realClassMapping()));
        ReflectionUtil.jailBreak(this.javaFieldCache);
        return this.javaFieldCache;
    }

    @StableAPI.Expose
    public <T> T get(Object instance) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field field = this.asJavaField();
        return (T)field.get(instance);
    }

    @StableAPI.Expose
    public FieldInsnNode asInstruction(int opcode, MappingType mapping, String descriptor) {
        return new FieldInsnNode(opcode, this.parent.getName(NameType.Internal, mapping), this.getName(mapping), descriptor);
    }

    public String toString() {
        return "UniversalField(name=" + this.name() + ", javaFieldCache=" + this.javaFieldCache + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalField)) {
            return false;
        }
        UniversalField other = (UniversalField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MappedString this$name = this.name();
        MappedString other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Field this$javaFieldCache = this.javaFieldCache;
        Field other$javaFieldCache = other.javaFieldCache;
        return !(this$javaFieldCache == null ? other$javaFieldCache != null : !((Object)this$javaFieldCache).equals(other$javaFieldCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniversalField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MappedString $name = this.name();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Field $javaFieldCache = this.javaFieldCache;
        result = result * 59 + ($javaFieldCache == null ? 43 : ((Object)$javaFieldCache).hashCode());
        return result;
    }

    @StableAPI.Expose
    public UniversalClass parent() {
        return this.parent;
    }

    @StableAPI.Expose
    public MappedString name() {
        return this.name;
    }
}

