/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping.storage;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.mapping.types.MappingType;
import java.util.Map;
import java.util.function.Function;

@StableAPI(since="0.10.0")
public class MappedString {
    @StableAPI.Expose
    public final String notch;
    @StableAPI.Expose
    public final String srg;
    @StableAPI.Expose
    public final String mcp;

    @StableAPI.Expose
    public MappedString(String[] source, int offset, int stride, Function<String, String> remapper, Map<String, String> stringPool) {
        this.notch = stringPool.computeIfAbsent(remapper.apply(source[offset]), str -> str);
        this.srg = stringPool.computeIfAbsent(remapper.apply(source[offset + stride]), str -> str);
        this.mcp = stringPool.computeIfAbsent(remapper.apply(source[offset + stride * 2]), str -> str);
    }

    @StableAPI.Expose
    public static MappedString fuse(MappedString a, MappedString b, String delimiter, Map<String, String> stringPool) {
        return new MappedString(stringPool.computeIfAbsent(a.notch + delimiter + b.notch, str -> str), stringPool.computeIfAbsent(a.srg + delimiter + b.srg, str -> str), stringPool.computeIfAbsent(a.mcp + delimiter + b.mcp, str -> str));
    }

    @StableAPI.Expose
    public String get(MappingType type) {
        switch (type) {
            case Notch: {
                return this.notch;
            }
            case SRG: {
                return this.srg;
            }
            case MCP: {
                return this.mcp;
            }
        }
        throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)type));
    }

    public String toString() {
        return "MappedString(notch=" + this.notch() + ", srg=" + this.srg() + ", mcp=" + this.mcp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappedString)) {
            return false;
        }
        MappedString other = (MappedString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$notch = this.notch();
        String other$notch = other.notch();
        if (this$notch == null ? other$notch != null : !this$notch.equals(other$notch)) {
            return false;
        }
        String this$srg = this.srg();
        String other$srg = other.srg();
        if (this$srg == null ? other$srg != null : !this$srg.equals(other$srg)) {
            return false;
        }
        String this$mcp = this.mcp();
        String other$mcp = other.mcp();
        return !(this$mcp == null ? other$mcp != null : !this$mcp.equals(other$mcp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappedString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $notch = this.notch();
        result = result * 59 + ($notch == null ? 43 : $notch.hashCode());
        String $srg = this.srg();
        result = result * 59 + ($srg == null ? 43 : $srg.hashCode());
        String $mcp = this.mcp();
        result = result * 59 + ($mcp == null ? 43 : $mcp.hashCode());
        return result;
    }

    public String notch() {
        return this.notch;
    }

    public String srg() {
        return this.srg;
    }

    public String mcp() {
        return this.mcp;
    }

    private MappedString(String notch, String srg, String mcp) {
        this.notch = notch;
        this.srg = srg;
        this.mcp = mcp;
    }
}

