/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.optifine;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.impl.optifine.WrappedOptiFineClassTransformer;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class OptiFineTransformerHooksImpl {
    private static final Set<String> disabledPatches = new HashSet<String>();

    public static void init() {
        List transformers;
        Field tField;
        try {
            tField = LaunchClassLoader.class.getDeclaredField("transformers");
        }
        catch (NoSuchFieldException e) {
            FPLog.LOG.error("Could not retrieve transformers field", (Throwable)e);
            return;
        }
        tField.setAccessible(true);
        try {
            transformers = (List)tField.get(Launch.classLoader);
        }
        catch (IllegalAccessException e) {
            FPLog.LOG.error("Could not retrieve transformers list", (Throwable)e);
            return;
        }
        for (int i = 0; i < transformers.size(); ++i) {
            IClassTransformer transformer = (IClassTransformer)transformers.get(i);
            System.out.println(transformer.getClass().getName());
            if (!transformer.getClass().getName().equals("optifine.OptiFineClassTransformer")) continue;
            FPLog.LOG.info("Attaching OptiFine ASM transformer hooks");
            transformers.set(i, new WrappedOptiFineClassTransformer(transformer));
        }
    }

    public static void disableOptiFinePatch(String patchName) {
        disabledPatches.add(patchName);
    }

    public static boolean isDisabled(String className) {
        return disabledPatches.contains(className);
    }
}

