/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.dependencies;

import com.falsepattern.lib.dependencies.Library;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.dependencies.Version;
import com.falsepattern.lib.internal.Internet;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.config.EarlyConfig;
import com.falsepattern.lib.internal.core.LowLevelCallMultiplexer;
import com.falsepattern.lib.internal.impl.dependencies.DepRoot;
import com.falsepattern.lib.internal.impl.dependencies.Pair;
import com.falsepattern.lib.internal.impl.dependencies.RawVersion;
import com.falsepattern.lib.util.FileUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.util.internal.ConcurrentSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DependencyLoaderImpl {
    private static final String[] CHECKSUM_TYPES;
    private static final Map<String, Version> loadedLibraries;
    private static final Map<String, String> loadedLibraryMods;
    private static final Set<String> mavenRepositories;
    private static final Logger LOG;
    private static final AtomicLong counter;
    private static final ExecutorService executor;
    private static final Path libDir;
    private static final Path tempDir;
    private static final Pattern VERSION_PATTERN;
    private static boolean initialScan;
    private static List<Pair<ScopeSide, DependencyLoadTask>> tasks;

    private static void ensureExists(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.fatal("Failed to create directory {}", new Object[]{directory});
                throw new RuntimeException("Failed to create directory " + directory, e);
            }
        }
    }

    public static void addMavenRepo(String url) {
        mavenRepositories.add(url);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static String digest(String algo, byte[] data) {
        return DependencyLoaderImpl.bytesToHex(MessageDigest.getInstance(algo).digest(data));
    }

    private static String hash(String algo, Path file) {
        byte[] data = Files.readAllBytes(file);
        switch (algo) {
            case "md5": {
                algo = "MD5";
                break;
            }
            case "sha1": {
                algo = "SHA-1";
                break;
            }
            case "sha256": {
                algo = "SHA-256";
                break;
            }
            case "sha512": {
                algo = "SHA-512";
            }
        }
        return DependencyLoaderImpl.digest(algo, data);
    }

    private static void checkedDelete(Path file) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            LOG.fatal("Failed to delete file {}", new Object[]{file});
            throw new RuntimeException("Failed to delete file " + file, e);
        }
    }

    private static synchronized void addToClasspath(Path file) {
        try {
            LowLevelCallMultiplexer.addURLToClassPath(file.toUri().toURL());
            LOG.debug("Injected file {} into classpath!", new Object[]{file});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add library to classpath: " + file.toAbsolutePath(), e);
        }
    }

    private static void download(InputStream is, Path target, Consumer<Integer> downloadSizeCallback) {
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        Internet.transferAndClose(is, new BufferedOutputStream(Files.newOutputStream(target, new OpenOption[0])), downloadSizeCallback);
    }

    public static void loadLibraries(Library ... libraries) {
        DependencyLoaderImpl.loadLibrariesAsync(libraries).join();
    }

    public static CompletableFuture<Void> loadLibrariesAsync(Library ... libraries) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Library library : libraries) {
            DependencyLoadTask task = new DependencyLoadTask(library.loadingModId, library.groupId, library.artifactId, library.minVersion, library.maxVersion, library.preferredVersion, library.regularSuffix, library.devSuffix);
            futures.add(CompletableFuture.runAsync(() -> task.load(), executor));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static boolean scanForDepSpecs(URL source, List<URL> output) {
        if (!source.getProtocol().equals("file")) {
            return false;
        }
        String fileName = source.getFile();
        boolean found = false;
        if (fileName.endsWith(".jar")) {
            try (BufferedInputStream inputStream = new BufferedInputStream(source.openStream(), 65536);
                 JarInputStream jarFile = new JarInputStream(inputStream);){
                ZipEntry entry;
                while ((entry = jarFile.getNextEntry()) != null) {
                    if (!entry.getName().startsWith("META-INF") || !entry.getName().endsWith(".json")) continue;
                    try {
                        output.add(new URL("jar:" + source + "!/" + entry.getName()));
                        found = true;
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Failed to add json source {} to dependency source list: {}", new Object[]{entry.getName(), e});
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Failed to open jar file {}", new Object[]{source.getPath()});
            }
        } else {
            Path dir;
            try {
                dir = Paths.get(source.toURI());
            }
            catch (URISyntaxException e) {
                LOG.error("Could not scan URL " + source + " for dependencies", (Throwable)e);
                return false;
            }
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
                LOG.warn("Skipping non-directory, nor jar source: {}", new Object[]{source});
                return false;
            }
            Path metaInf = dir.resolve("META-INF");
            if (!Files.exists(metaInf, new LinkOption[0]) || !Files.isDirectory(metaInf, new LinkOption[0])) {
                return false;
            }
            try (Stream<Path> files = Files.list(metaInf);){
                found = files.reduce(false, (prev, file) -> {
                    if (!file.endsWith(".json")) {
                        return prev;
                    }
                    try {
                        output.add(file.toUri().toURL());
                        return true;
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Failed to add json source {} to dependency source list: {}", new Object[]{file.getFileName(), e});
                        return prev;
                    }
                }, (a, b) -> a != false || b != false);
            }
            catch (IOException e) {
                LOG.error("Failed to open directory {}", new Object[]{metaInf});
            }
        }
        return found;
    }

    private static Stream<URL> grabSourceCandidatesFromFolder(Path folder) {
        Stream paths;
        if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            return Stream.empty();
        }
        try (Stream<Path> files = Files.list(folder);){
            paths = files.collect(Collectors.toSet()).stream();
        }
        catch (IOException ignored) {
            return Stream.empty();
        }
        return paths.map(file -> {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(Objects::nonNull);
    }

    private static <A, B, C> Stream<Pair<A, B>> flatMap(Pair<A, C> pair, Function<C, Stream<B>> mapper) {
        Object a = pair.a;
        return mapper.apply(pair.b).map(b -> new Pair<Object, Object>(a, b));
    }

    private static Pair<DependencyScope, DepRoot.SidedDependencies> scopedDependency(DependencyScope scope, DepRoot.SidedDependencies deps) {
        return new Pair<DependencyScope, DepRoot.SidedDependencies>(scope, deps);
    }

    private static Stream<Pair<ScopeSide, String>> sidedDependency(DependencySide side, Stream<Pair<DependencyScope, String>> deps) {
        return deps.map(dep -> new Pair(new ScopeSide((DependencyScope)((Object)((Object)dep.a)), side), dep.b));
    }

    public static void executeDependencyLoading(boolean sideAware) {
        if (!initialScan) {
            initialScan = true;
            DependencyLoaderImpl.scanDeps();
        }
        DependencyLoaderImpl.executeArtifactLoading(sideAware);
    }

    private static void scanDeps() {
        LOG.debug("Discovering dependency source candidates...");
        Path modsDir = FileUtil.getMinecraftHomePath().resolve("mods");
        Path mods1710Dir = modsDir.resolve("1.7.10");
        long start = System.currentTimeMillis();
        HashSet<String> urlsWithoutDeps = new HashSet<String>();
        Path depCache = tempDir.resolve(".depscan_cache");
        if (Files.exists(depCache, new LinkOption[0])) {
            try {
                urlsWithoutDeps.addAll(Files.readAllLines(depCache));
            }
            catch (IOException e) {
                LOG.error("Could not read dependency scanner cache", (Throwable)e);
            }
        }
        List candidates = Stream.of(LowLevelCallMultiplexer.getClassPathSources().stream(), DependencyLoaderImpl.grabSourceCandidatesFromFolder(modsDir), DependencyLoaderImpl.grabSourceCandidatesFromFolder(mods1710Dir)).flatMap(i -> i).filter(url -> !urlsWithoutDeps.contains(url.toString())).collect(Collectors.toList());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Serializable candidate : candidates) {
            if (DependencyLoaderImpl.scanForDepSpecs((URL)candidate, urls)) continue;
            urlsWithoutDeps.add(((URL)candidate).toString());
        }
        try {
            Serializable candidate;
            BufferedWriter out = Files.newBufferedWriter(depCache, new OpenOption[0]);
            candidate = null;
            try {
                for (String noDep : urlsWithoutDeps) {
                    out.append(noDep).append(System.lineSeparator());
                }
            }
            catch (Throwable throwable) {
                candidate = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (candidate != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)candidate).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error("Could not write dependency scanner cache", (Throwable)e);
        }
        Set dependencySpecs = urls.stream().map(source -> {
            try (BufferedInputStream is = new BufferedInputStream(source.openStream());){
                JsonElement jsonRaw = new JsonParser().parse((Reader)new InputStreamReader(is));
                if (!jsonRaw.isJsonObject()) {
                    DepRoot depRoot = null;
                    return depRoot;
                }
                JsonObject json = jsonRaw.getAsJsonObject();
                if (!json.has("identifier") || !json.get("identifier").getAsString().equals("falsepatternlib_dependencies")) {
                    DepRoot depRoot = null;
                    return depRoot;
                }
                GsonBuilder builder = new GsonBuilder();
                builder.excludeFieldsWithoutExposeAnnotation();
                Gson gson = builder.create();
                json.remove("identifier");
                DepRoot root = (DepRoot)gson.fromJson((JsonElement)json, DepRoot.class);
                root.source(source.toString());
                DepRoot depRoot = root;
                return depRoot;
            }
            catch (Exception e) {
                LOG.error("Failed to read json from source {}: {}", new Object[]{source, e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        long end = System.currentTimeMillis();
        LOG.debug("Discovered {} dependency source candidates in {}ms", new Object[]{dependencySpecs.size(), end - start});
        mavenRepositories.addAll(dependencySpecs.stream().flatMap(dep -> dep.repositories().stream()).collect(Collectors.toSet()));
        Set artifacts = dependencySpecs.stream().map(root -> new Pair<String, DepRoot.Dependencies>(root.source(), root.dependencies())).flatMap(pair -> DependencyLoaderImpl.flatMap(pair, dep -> Stream.of(DependencyLoaderImpl.scopedDependency(DependencyScope.ALWAYS, dep.always()), DependencyLoaderImpl.scopedDependency(DependencyScope.DEV, dep.dev()), DependencyLoaderImpl.scopedDependency(DependencyScope.OBF, dep.obf())))).flatMap(pair -> DependencyLoaderImpl.flatMap(pair, dep -> Stream.concat(DependencyLoaderImpl.sidedDependency(DependencySide.COMMON, DependencyLoaderImpl.flatMap(dep, d -> d.common().stream())), Stream.concat(DependencyLoaderImpl.sidedDependency(DependencySide.CLIENT, DependencyLoaderImpl.flatMap(dep, d -> d.client().stream())), DependencyLoaderImpl.sidedDependency(DependencySide.SERVER, DependencyLoaderImpl.flatMap(dep, d -> d.server().stream())))))).map(pair -> {
            String classifier;
            Version version;
            String source = (String)pair.a;
            Pair scopedDep = (Pair)pair.b;
            String dep = (String)scopedDep.b;
            ScopeSide scope = (ScopeSide)scopedDep.a;
            String[] parts = dep.split(":");
            if (parts.length < 3) {
                LOG.error("Invalid dependency: {}", new Object[]{dep});
                return null;
            }
            String groupId = parts[0];
            String artifactId = parts[1];
            try {
                Matcher matcher = VERSION_PATTERN.matcher(parts[2]);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid version: " + parts[2]);
                }
                int major = Integer.parseInt(matcher.group(1));
                int minor = matcher.group(2) == null ? -1 : Integer.parseInt(matcher.group(2));
                int patch = matcher.group(3) == null ? -1 : Integer.parseInt(matcher.group(3));
                String preRelease = matcher.group(4);
                String build = matcher.group(5);
                version = new SemanticVersion(major, minor, patch, preRelease, build);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unparseable dependency version {}:{}:{} from {}", new Object[]{groupId, artifactId, parts[2], source});
                version = new RawVersion(parts[2]);
            }
            String string = classifier = parts.length > 3 ? parts[3] : null;
            if (classifier != null) {
                LOG.info("Found dependency: {}:{}:{}:{} from {}", new Object[]{groupId, artifactId, version, classifier, source});
            } else {
                LOG.info("Found dependency: {}:{}:{} from {}", new Object[]{groupId, artifactId, version, source});
            }
            return new Pair<ScopeSide, DependencyLoadTask>(scope, new DependencyLoadTask(source, groupId, artifactId, version, null, version, classifier, classifier));
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        tasks = new ArrayList(artifacts);
    }

    private static void executeArtifactLoading(boolean sideAware) {
        ScopeSide scopeSide = sideAware ? SideAwareAssistant.current() : new ScopeSide(DependencyScope.ALWAYS, DependencySide.COMMON);
        Iterator<Pair<ScopeSide, DependencyLoadTask>> iter = tasks.iterator();
        HashMap<String, DependencyLoadTask> artifactMap = new HashMap<String, DependencyLoadTask>();
        while (iter.hasNext()) {
            Pair<ScopeSide, DependencyLoadTask> artifact = iter.next();
            ScopeSide artifactSide = (ScopeSide)artifact.a;
            if (!scopeSide.contains(artifactSide)) continue;
            iter.remove();
            DependencyLoadTask artifactPayload = (DependencyLoadTask)artifact.b;
            String id = artifactPayload.getGroupArtifact();
            if (artifactMap.containsKey(id)) {
                DependencyLoadTask otherArtifact = (DependencyLoadTask)artifactMap.get(id);
                if (artifactPayload.preferredVersion.compareTo(otherArtifact.preferredVersion) <= 0) continue;
                LOG.info("Replacing dependency {}:{} from {} with version {} from {}", new Object[]{otherArtifact.getGroupArtifact(), otherArtifact.preferredVersion, otherArtifact.loadingModId, artifactPayload.preferredVersion, artifactPayload.loadingModId});
                artifactMap.put(id, artifactPayload);
                continue;
            }
            artifactMap.put(id, artifactPayload);
        }
        if (artifactMap.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        LOG.info("-----------------------------------------------------------");
        LOG.info("FalsePatternLib is downloading dependencies. Please wait...");
        LOG.info("-----------------------------------------------------------");
        HashMap<DependencyLoadTask, JProgressBar> progresses = new HashMap<DependencyLoadTask, JProgressBar>();
        Iterator jFrame = null;
        try {
            jFrame = new JFrame("Dependency Download");
            GridBagConstraints constraints = new GridBagConstraints();
            ((JFrame)((Object)jFrame)).getContentPane().setLayout(new GridBagLayout());
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            ((Container)((Object)jFrame)).add(new JLabel("FalsePatternLib is downloading dependencies, please wait!"), constraints);
            constraints.gridwidth = 1;
            for (Map.Entry artifact : artifactMap.entrySet()) {
                ++constraints.gridy;
                ((Container)((Object)jFrame)).add(new JLabel((String)artifact.getKey()), constraints);
                JProgressBar status = new JProgressBar();
                status.setIndeterminate(true);
                status.setStringPainted(true);
                status.setString("Waiting...");
                progresses.put((DependencyLoadTask)artifact.getValue(), status);
                ((Container)((Object)jFrame)).add(status, constraints);
            }
            ((Window)((Object)jFrame)).pack();
            ((JFrame)((Object)jFrame)).setDefaultCloseOperation(0);
            ((Window)((Object)jFrame)).setVisible(true);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            ((Window)((Object)jFrame)).setLocation(dim.width / 2 - ((Component)((Object)jFrame)).getSize().width / 2, dim.height / 2 - ((Component)((Object)jFrame)).getSize().height / 2);
        }
        catch (Exception constraints) {
            // empty catch block
        }
        JFrame theFrame = jFrame;
        if (theFrame != null) {
            for (DependencyLoadTask task : artifactMap.values()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    JProgressBar bar = (JProgressBar)progresses.get(task);
                    bar.setString("Downloading...");
                    task.load();
                    bar.setMinimum(0);
                    bar.setMaximum(1);
                    bar.setValue(1);
                    bar.setString("Completed!");
                }, executor));
            }
        } else {
            for (DependencyLoadTask task : artifactMap.values()) {
                futures.add(CompletableFuture.runAsync(() -> task.load(), executor));
            }
        }
        CompletableFuture<Void> theFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        AtomicBoolean doViz = new AtomicBoolean(true);
        if (theFrame != null) {
            Thread vizThread = DependencyLoaderImpl.getVizThread(doViz, progresses, theFrame);
            vizThread.start();
        }
        theFuture.join();
        if (theFrame != null) {
            doViz.set(false);
        }
    }

    @NotNull
    private static Thread getVizThread(AtomicBoolean doViz, HashMap<DependencyLoadTask, JProgressBar> progresses, JFrame theFrame) {
        Thread vizThread = new Thread(() -> {
            while (doViz.get()) {
                for (Map.Entry progress : progresses.entrySet()) {
                    DependencyLoadTask task = (DependencyLoadTask)progress.getKey();
                    JProgressBar bar = (JProgressBar)progress.getValue();
                    if (task.contentLength == -1L) {
                        bar.setIndeterminate(true);
                        continue;
                    }
                    bar.setIndeterminate(false);
                    bar.setMinimum(0);
                    bar.setMaximum((int)task.contentLength);
                    bar.setValue((int)task.downloaded);
                }
                theFrame.repaint();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            theFrame.dispose();
        });
        vizThread.setName("FalsePatternLib Download Visualizer");
        return vizThread;
    }

    static {
        Path oldCacheFile;
        CHECKSUM_TYPES = new String[]{"sha512", "sha256", "sha1", "md5"};
        loadedLibraries = new ConcurrentHashMap<String, Version>();
        loadedLibraryMods = new ConcurrentHashMap<String, String>();
        mavenRepositories = new ConcurrentSet();
        LOG = LogManager.getLogger((String)"FalsePatternLib Library Loader");
        counter = new AtomicLong(0L);
        executor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Dependency Download Thread " + counter.incrementAndGet());
            return thread;
        });
        String homeDirStr = System.getProperty("minecraft.sharedDataDir");
        if (homeDirStr == null) {
            homeDirStr = System.getenv("MINECRAFT_SHARED_DATA_DIR");
        }
        Path homeDir = homeDirStr == null ? FileUtil.getMinecraftHome().toPath() : Paths.get(homeDirStr, new String[0]);
        libDir = homeDir.resolve("falsepattern");
        tempDir = homeDir.resolve(Paths.get("logs", "falsepattern_tmp"));
        DependencyLoaderImpl.ensureExists(libDir);
        DependencyLoaderImpl.ensureExists(tempDir);
        Path oldLibDir = homeDir.resolve(Paths.get("mods", "falsepattern"));
        if (Files.exists(oldLibDir, new LinkOption[0])) {
            LOG.info("Migrating old library folder. From: " + oldLibDir.toAbsolutePath() + ", To: " + libDir.toAbsolutePath());
            try (Stream<Path> oldFiles = Files.list(oldLibDir);){
                oldFiles.forEach(file -> {
                    try {
                        Files.move(file, libDir.resolve(oldLibDir.relativize((Path)file)), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to move file " + file.getFileName() + " to new dir! Deleting instead.");
                        try {
                            Files.deleteIfExists(file);
                        }
                        catch (IOException ex) {
                            LOG.warn("Failed to delete file " + file + "!", (Throwable)ex);
                        }
                    }
                });
            }
            catch (IOException e) {
                LOG.warn("Failed to iterate old library directory!", (Throwable)e);
            }
            try {
                Files.deleteIfExists(oldLibDir);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete old library directory!", (Throwable)e);
            }
        }
        if (Files.exists(oldCacheFile = libDir.resolve(".depscan_cache"), new LinkOption[0])) {
            try {
                Files.delete(oldCacheFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete old depscan cache file!", (Throwable)e);
            }
        }
        VERSION_PATTERN = Pattern.compile("(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*))?(?:\\.(0|[1-9]\\d*))?(?:-((?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0)(?:\\.(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0))*))?(?:\\+([\\w-]+(\\.[\\w-]+)*))?");
        initialScan = false;
    }

    private static class DependencyLoadTask {
        @NonNull
        private final String loadingModId;
        @NonNull
        private final String groupId;
        @NonNull
        private final String artifactId;
        @NonNull
        private final Version minVersion;
        private final Version maxVersion;
        @NonNull
        private final Version preferredVersion;
        private final String regularSuffix;
        private final String devSuffix;
        private String suffix;
        private String artifactLogName;
        private String artifact;
        private String mavenJarName;
        public volatile String jarName;
        private Path file;
        public volatile long contentLength = -1L;
        public volatile long downloaded = 0L;

        private void load() {
            try {
                this.setupLibraryNames();
                if (loadedLibraries.containsKey(this.artifact)) {
                    this.alreadyLoaded();
                    return;
                }
                this.setupPaths();
                if (this.tryLoadingExistingFile()) {
                    return;
                }
                this.validateDownloadsAllowed();
                for (String repo : mavenRepositories) {
                    if (!this.tryDownloadFromMaven(repo)) continue;
                    return;
                }
                this.crashCouldNotDownload();
            }
            catch (Exception e) {
                LOG.fatal((Object)e);
            }
        }

        private void crashCouldNotDownload() {
            String errorMessage = "Failed to download library " + this.groupId + ":" + this.artifactId + ":" + this.preferredVersion + (this.suffix != null ? ":" + this.suffix : "") + " from any repository! Requested by mod: " + this.loadingModId;
            LOG.fatal(errorMessage);
            throw new IllegalStateException(errorMessage);
        }

        private void setupLibraryNames() {
            this.suffix = Share.DEV_ENV ? this.devSuffix : this.regularSuffix;
            this.artifactLogName = String.format("%s:%s:%s%s", this.groupId, this.artifactId, this.preferredVersion, this.suffix != null ? "-" + this.suffix : "");
            LOG.info("Adding library {}, requested by mod {}", new Object[]{this.artifactLogName, this.loadingModId});
            this.artifact = this.groupId + ":" + this.artifactId + ":" + this.suffix;
        }

        private void alreadyLoaded() {
            Version currentVer = (Version)loadedLibraries.get(this.artifact);
            if (currentVer.equals(this.preferredVersion)) {
                return;
            }
            String rangeString = "(minimum: " + this.minVersion + (this.maxVersion == null ? "" : ", maximum: " + this.maxVersion) + ")";
            if (this.minVersion.compareTo(currentVer) > 0 || this.maxVersion != null && this.maxVersion.compareTo(currentVer) < 0) {
                int i;
                for (i = 0; i < 16; ++i) {
                    LOG.fatal("ALERT VVVVVVVVVVVV ALERT");
                }
                LOG.fatal("Library {}:{}{} already loaded with version {}, but a version in the range {} was requested! Thing may go horribly wrong! Requested by mod: {}, previously loaded by mod: {}", new Object[]{this.groupId, this.artifactId, this.suffix != null ? ":" + this.suffix : "", currentVer, rangeString, this.loadingModId, loadedLibraryMods.get(this.artifact)});
                for (i = 0; i < 16; ++i) {
                    LOG.fatal("ALERT ^^^^^^^^^^^^ ALERT");
                }
            } else {
                LOG.info("Attempted loading of library {}:{}{} with preferred version {}, but version {} was already loaded, which matched the range {}. This is not an error. Requested by mod: {}, previously loaded by mod: {}", new Object[]{this.groupId, this.artifactId, this.suffix != null ? ":" + this.suffix : "", this.preferredVersion, currentVer, rangeString, this.loadingModId, loadedLibraryMods.get(this.artifact)});
            }
        }

        private void setupPaths() {
            this.mavenJarName = String.format("%s-%s%s.jar", this.artifactId, this.preferredVersion, this.suffix != null ? "-" + this.suffix : "");
            this.jarName = this.groupId + "-" + this.mavenJarName;
            this.file = libDir.resolve(this.jarName);
        }

        private boolean tryLoadingExistingFile() {
            if (!Files.exists(this.file, new LinkOption[0])) {
                return false;
            }
            try {
                ChecksumStatus status = this.validateChecksum(this.file);
                if (status == ChecksumStatus.FAILED) {
                    return false;
                }
                if (status == ChecksumStatus.MISSING) {
                    LOG.debug("Library {} is missing checksum data! Either it was manually deleted, or the source repo didn't have it in the first place", new Object[]{this.artifactLogName});
                }
            }
            catch (IOException e) {
                LOG.error("Failed to execute validation check for " + this.artifactLogName, (Throwable)e);
                DependencyLoaderImpl.checkedDelete(this.file);
                return false;
            }
            try {
                DependencyLoaderImpl.addToClasspath(this.file);
                loadedLibraries.put(this.artifact, this.preferredVersion);
                LOG.debug("Library {} successfully loaded from disk!", new Object[]{this.artifactLogName});
                return true;
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to load library {} from file! Re-downloading...", new Object[]{this.artifactLogName});
                DependencyLoaderImpl.checkedDelete(this.file);
                return false;
            }
        }

        private void validateDownloadsAllowed() {
            if (!EarlyConfig.load().enableLibraryDownloads()) {
                String errorMessage = "Failed to load library " + this.groupId + ":" + this.artifactId + ":" + this.preferredVersion + (this.suffix != null ? ":" + this.suffix : "") + ": " + "FalsePatternLib" + " library downloading has been disabled in the config, and the library is not present on disk! Requested by mod: " + this.loadingModId;
                LOG.fatal(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        }

        private boolean tryDownloadFromMaven(String repo) {
            try {
                if (!repo.endsWith("/")) {
                    repo = repo + "/";
                }
                String url = String.format("%s%s/%s/%s/%s", repo, this.groupId.replace('.', '/'), this.artifactId, this.preferredVersion, this.mavenJarName);
                String finalRepo = repo;
                int retryCount = 0;
                block9: while (++retryCount <= 3) {
                    AtomicBoolean success = new AtomicBoolean(false);
                    Path tmpFile = this.file.getParent().resolve(this.file.getFileName().toString() + ".tmp");
                    if (Files.exists(tmpFile, new LinkOption[0])) {
                        Files.delete(tmpFile);
                    }
                    Internet.connect(new URL(url), ex -> LOG.debug("Artifact {} could not be downloaded from repo {}: {}", new Object[]{this.artifactLogName, finalRepo, ex.getMessage()}), input -> {
                        LOG.debug("Downloading {} from {}", new Object[]{this.artifactLogName, finalRepo});
                        DependencyLoaderImpl.download(input, tmpFile, d -> this.downloaded += (long)d.intValue());
                        LOG.debug("Downloaded {} from {}", new Object[]{this.artifactLogName, finalRepo});
                        success.set(true);
                    }, contentLength -> {
                        this.contentLength = contentLength;
                    });
                    if (!success.get()) continue;
                    try {
                        Files.move(tmpFile, this.file, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException ignored) {
                        Files.move(tmpFile, this.file, new CopyOption[0]);
                    }
                    LOG.debug("Validating checksum for {}", new Object[]{this.artifactLogName});
                    ChecksumStatus hadChecksum = this.validateChecksum(url);
                    switch (hadChecksum) {
                        case FAILED: {
                            continue block9;
                        }
                        case OK: {
                            break;
                        }
                        case MISSING: {
                            LOG.warn("The library {} had no checksum available on the repository.\nThere's a chance it might have gotten corrupted during download,\nbut we're loading it anyways.", new Object[]{this.artifactLogName});
                        }
                    }
                    loadedLibraries.put(this.artifact, this.preferredVersion);
                    loadedLibraryMods.put(this.artifact, this.loadingModId);
                    DependencyLoaderImpl.addToClasspath(this.file);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private ChecksumStatus validateChecksum(String url) throws IOException {
            for (String checksumType : CHECKSUM_TYPES) {
                String checksumURL = url + "." + checksumType;
                Path checksumFile = libDir.resolve(this.jarName + "." + checksumType);
                LOG.debug("Attempting to get {} checksum...", new Object[]{checksumType});
                AtomicBoolean success = new AtomicBoolean(false);
                Internet.connect(new URL(checksumURL), ex -> LOG.debug("Could not get {} checksum for {}: {}", new Object[]{checksumType, this.artifactLogName, ex.getMessage()}), input -> {
                    LOG.debug("Downloading {} checksum for {}", new Object[]{checksumType, this.artifactLogName});
                    DependencyLoaderImpl.download(input, checksumFile, d -> {});
                    LOG.debug("Downloaded {} checksum for {}", new Object[]{checksumType, this.artifactLogName});
                    success.set(true);
                }, length -> {});
                if (!success.get()) continue;
                return this.getChecksumStatus(this.file, checksumType, checksumFile);
            }
            return ChecksumStatus.MISSING;
        }

        private ChecksumStatus validateChecksum(Path file) throws IOException {
            for (String checksumType : CHECKSUM_TYPES) {
                Path checksumFile = libDir.resolve(this.jarName + "." + checksumType);
                LOG.debug("Attempting to read {} checksum from file...", new Object[]{checksumType});
                if (!Files.exists(checksumFile, new LinkOption[0])) continue;
                return this.getChecksumStatus(file, checksumType, checksumFile);
            }
            return ChecksumStatus.MISSING;
        }

        private ChecksumStatus getChecksumStatus(Path file, String checksumType, Path checksumFile) throws IOException {
            String referenceHash;
            String fileHash = DependencyLoaderImpl.hash(checksumType, file);
            if (!fileHash.equals(referenceHash = new String(Files.readAllBytes(checksumFile)))) {
                LOG.error("Failed {} checksum validation for {}.", new Object[]{checksumType, this.artifactLogName});
                DependencyLoaderImpl.checkedDelete(file);
                DependencyLoaderImpl.checkedDelete(checksumFile);
                return ChecksumStatus.FAILED;
            }
            LOG.debug("Successfully validated {} checksum for {}.", new Object[]{checksumType, this.artifactLogName});
            return ChecksumStatus.OK;
        }

        public String getGroupArtifact() {
            return this.groupId + ":" + this.artifactId;
        }

        public DependencyLoadTask(@NonNull String loadingModId, @NonNull String groupId, @NonNull String artifactId, @NonNull Version minVersion, Version maxVersion, @NonNull Version preferredVersion, String regularSuffix, String devSuffix) {
            if (loadingModId == null) {
                throw new NullPointerException("loadingModId is marked non-null but is null");
            }
            if (groupId == null) {
                throw new NullPointerException("groupId is marked non-null but is null");
            }
            if (artifactId == null) {
                throw new NullPointerException("artifactId is marked non-null but is null");
            }
            if (minVersion == null) {
                throw new NullPointerException("minVersion is marked non-null but is null");
            }
            if (preferredVersion == null) {
                throw new NullPointerException("preferredVersion is marked non-null but is null");
            }
            this.loadingModId = loadingModId;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
            this.preferredVersion = preferredVersion;
            this.regularSuffix = regularSuffix;
            this.devSuffix = devSuffix;
        }

        private static enum ChecksumStatus {
            OK,
            FAILED,
            MISSING;

        }
    }

    private static class SideAwareAssistant {
        private SideAwareAssistant() {
        }

        static ScopeSide current() {
            return new ScopeSide(Share.DEV_ENV ? DependencyScope.DEV : DependencyScope.OBF, FMLLaunchHandler.side() == Side.CLIENT ? DependencySide.CLIENT : DependencySide.SERVER);
        }
    }

    private static class ScopeSide {
        final DependencyScope scope;
        final DependencySide side;

        boolean contains(ScopeSide dependency) {
            return !(dependency.scope != this.scope && dependency.scope != DependencyScope.ALWAYS || dependency.side != this.side && dependency.side != DependencySide.COMMON);
        }

        public ScopeSide(DependencyScope scope, DependencySide side) {
            this.scope = scope;
            this.side = side;
        }
    }

    private static enum DependencyScope {
        ALWAYS,
        DEV,
        OBF;

    }

    private static enum DependencySide {
        COMMON,
        CLIENT,
        SERVER;

    }
}

