/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.net;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class CompressedMessage
implements IMessage {
    private byte[] compressed = null;

    protected abstract void transmit(DataOutput var1) throws IOException;

    protected abstract void receive(DataInput var1) throws IOException;

    public void transmit() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DeflaterOutputStream deflateOut = new DeflaterOutputStream((OutputStream)output, new Deflater(9, false));
        DataOutputStream dataOut = new DataOutputStream(deflateOut);
        this.transmit(dataOut);
        dataOut.close();
        this.compressed = output.toByteArray();
    }

    public void receive() throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(this.compressed);
        InflaterInputStream deflateIn = new InflaterInputStream(input, new Inflater(false));
        DataInputStream dataIn = new DataInputStream(deflateIn);
        this.receive(dataIn);
        dataIn.close();
        this.compressed = null;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.compressed = new byte[length];
        buf.readBytes(this.compressed);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.compressed.length);
        buf.writeBytes(this.compressed);
    }
}

