/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class StringListConfigField
extends AListConfigField<String[]> {
    private final String[] defaultValue;
    private final Pattern pattern;
    private final int maxStringLength;

    public StringListConfigField(Field field, Configuration configuration, String category) throws ConfigException {
        super(field, configuration, category, Property.Type.STRING);
        this.pattern = Optional.ofNullable(field.getAnnotation(Config.Pattern.class)).map(ptr -> Pattern.compile(ptr.value())).orElse(null);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultStringList.class)).map(Config.DefaultStringList::value).orElseThrow(() -> StringListConfigField.noDefault(field, "DefaultStringList"));
        this.maxStringLength = Optional.ofNullable(field.getAnnotation(Config.StringMaxLength.class)).map(Config.StringMaxLength::value).orElse(256);
        this.property.setDefaultValues(this.defaultValue);
        if (!this.property.isList()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[max string length: " + this.maxLength + (this.pattern != null ? ", pattern: \"" + this.pattern.pattern() + "\"" : "") + ", default: \"" + StringListConfigField.stringify(this.defaultValue) + "\"]";
    }

    private static String stringify(String[] arr) {
        StringBuilder result = new StringBuilder("[");
        if (arr.length > 0) {
            result.append('\"').append(arr[0]).append('\"');
            for (int i = 1; i < arr.length; ++i) {
                result.append(", \"").append(arr[i]).append('\"');
            }
        }
        return result.append(']').toString();
    }

    @Override
    protected int length(String[] arr) {
        return arr.length;
    }

    @Override
    protected String[] arrayCopy(String[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, String[] arr) throws IOException {
        for (String str : arr) {
            StringConfigField.transmitString(output, str);
        }
    }

    @Override
    protected void receiveElements(DataInput input, String[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = StringConfigField.receiveString(input, this.maxStringLength, this.field.getName(), this.field.getDeclaringClass().getName());
        }
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        String[] strings = (String[])this.getField();
        boolean valid = true;
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            if (StringConfigField.validateString(str, this.maxStringLength, this.pattern, this.field, i)) continue;
            valid = false;
        }
        return valid;
    }

    @Override
    protected String[] createArray(int length) {
        return new String[length];
    }

    @Override
    protected String[] getConfig() {
        return this.property.getStringList();
    }

    @Override
    protected void putConfig(String[] value) {
        this.property.set(value);
    }

    @Override
    protected String[] getDefault() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

