/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class IntListConfigField
extends AListConfigField<int[]> {
    private final int min;
    private final int max;
    private final int[] defaultValue;

    public IntListConfigField(Field field, Configuration configuration, String category) throws ConfigException {
        super(field, configuration, category, Property.Type.INTEGER);
        Optional<Config.RangeInt> range = Optional.ofNullable(field.getAnnotation(Config.RangeInt.class));
        this.min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
        this.max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultIntList.class)).map(Config.DefaultIntList::value).orElseThrow(() -> IntListConfigField.noDefault(field, "DefaultIntList"));
        this.property.setDefaultValues(this.defaultValue);
        this.property.setMinValue(this.min);
        this.property.setMaxValue(this.max);
        if (!this.property.isIntList()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + Arrays.toString(this.defaultValue) + "]";
    }

    @Override
    protected int length(int[] arr) {
        return arr.length;
    }

    @Override
    protected int[] arrayCopy(int[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, int[] arr) throws IOException {
        for (int i : arr) {
            output.writeInt(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, int[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readInt();
        }
    }

    @Override
    protected int[] createArray(int length) {
        return new int[length];
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        int[] ints = (int[])this.getField();
        boolean valid = true;
        for (int j = 0; j < ints.length; ++j) {
            int i = ints[j];
            if (i >= this.min && i <= this.max) continue;
            ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, j, Integer.toString(i), Integer.toString(this.min), Integer.toString(this.max));
            valid = false;
        }
        return valid;
    }

    @Override
    protected int[] getConfig() {
        return this.property.getIntList();
    }

    @Override
    protected void putConfig(int[] value) {
        this.property.set(value);
    }

    @Override
    protected int[] getDefault() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

