/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DoubleConfigField
extends AConfigField<Double> {
    private final boolean primitive;
    private final double defaultValue;
    private final double min;
    private final double max;

    public DoubleConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.DOUBLE);
        this.primitive = field.getType().isPrimitive();
        Optional<Config.RangeDouble> range = Optional.ofNullable(field.getAnnotation(Config.RangeDouble.class));
        this.min = range.map(Config.RangeDouble::min).orElse(-1.7976931348623157E308);
        this.max = range.map(Config.RangeDouble::max).orElse((Double)Double.MAX_VALUE);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultDouble.class)).map(Config.DefaultDouble::value).orElseThrow(() -> DoubleConfigField.noDefault(field, "DefaultDouble"));
        this.property.setDefaultValue(this.defaultValue);
        this.property.setMinValue(this.min);
        this.property.setMaxValue(this.max);
        if (!this.property.isDoubleValue()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + this.defaultValue + "]";
    }

    @Override
    protected Double getField() {
        return this.primitive ? this.field.getDouble(null) : ((Double)this.field.get(null)).doubleValue();
    }

    @Override
    protected void putField(Double value) {
        if (this.primitive) {
            this.field.setDouble(null, value);
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Double getConfig() {
        return this.property.getDouble();
    }

    @Override
    protected void putConfig(Double value) {
        this.property.set(value.doubleValue());
    }

    @Override
    protected Double getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        double value = this.getField();
        if (value >= this.min && value <= this.max) {
            return true;
        }
        ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, -1, Double.toString(value), Double.toString(this.min), Double.toString(this.max));
        return false;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeDouble(this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(input.readDouble());
    }
}

