/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class BooleanConfigField
extends AConfigField<Boolean> {
    private final boolean primitive;
    private final boolean defaultValue;

    public BooleanConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.BOOLEAN);
        this.primitive = field.getType().isPrimitive();
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultBoolean.class)).map(Config.DefaultBoolean::value).orElseThrow(() -> BooleanConfigField.noDefault(field, "DefaultBoolean"));
        this.property.setDefaultValue(this.defaultValue);
        if (!this.property.isBooleanValue()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[default: " + this.defaultValue + "]";
    }

    @Override
    protected Boolean getField() {
        return this.primitive ? this.field.getBoolean(null) : ((Boolean)this.field.get(null)).booleanValue();
    }

    @Override
    protected void putField(Boolean value) {
        if (this.primitive) {
            this.field.setBoolean(null, value);
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Boolean getConfig() {
        return this.property.getBoolean();
    }

    @Override
    protected void putConfig(Boolean value) {
        this.property.set(value.booleanValue());
    }

    @Override
    protected Boolean getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeBoolean(this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(input.readBoolean());
    }
}

