/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class AListConfigField<T>
extends AConfigField<T> {
    protected final boolean fixedLength;
    protected final int maxLength;

    protected AListConfigField(Field field, Configuration configuration, String category, Property.Type type) throws ConfigException {
        super(field, configuration, category, type, true);
        this.fixedLength = field.isAnnotationPresent(Config.ListFixedLength.class);
        this.maxLength = Optional.ofNullable(field.getAnnotation(Config.ListMaxLength.class)).map(Config.ListMaxLength::value).orElse(256);
        if (this.maxLength < 0) {
            throw new ConfigException("Negative length list configurations are not supported!\nField name: " + field.getName() + ", class: " + field.getDeclaringClass().getName());
        }
        this.property.setIsListLengthFixed(this.fixedLength);
        this.property.setMaxListLength(this.maxLength);
        this.property.comment = this.property.comment + "\n[fixed length: " + (this.fixedLength ? "yes" : "no") + ", max length: " + this.maxLength + "]";
    }

    protected abstract int length(T var1);

    protected abstract T arrayCopy(T var1);

    protected abstract void transmitElements(DataOutput var1, T var2) throws IOException;

    protected abstract void receiveElements(DataInput var1, T var2) throws IOException;

    protected abstract T createArray(int var1);

    @Override
    protected T getField() {
        return (T)this.arrayCopy(this.field.get(null));
    }

    @Override
    protected void putField(T value) {
        this.field.set(null, this.arrayCopy(value));
    }

    @Override
    public boolean validateField() {
        T f = this.getField();
        if (f == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        if (this.fixedLength && this.length(this.getDefault()) != this.length(f) || this.maxLength >= 0 && this.length(f) > this.maxLength) {
            ConfigValidationFailureEvent.postSize(this.field, this.length(f), this.fixedLength, this.maxLength, this.length(this.getDefault()));
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        T f = this.getField();
        output.writeInt(this.length(f));
        this.transmitElements(output, f);
    }

    @Override
    public void receive(DataInput input) throws IOException {
        int length = input.readInt();
        if (length > this.maxLength || this.fixedLength && this.length(this.getDefault()) != length) {
            throw new IOException("Error while retrieving config value for field " + this.field.getName() + " in class " + this.field.getDeclaringClass().getName() + ":\nIllegal array length received!");
        }
        T arr = this.createArray(length);
        this.receiveElements(input, arr);
    }
}

