/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.event;

import com.falsepattern.lib.config.event.ConfigSyncRequestEvent;
import com.falsepattern.lib.internal.impl.config.ConfigurationManagerImpl;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

@SideOnly(value=Side.CLIENT)
public final class ClientEventHandlerPost {
    private static final ClientEventHandlerPost INSTANCE = new ClientEventHandlerPost();
    private AtomicBoolean shouldDoConfigSync = new AtomicBoolean(false);

    public static void registerBus() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onSyncRequestClient(ConfigSyncRequestEvent.Client e) {
        ConfigurationManagerImpl.sendSyncRequest();
    }

    @SubscribeEvent
    public void onJoinWorld(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        if (e.isLocal) {
            return;
        }
        this.shouldDoConfigSync.set(true);
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent e) {
        if (e.world.field_72995_K && e.entity instanceof EntityClientPlayerMP && this.shouldDoConfigSync.compareAndSet(true, false)) {
            ConfigurationManagerImpl.sendSyncRequest();
        }
    }

    private ClientEventHandlerPost() {
    }
}

