/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.config;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.internal.core.LowLevelCallMultiplexer;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class EarlyConfig {
    @Expose
    @StableAPI.Expose(since="__INTERNAL__")
    private boolean enableLibraryDownloads;
    private static EarlyConfig instance = null;

    public static EarlyConfig load() {
        EarlyConfig config;
        if (instance != null) {
            return instance;
        }
        Path configFile = LowLevelCallMultiplexer.gameDir().resolve("config").resolve("falsepatternlib-early.json");
        Gson gson = new Gson();
        if (!Files.exists(configFile, new LinkOption[0])) {
            config = new EarlyConfig();
            config.enableLibraryDownloads(true);
        } else {
            config = (EarlyConfig)gson.fromJson(new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8), EarlyConfig.class);
        }
        Files.write(configFile, gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        instance = config;
        return config;
    }

    public boolean enableLibraryDownloads() {
        return this.enableLibraryDownloads;
    }

    public EarlyConfig enableLibraryDownloads(boolean enableLibraryDownloads) {
        this.enableLibraryDownloads = enableLibraryDownloads;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyConfig)) {
            return false;
        }
        EarlyConfig other = (EarlyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.enableLibraryDownloads() == other.enableLibraryDownloads();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EarlyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enableLibraryDownloads() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EarlyConfig(enableLibraryDownloads=" + this.enableLibraryDownloads() + ")";
    }
}

