/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.dependencies;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.dependencies.ComplexVersion;
import com.falsepattern.lib.dependencies.Version;
import java.util.Objects;
import lombok.NonNull;

@StableAPI(since="0.6.0")
public class SemanticVersion
extends Version {
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private final String preRelease;
    private final String build;

    @StableAPI.Expose
    public SemanticVersion(int majorVersion, int minorVersion, int patchVersion, String preRelease, String build) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        preRelease = preRelease == null ? null : preRelease.trim();
        build = build == null ? null : build.trim();
        this.preRelease = "".equals(preRelease) ? null : preRelease;
        this.build = "".equals(build) ? null : build;
    }

    @StableAPI.Expose
    public SemanticVersion(int majorVersion, int minorVersion, int patchVersion, String preRelease) {
        this(majorVersion, minorVersion, patchVersion, preRelease, null);
    }

    @StableAPI.Expose
    public SemanticVersion(int majorVersion, int minorVersion, int patchVersion) {
        this(majorVersion, minorVersion, patchVersion, null, null);
    }

    @StableAPI.Expose(since="0.10.0")
    public SemanticVersion(int majorVersion, int minorVersion) {
        this(majorVersion, minorVersion, -1, null, null);
    }

    @StableAPI.Expose(since="0.10.0")
    public SemanticVersion(int majorVersion) {
        this(majorVersion, -1, -1, null, null);
    }

    @StableAPI.Expose
    public static SemanticVersionBuilder builder() {
        return new SemanticVersionBuilder();
    }

    @Override
    public int compareTo(@NonNull Version o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        if (o instanceof ComplexVersion) {
            int result = this.compareTo(((ComplexVersion)o).versions[0]);
            if (result != 0) {
                return result;
            }
            if (((ComplexVersion)o).versions.length > 1) {
                return 1;
            }
            return 0;
        }
        if (o instanceof SemanticVersion) {
            SemanticVersion other = (SemanticVersion)o;
            if (this.majorVersion != other.majorVersion) {
                return this.majorVersion - other.majorVersion;
            }
            if (this.minorVersion != other.minorVersion) {
                return this.minorVersion - other.minorVersion;
            }
            if (this.patchVersion != other.patchVersion) {
                return this.patchVersion - other.patchVersion;
            }
            if (!Objects.equals(this.preRelease, other.preRelease)) {
                if (this.preRelease == null) {
                    return 1;
                }
                if (other.preRelease == null) {
                    return -1;
                }
                return this.preRelease.compareTo(other.preRelease);
            }
            return 0;
        }
        return 0;
    }

    public String toString() {
        return this.majorVersion + (this.minorVersion < 0 ? "" : "." + this.minorVersion) + (this.patchVersion < 0 ? "" : "." + this.patchVersion) + (this.preRelease == null ? "" : "-" + this.preRelease) + (this.build == null ? "" : "+" + this.build);
    }

    @StableAPI.Expose
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @StableAPI.Expose
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @StableAPI.Expose
    public int getPatchVersion() {
        return this.patchVersion;
    }

    @StableAPI.Expose
    public String getPreRelease() {
        return this.preRelease;
    }

    @StableAPI.Expose
    public String getBuild() {
        return this.build;
    }

    @StableAPI(since="0.10.0")
    public static class SemanticVersionBuilder {
        private int majorVersion;
        private int minorVersion = -1;
        private int patchVersion = -1;
        private String preRelease;
        private String build;

        @StableAPI.Internal
        SemanticVersionBuilder() {
        }

        @StableAPI.Expose
        public SemanticVersionBuilder majorVersion(int majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        @StableAPI.Expose
        public SemanticVersionBuilder minorVersion(int minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        @StableAPI.Expose
        public SemanticVersionBuilder patchVersion(int patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @StableAPI.Expose
        public SemanticVersionBuilder preRelease(String preRelease) {
            this.preRelease = preRelease;
            return this;
        }

        @StableAPI.Expose
        public SemanticVersionBuilder build(String build) {
            this.build = build;
            return this;
        }

        @StableAPI.Expose
        public SemanticVersion build() {
            return new SemanticVersion(this.majorVersion, this.minorVersion, this.patchVersion, this.preRelease, this.build);
        }

        public String toString() {
            return "SemanticVersion.SemanticVersionBuilder(majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", patchVersion=" + this.patchVersion + ", preRelease=" + this.preRelease + ", build=" + this.build + ")";
        }
    }
}

