/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.config.event;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.internal.EventUtil;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@StableAPI(since="0.10.0")
public class ConfigSyncEvent
extends Event {
    @StableAPI.Expose
    public final Class<?> configClass;

    @StableAPI.Internal
    public ConfigSyncEvent(Class<?> configClass) {
        this.configClass = configClass;
    }

    @StableAPI.Internal
    public static boolean postStart(Class<?> configClass) {
        Start event = new Start(configClass);
        return EventUtil.postOnCommonBus(event);
    }

    @StableAPI.Internal
    public static void postEndSuccess(Class<?> configClass) {
        EventUtil.postOnCommonBus(new End(configClass, true, null));
    }

    @StableAPI.Internal
    public static void postEndFailure(Class<?> configClass, Throwable error) {
        EventUtil.postOnCommonBus(new End(configClass, false, error));
    }

    @SideOnly(value=Side.CLIENT)
    @StableAPI(since="0.10.0")
    public static final class End
    extends ConfigSyncEvent {
        @StableAPI.Expose
        public final boolean successful;
        @StableAPI.Expose
        public final Throwable error;

        @StableAPI.Internal
        public End(Class<?> configClass, boolean successful, Throwable error) {
            super(configClass);
            this.successful = successful;
            this.error = error;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @StableAPI(since="0.10.0")
    public static final class Start
    extends ConfigSyncEvent {
        @StableAPI.Internal
        public Start(Class<?> configClass) {
            super(configClass);
        }

        public boolean isCancelable() {
            return true;
        }
    }
}

