/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.EnumFluidLock;
import portablejim.bbw.basics.EnumLock;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.conversion.CustomMapping;
import portablejim.bbw.core.wands.IWand;
import portablejim.bbw.shims.IPlayerShim;
import portablejim.bbw.shims.IWorldShim;

public class WandWorker {
    private final IWand wand;
    private final IPlayerShim player;
    private final IWorldShim world;
    HashSet<Point3d> allCandidates = new HashSet();

    public WandWorker(IWand wand, IPlayerShim player, IWorldShim world) {
        this.wand = wand;
        this.player = player;
        this.world = world;
    }

    public ItemStack getProperItemStack(IWorldShim world, IPlayerShim player, Point3d blockPos) {
        Block block = world.getBlock(blockPos);
        int meta = world.getMetadata(blockPos);
        String blockString = String.format("%s/%s", Block.field_149771_c.func_148750_c((Object)block), meta);
        if (!BetterBuildersWandsMod.instance.configValues.HARD_BLACKLIST_SET.contains(blockString)) {
            ItemStack exactItemstack = new ItemStack(block, 1, meta);
            if (Item.func_150898_a((Block)block) != null && player.countItems(exactItemstack) > 0) {
                return exactItemstack;
            }
            return this.getEquivalentItemStack(blockPos);
        }
        return null;
    }

    public ItemStack getEquivalentItemStack(Point3d blockPos) {
        Item dropped;
        Block block = this.world.getBlock(blockPos);
        int meta = this.world.getMetadata(blockPos);
        ItemStack stack = null;
        CustomMapping customMapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(block, meta);
        String blockString = String.format("%s/%s", Block.field_149771_c.func_148750_c((Object)block), meta);
        if (customMapping != null) {
            stack = customMapping.getItems();
        } else if (block.canSilkHarvest(this.world.getWorld(), this.player.getPlayer(), blockPos.x, blockPos.y, blockPos.z, meta)) {
            stack = BetterBuildersWandsMod.instance.blockCache.getStackedBlock(this.world, blockPos);
        } else if (!BetterBuildersWandsMod.instance.configValues.SOFT_BLACKLIST_SET.contains(blockString) && (dropped = block.func_149650_a(meta, new Random(), 0)) != null) {
            stack = new ItemStack(dropped, block.quantityDropped(meta, 0, new Random()), block.func_149692_a(meta));
        }
        return stack;
    }

    private boolean shouldContinue(Point3d currentCandidate, Block targetBlock, int targetMetadata, Block candidateSupportingBlock, int candidateSupportingMeta, AxisAlignedBB blockBB, EnumFluidLock fluidLock) {
        if (!this.world.blockIsAir(currentCandidate)) {
            Block currrentCandidateBlock = this.world.getBlock(currentCandidate);
            if (fluidLock != EnumFluidLock.IGNORE || currrentCandidateBlock == null || !(currrentCandidateBlock instanceof IFluidBlock) && !(currrentCandidateBlock instanceof BlockLiquid)) {
                return false;
            }
        }
        if (!targetBlock.equals(candidateSupportingBlock)) {
            return false;
        }
        if (targetMetadata != candidateSupportingMeta) {
            return false;
        }
        if (!targetBlock.func_149742_c(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z)) {
            return false;
        }
        if (!targetBlock.func_149718_j(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z)) {
            return false;
        }
        if (!targetBlock.func_149705_a(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z, targetMetadata, new ItemStack(candidateSupportingBlock, 1, candidateSupportingMeta))) {
            return false;
        }
        return !this.world.entitiesInBox(blockBB);
    }

    public LinkedList<Point3d> getBlockPositionList(Point3d blockLookedAt, ForgeDirection placeDirection, int maxBlocks, EnumLock directionLock, EnumLock faceLock, EnumFluidLock fluidLock) {
        LinkedList<Point3d> candidates = new LinkedList<Point3d>();
        LinkedList<Point3d> toPlace = new LinkedList<Point3d>();
        Block targetBlock = this.world.getBlock(blockLookedAt);
        int targetMetadata = this.world.getMetadata(blockLookedAt);
        Point3d startingPoint = blockLookedAt.move(placeDirection);
        int directionMaskInt = directionLock.mask;
        int faceMaskInt = faceLock.mask;
        if ((directionLock != EnumLock.HORIZONTAL && directionLock != EnumLock.VERTICAL || placeDirection != ForgeDirection.UP && placeDirection != ForgeDirection.DOWN) && (directionLock != EnumLock.NORTHSOUTH || placeDirection != ForgeDirection.NORTH && placeDirection != ForgeDirection.SOUTH) && (directionLock != EnumLock.EASTWEST || placeDirection != ForgeDirection.EAST && placeDirection != ForgeDirection.WEST)) {
            candidates.add(startingPoint);
        }
        while (candidates.size() > 0 && toPlace.size() < maxBlocks) {
            AxisAlignedBB blockBB;
            int candidateSupportingMeta;
            Point3d supportingPoint;
            Block candidateSupportingBlock;
            Point3d currentCandidate = (Point3d)candidates.removeFirst();
            if (!this.shouldContinue(currentCandidate, targetBlock, targetMetadata, candidateSupportingBlock = this.world.getBlock(supportingPoint = currentCandidate.move(placeDirection.getOpposite())), candidateSupportingMeta = this.world.getMetadata(supportingPoint), blockBB = targetBlock.func_149668_a(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z), fluidLock) || !this.allCandidates.add(currentCandidate)) continue;
            toPlace.add(currentCandidate);
            switch (placeDirection) {
                case DOWN: 
                case UP: {
                    if ((faceMaskInt & 2) <= 0) break;
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.NORTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.EAST));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.SOUTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.WEST));
                    }
                    if ((directionMaskInt & 1) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.NORTH).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.NORTH).move(ForgeDirection.WEST));
                    candidates.add(currentCandidate.move(ForgeDirection.SOUTH).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.SOUTH).move(ForgeDirection.WEST));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if ((faceMaskInt & 1) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.UP));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.EAST));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.DOWN));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.WEST));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.WEST));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.WEST));
                    break;
                }
                case WEST: 
                case EAST: {
                    if ((faceMaskInt & 4) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.UP));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.NORTH));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.DOWN));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.SOUTH));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 1) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.NORTH));
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.SOUTH));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.NORTH));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.SOUTH));
                }
            }
        }
        return toPlace;
    }

    public ArrayList<Point3d> placeBlocks(ItemStack wandItem, LinkedList<Point3d> blockPosList, Point3d originalBlock, ItemStack sourceItems, int side, float hitX, float hitY, float hitZ) {
        ArrayList<Point3d> placedBlocks = new ArrayList<Point3d>();
        for (Point3d blockPos : blockPosList) {
            boolean takeFromInventory;
            CustomMapping mapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(this.world.getBlock(originalBlock), this.world.getMetadata(originalBlock));
            boolean blockPlaceSuccess = mapping != null ? this.world.setBlock(blockPos, mapping.getPlaceBlock(), mapping.getPlaceMeta()) : this.world.copyBlock(originalBlock, blockPos);
            if (!blockPlaceSuccess) continue;
            Item itemFromBlock = Item.func_150898_a((Block)this.world.getBlock(originalBlock));
            this.world.playPlaceAtBlock(blockPos, this.world.getBlock(originalBlock));
            placedBlocks.add(blockPos);
            if (!this.player.isCreative()) {
                this.wand.placeBlock(wandItem, (EntityLivingBase)this.player.getPlayer());
            }
            if (takeFromInventory = this.player.useItem(sourceItems)) continue;
            FMLLog.info((String)"BBW takeback: %s", (Object[])new Object[]{blockPos.toString()});
            this.world.setBlockToAir(blockPos);
            placedBlocks.remove(placedBlocks.size() - 1);
        }
        return placedBlocks;
    }
}

