/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ItemTeleportStaff;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketLongDistanceTravelEvent;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.util.BaublesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TravelController {
    public static final TravelController instance = new TravelController();
    public SetMultimap<Integer, BlockCoord> travelDestinations = MultimapBuilder.hashKeys().hashSetValues().build();
    private Random rand = new Random();
    private boolean wasJumping = false;
    private boolean wasSneaking = false;
    private int delayTimer = 0;
    private final int timer = Config.travelAnchorCooldown;
    private boolean tempJump;
    private boolean tempSneak;
    private boolean showTargets = false;
    private boolean insufficientPower;
    public BlockCoord onBlockCoord;
    public BlockCoord selectedCoord;
    Camera currentView = new Camera();
    private final HashMap<BlockCoord, Float> candidates = new HashMap();
    private boolean selectionEnabled = true;
    private double fovRad;
    private double tanFovRad;
    private final List<GameRegistry.UniqueIdentifier> blackList = new ArrayList<GameRegistry.UniqueIdentifier>();

    private TravelController() {
        String[] blackListNames;
        for (String name : blackListNames = Config.travelStaffBlinkBlackList) {
            this.blackList.add(new GameRegistry.UniqueIdentifier(name));
        }
    }

    public String validatePacketTravelEvent(EntityPlayerMP toTp, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source) {
        if (!Config.validateTravelEventServerside) {
            return null;
        }
        BlockCoord target = new BlockCoord(x, y, z);
        double dist = this.getDistanceSquared((EntityPlayer)toTp, target);
        if (dist * 100.0 > (double)(source.getMaxDistanceTravelledSq() * 115)) {
            return "dist check fail";
        }
        if (this.getPower((EntityPlayer)toTp, source, target, -4.0f) > powerUse) {
            return "power use too little";
        }
        ItemStack equippedItem = toTp.func_71045_bC();
        switch (source) {
            case TELEPAD: {
                return "invalid travel source";
            }
            case BLOCK: {
                BlockCoord on = this.getActiveTravelBlock((EntityPlayer)toTp);
                if (on == null) {
                    return "on anchor is null";
                }
                if (on.x == x && on.z == z) {
                    return null;
                }
                TileEntity maybeAnchor = target.getTileEntity((IBlockAccess)toTp.field_70170_p);
                if (!(maybeAnchor instanceof ITravelAccessable)) {
                    return "not anchor";
                }
                ITravelAccessable anchor = (ITravelAccessable)maybeAnchor;
                if (!this.isValidTarget((EntityPlayer)toTp, target, TravelSource.BLOCK)) {
                    return "not valid target";
                }
                return null;
            }
            case STAFF: 
            case STAFF_BLINK: {
                if (Config.travelStaffKeybindEnabled && (equippedItem == null || equippedItem.func_77973_b() == null || !(equippedItem.func_77973_b() instanceof IItemOfTravel))) {
                    equippedItem = this.findTravelItemInInventoryOrBaubles((EntityPlayer)toTp);
                }
                if (equippedItem == null || !(equippedItem.func_77973_b() instanceof IItemOfTravel)) {
                    return "not staff";
                }
                if (!((IItemOfTravel)equippedItem.func_77973_b()).isActive((EntityPlayer)toTp, equippedItem)) {
                    return "staff not active";
                }
                int energy = ((IItemOfTravel)equippedItem.func_77973_b()).canExtractInternal(equippedItem, powerUse);
                if (energy != -1 && energy != powerUse) {
                    return "not enough power";
                }
                return null;
            }
            case TELEPORT_STAFF_BLINK: 
            case TELEPORT_STAFF: {
                if (equippedItem != null && equippedItem.func_77973_b() instanceof ItemTeleportStaff) {
                    return null;
                }
                return "not staff";
            }
        }
        throw new AssertionError((Object)"unidentified travel source");
    }

    public void addBlockToBlinkBlackList(String blockName) {
        this.blackList.add(new GameRegistry.UniqueIdentifier(blockName));
    }

    public boolean activateTravelAccessable(ItemStack equipped, World world, EntityPlayer player, TravelSource source) {
        ITravelAccessable ta;
        if (!this.hasTarget()) {
            PacketLongDistanceTravelEvent p = new PacketLongDistanceTravelEvent((Entity)player, false, source);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return false;
        }
        BlockCoord target = this.selectedCoord;
        TileEntity te = world.func_147438_o(target.x, target.y, target.z);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword(player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return true;
        }
        if (this.isTargetEnderIO()) {
            this.openEnderIO(equipped, world, player);
        } else if (Config.travelAnchorEnabled) {
            this.travelToSelectedTarget(player, source, false);
        }
        return true;
    }

    public boolean doBlink(ItemStack equipped, EntityPlayer player) {
        TravelSource source = TravelSource.STAFF_BLINK;
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        Vector3d sample = new Vector3d(look);
        sample.scale((double)Config.travelStaffMaxBlinkDistance);
        sample.add(eye);
        Vec3 eye3 = Vec3.func_72443_a((double)eye.x, (double)eye.y, (double)eye.z);
        Vec3 end = Vec3.func_72443_a((double)sample.x, (double)sample.y, (double)sample.z);
        double playerHeight = player.field_70129_M;
        double lookComp = -look.y * playerHeight;
        double maxDistance = (double)Config.travelStaffMaxBlinkDistance + lookComp;
        MovingObjectPosition p = player.field_70170_p.func_72901_a(eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p == null) {
            for (double i = maxDistance; i > 1.0; i -= 1.0) {
                sample.set(look);
                sample.scale(i);
                sample.add(eye);
                sample.y -= playerHeight;
                if (!this.doBlinkAround(player, source, sample, true)) continue;
                return true;
            }
            return false;
        }
        List res = Util.raytraceAll((World)player.field_70170_p, (Vec3)eye3, (Vec3)end, (!Config.travelStaffBlinkThroughClearBlocksEnabled ? 1 : 0) != 0);
        for (MovingObjectPosition pos : res) {
            Block hitBlock;
            if (pos == null || !this.isBlackListedBlock(player, pos, hitBlock = player.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d))) continue;
            maxDistance = Math.min(maxDistance, VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5)) - 1.5 - lookComp);
        }
        eye3 = Vec3.func_72443_a((double)eye.x, (double)eye.y, (double)eye.z);
        Vector3d targetBc = new Vector3d((double)p.field_72311_b, (double)p.field_72312_c, (double)p.field_72309_d);
        double sampleDistance = 1.5;
        double teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5)) + sampleDistance;
        while (teleDistance < maxDistance) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, source, sample, false)) {
                return true;
            }
            teleDistance += 1.0;
            sampleDistance += 1.0;
        }
        sampleDistance = -0.5;
        for (teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5)) + sampleDistance; teleDistance > 1.0; teleDistance -= 1.0) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, source, sample, false)) {
                return true;
            }
            sampleDistance -= 1.0;
        }
        return false;
    }

    public boolean doTeleport(EntityPlayer player) {
        TravelSource source = TravelSource.TELEPORT_STAFF_BLINK;
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        double playerHeight = player.field_70129_M;
        double teleDistance = Config.teleportStaffFailedBlinkDistance + 2;
        Vec3 eye3 = Vec3.func_72443_a((double)eye.x, (double)eye.y, (double)eye.z);
        double maxDistance = Config.teleportStaffMaxBlinkDistance;
        double currDistance = 0.0;
        Vec3 pos = eye3;
        boolean loop = true;
        while (loop) {
            double distance = 200.0;
            if (maxDistance - currDistance < 200.0) {
                distance = maxDistance - currDistance;
                loop = false;
            }
            Vector3d sample = new Vector3d(look);
            sample.scale(distance);
            sample.add(eye);
            Vec3 end = Vec3.func_72443_a((double)sample.x, (double)sample.y, (double)sample.z);
            MovingObjectPosition p = player.field_70170_p.func_72901_a(pos, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
            if (p != null) {
                teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5));
                break;
            }
            pos = end;
            currDistance += distance;
        }
        Vector3d sample = new Vector3d(look);
        sample.scale((double)Config.teleportStaffMaxBlinkDistance);
        sample.add(eye);
        Vec3 end = Vec3.func_72443_a((double)sample.x, (double)sample.y, (double)sample.z);
        MovingObjectPosition p = player.field_70170_p.func_72901_a(eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p != null) {
            teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5));
        }
        double distanceIncrement = -2.0;
        if (teleDistance < 3.0) {
            distanceIncrement = 2.0;
        }
        for (int i = 0; i < 8; ++i) {
            sample.set(look);
            sample.scale(teleDistance += distanceIncrement);
            sample.add(eye);
            sample.y -= playerHeight;
            if (!this.doBlinkAround(player, source, sample, false)) continue;
            return true;
        }
        return false;
    }

    public Optional<BlockCoord> findTravelDestination(EntityPlayer player, TravelSource source) {
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        TreeMap<Double, BlockCoord> distanceMap = new TreeMap<Double, BlockCoord>();
        double maxMessageDistance = 1.25 * (double)source.getMaxDistanceTravelled();
        boolean displayOutOfRangeMessage = false;
        for (BlockCoord p : this.travelDestinations.get((Object)player.field_70170_p.field_73011_w.field_76574_g)) {
            Vector3d block = new Vector3d((double)p.x + 0.5, (double)p.y + 0.5, (double)p.z + 0.5);
            block.sub(eye);
            double distance = block.length();
            if (distance > maxMessageDistance) continue;
            block.normalize();
            double angle = Math.acos(look.dot(block));
            if (!(angle < 0.087)) continue;
            if (distance > (double)source.getMaxDistanceTravelled()) {
                displayOutOfRangeMessage = true;
                continue;
            }
            distanceMap.put(distance, p);
        }
        if (displayOutOfRangeMessage && distanceMap.isEmpty()) {
            TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]));
        }
        return distanceMap.values().stream().findFirst();
    }

    private boolean isBlackListedBlock(EntityPlayer player, MovingObjectPosition pos, Block hitBlock) {
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Block)hitBlock);
        if (ui == null) {
            return false;
        }
        return this.blackList.contains(ui) && (hitBlock.func_149712_f(player.field_70170_p, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) < 0.0f || !Config.travelStaffBlinkThroughUnbreakableBlocksEnabled);
    }

    private boolean doBlinkAround(EntityPlayer player, TravelSource source, Vector3d sample, boolean conserveMomentum) {
        if (this.travelToLocation(player, source, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y), (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        if (this.travelToLocation(player, source, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) + 1, (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        return !Config.travelStaffSearchOptimize && this.travelToLocation(player, source, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) - 1, (int)Math.floor(sample.z)), conserveMomentum);
    }

    public boolean showTargets() {
        return this.showTargets && this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        if (!this.selectionEnabled) {
            this.candidates.clear();
        }
    }

    public boolean isBlockSelected(BlockCoord coord) {
        if (coord == null) {
            return false;
        }
        return coord.equals((Object)this.selectedCoord);
    }

    public void addCandidate(BlockCoord coord) {
        if (!this.candidates.containsKey(coord)) {
            this.candidates.put(coord, Float.valueOf(-1.0f));
        }
    }

    public int getMaxTravelDistanceSq() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean isTargetEnderIO() {
        if (this.selectedCoord == null) {
            return false;
        }
        return EnderIO.proxy.getClientPlayer().field_70170_p.func_147439_a(this.selectedCoord.x, this.selectedCoord.y, this.selectedCoord.z) == EnderIO.blockEnderIo;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)mc.field_71439_g);
        Vector3d lookAt = Util.getLookVecEio((EntityPlayer)mc.field_71439_g);
        lookAt.add(eye);
        Matrix4d mv = VecmathUtil.createMatrixAsLookAt((Vector3d)eye, (Vector3d)lookAt, (Vector3d)new Vector3d(0.0, 1.0, 0.0));
        float fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        Matrix4d pr = VecmathUtil.createProjectionMatrixAsPerspective((double)fov, (double)0.05f, (double)(mc.field_71474_y.field_151451_c * 16), (int)mc.field_71443_c, (int)mc.field_71440_d);
        this.currentView.setProjectionMatrix(pr);
        this.currentView.setViewMatrix(mv);
        this.currentView.setViewport(0, 0, mc.field_71443_c, mc.field_71440_d);
        this.fovRad = Math.toRadians(fov);
        this.tanFovRad = Math.tanh(this.fovRad);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            this.onBlockCoord = this.getActiveTravelBlock((EntityPlayer)player);
            boolean onBlock = this.onBlockCoord != null;
            boolean bl = this.showTargets = onBlock || this.isTravelItemActive((EntityPlayer)player, false);
            if (this.showTargets) {
                this.updateSelectedTarget((EntityPlayer)player);
            } else {
                this.selectedCoord = null;
            }
            MovementInput input = player.field_71158_b;
            this.tempJump = input.field_78901_c;
            this.tempSneak = input.field_78899_d;
            if ((input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord != null && this.delayTimer == 0 || input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord != null && this.delayTimer == 0 && Config.travelAnchorSneak) && this.onInput(player)) {
                this.delayTimer = this.timer;
            }
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget((EntityPlayer)player, 1);
                if (this.onInput(player)) {
                    this.delayTimer = this.timer;
                }
            }
            if (input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget((EntityPlayer)player, -1);
                if (this.onInput(player)) {
                    this.delayTimer = this.timer;
                }
            }
            if (this.delayTimer != 0) {
                --this.delayTimer;
            }
            this.wasJumping = this.tempJump;
            this.wasSneaking = this.tempSneak;
            this.candidates.clear();
            this.insufficientPower = false;
        }
    }

    public boolean hasTarget() {
        return this.selectedCoord != null;
    }

    public void openEnderIO(ItemStack equipped, World world, EntityPlayer player) {
        BlockCoord target = TravelController.instance.selectedCoord;
        TileEntity te = world.func_147438_o(target.x, target.y, target.z);
        if (!(te instanceof TileEnderIO)) {
            return;
        }
        TileEnderIO eio = (TileEnderIO)te;
        if (eio.canBlockBeAccessed(player)) {
            int requiredPower;
            int n = requiredPower = equipped == null ? 0 : instance.getRequiredPower(player, TravelSource.STAFF, target);
            if (requiredPower <= 0 || requiredPower <= this.getEnergyInTravelItem(equipped)) {
                if (requiredPower > 0) {
                    PacketDrainStaff p = new PacketDrainStaff(requiredPower);
                    PacketHandler.INSTANCE.sendToServer((IMessage)p);
                }
                player.openGui((Object)EnderIO.instance, 1, world, target.x, TravelController.instance.selectedCoord.y, TravelController.instance.selectedCoord.z);
            }
        } else {
            TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
        }
    }

    public int getEnergyInTravelItem(ItemStack equipped) {
        if (equipped == null || !(equipped.func_77973_b() instanceof IItemOfTravel)) {
            return 0;
        }
        return ((IItemOfTravel)equipped.func_77973_b()).getEnergyStored(equipped);
    }

    public boolean isTravelItemActive(EntityPlayer ep, boolean checkInventoryAndBaubles) {
        return this.getTravelItemTravelSource(ep, checkInventoryAndBaubles) != null;
    }

    @Nullable
    public TravelSource getTravelItemTravelSource(EntityPlayer ep, boolean checkInventoryAndBaubles) {
        if (ep == null) {
            return null;
        }
        ItemStack equipped = ep.func_71045_bC();
        if (checkInventoryAndBaubles && (equipped == null || !(equipped.func_77973_b() instanceof IItemOfTravel))) {
            equipped = this.findTravelItemInInventoryOrBaubles(ep);
        }
        if (equipped != null) {
            if (equipped.func_77973_b() instanceof ItemTeleportStaff) {
                if (((ItemTeleportStaff)equipped.func_77973_b()).isActive(ep, equipped)) {
                    return TravelSource.TELEPORT_STAFF;
                }
            } else if (equipped.func_77973_b() instanceof IItemOfTravel && ((IItemOfTravel)equipped.func_77973_b()).isActive(ep, equipped)) {
                return TravelSource.STAFF;
            }
        }
        return null;
    }

    @Nullable
    public ItemStack findTravelItemInInventoryOrBaubles(EntityPlayer ep) {
        IInventory baubles;
        ItemStack travelItem = null;
        for (int i = 0; i < ep.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = ep.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IItemOfTravel)) continue;
            travelItem = stack;
            break;
        }
        if (travelItem == null && (baubles = BaublesUtil.instance().getBaubles(ep)) != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IItemOfTravel)) continue;
                travelItem = stack;
                break;
            }
        }
        return travelItem;
    }

    public int findTravelItemSlotInInventoryOrBaubles(EntityPlayer ep) {
        IInventory baubles;
        int travelItemSlot = -1;
        for (int i = 0; i < ep.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = ep.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IItemOfTravel)) continue;
            travelItemSlot = i;
            break;
        }
        if (travelItemSlot == -1 && (baubles = BaublesUtil.instance().getBaubles(ep)) != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IItemOfTravel)) continue;
                travelItemSlot = -(i + 2);
                break;
            }
        }
        return travelItemSlot;
    }

    public boolean travelToSelectedTarget(EntityPlayer player, TravelSource source, boolean conserveMomentum) {
        return this.travelToLocation(player, source, this.selectedCoord, conserveMomentum);
    }

    public boolean travelToLocation(EntityPlayer player, TravelSource source, BlockCoord coord, boolean conserveMomentum) {
        ITravelAccessable ta;
        TileEntity te;
        if (source != TravelSource.STAFF_BLINK && source != TravelSource.TELEPORT_STAFF_BLINK && (te = player.field_70170_p.func_147438_o(coord.x, coord.y, coord.z)) instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        int requiredPower = 0;
        requiredPower = this.getRequiredPower(player, source, coord);
        if (requiredPower < 0) {
            return false;
        }
        if (!this.isInRangeTarget(player, coord, source.getMaxDistanceTravelledSq())) {
            if (source != TravelSource.STAFF_BLINK && source != TravelSource.TELEPORT_STAFF_BLINK) {
                TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]));
            }
            return false;
        }
        if (!this.isValidTarget(player, coord, source)) {
            if (source != TravelSource.STAFF_BLINK && source != TravelSource.TELEPORT_STAFF_BLINK) {
                TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]));
            }
            return false;
        }
        if (this.doClientTeleport((Entity)player, coord, source, requiredPower, conserveMomentum)) {
            for (int i = 0; i < 6; ++i) {
                player.field_70170_p.func_72869_a("portal", player.field_70165_t + (this.rand.nextDouble() - 0.5), player.field_70163_u + this.rand.nextDouble() * (double)player.field_70131_O - 0.25, player.field_70161_v + (this.rand.nextDouble() - 0.5), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
            }
        }
        return true;
    }

    public int getRequiredPower(EntityPlayer player, TravelSource source, BlockCoord coord) {
        int canUsePower;
        int requiredPower;
        if (!this.isTravelItemActive(player, true)) {
            return 0;
        }
        ItemStack staff = player.func_71045_bC();
        if (staff == null || !(staff.func_77973_b() instanceof IItemOfTravel)) {
            staff = this.findTravelItemInInventoryOrBaubles(player);
        }
        if ((requiredPower = this.getPower(player, source, coord, 0.0f)) > (canUsePower = this.getEnergyInTravelItem(staff))) {
            if (!this.insufficientPower) {
                TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.itemTravelStaff.notEnoughPower", new Object[0]));
                this.insufficientPower = true;
            }
            return -1;
        }
        return requiredPower;
    }

    private int getPower(EntityPlayer player, TravelSource source, BlockCoord coord, float distanceWavier) {
        return (int)((this.getDistance(player, coord) + (double)distanceWavier) * (double)source.getPowerCostPerBlockTraveledRF());
    }

    private boolean isInRangeTarget(EntityPlayer player, BlockCoord bc, float maxSq) {
        return this.getDistanceSquared(player, bc) <= (double)maxSq;
    }

    private double getDistanceSquared(EntityPlayer player, BlockCoord bc) {
        if (player == null || bc == null) {
            return 0.0;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d target = new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
        return eye.distanceSquared(target);
    }

    private double getDistance(EntityPlayer player, BlockCoord coord) {
        return Math.sqrt(this.getDistanceSquared(player, coord));
    }

    private boolean isValidTarget(EntityPlayer player, BlockCoord bc, TravelSource source) {
        if (bc == null) {
            return false;
        }
        World w = player.field_70170_p;
        BlockCoord baseLoc = bc;
        if (source != TravelSource.STAFF_BLINK && source != TravelSource.TELEPORT_STAFF_BLINK) {
            baseLoc = bc.getLocation(ForgeDirection.UP);
        }
        return this.canTeleportTo(player, source, baseLoc, w) && this.canTeleportTo(player, source, baseLoc.getLocation(ForgeDirection.UP), w);
    }

    private boolean canTeleportTo(EntityPlayer player, TravelSource source, BlockCoord bc, World w) {
        Vec3 target;
        Vec3 start;
        if (bc.y < 1) {
            return false;
        }
        if (source == TravelSource.STAFF_BLINK && !Config.travelStaffBlinkThroughSolidBlocksEnabled && !this.canBlinkTo(bc, w, start = Util.getEyePosition((EntityPlayer)player), target = Vec3.func_72443_a((double)((float)bc.x + 0.5f), (double)((float)bc.y + 0.5f), (double)((float)bc.z + 0.5f)))) {
            return false;
        }
        Block block = w.func_147439_a(bc.x, bc.y, bc.z);
        if (block == null || block.isAir((IBlockAccess)w, bc.x, bc.y, bc.z)) {
            return true;
        }
        AxisAlignedBB aabb = block.func_149668_a(w, bc.x, bc.y, bc.z);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private boolean canBlinkTo(BlockCoord bc, World w, Vec3 start, Vec3 target) {
        MovingObjectPosition p = w.func_72901_a(start, target, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p != null) {
            if (!Config.travelStaffBlinkThroughClearBlocksEnabled) {
                return false;
            }
            Block block = w.func_147439_a(p.field_72311_b, p.field_72312_c, p.field_72309_d);
            if (this.isClear(w, block, p.field_72311_b, p.field_72312_c, p.field_72309_d)) {
                if (new BlockCoord(p.field_72311_b, p.field_72312_c, p.field_72309_d).equals((Object)bc)) {
                    return true;
                }
                Vector3d sv = new Vector3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
                Vector3d rayDir = new Vector3d(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                rayDir.sub(sv);
                rayDir.normalize();
                rayDir.add(sv);
                return this.canBlinkTo(bc, w, Vec3.func_72443_a((double)rayDir.x, (double)rayDir.y, (double)rayDir.z), target);
            }
            return false;
        }
        return true;
    }

    private boolean isClear(World w, Block block, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)w, x, y, z)) {
            return true;
        }
        AxisAlignedBB aabb = block.func_149668_a(w, x, y, z);
        if (aabb == null || aabb.func_72320_b() < 0.7) {
            return true;
        }
        return block.getLightOpacity((IBlockAccess)w, x, y, z) < 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateVerticalTarget(EntityPlayer player, int direction) {
        BlockCoord currentBlock = this.getActiveTravelBlock(player);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int i = 0;
        for (int y = currentBlock.y + direction; i < Config.travelAnchorMaxDistance && y >= 0 && y <= 255; ++i, y += direction) {
            BlockCoord targetBlock = this.getValidVerticalTarget(player, currentBlock, (World)world, y);
            if (targetBlock == null) continue;
            this.selectedCoord = targetBlock;
            return;
        }
    }

    private BlockCoord getValidVerticalTarget(EntityPlayer player, BlockCoord currentBlock, World world, int y) {
        TileEntity selectedBlock = world.func_147438_o(currentBlock.x, y, currentBlock.z);
        if (selectedBlock instanceof ITravelAccessable) {
            ITravelAccessable travelBlock = (ITravelAccessable)selectedBlock;
            BlockCoord targetBlock = new BlockCoord(currentBlock.x, y, currentBlock.z);
            if (Config.travelAnchorSkipWarning) {
                if (travelBlock.getRequiresPassword(player)) {
                    TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipLocked", new Object[0]));
                }
                if (travelBlock.getAccessMode() == ITravelAccessable.AccessMode.PRIVATE && !travelBlock.canUiBeAccessed(player)) {
                    TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipPrivate", new Object[0]));
                }
                if (!this.isValidTarget(player, targetBlock, TravelSource.BLOCK)) {
                    TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.skipObstructed", new Object[0]));
                }
            }
            if (travelBlock.canBlockBeAccessed(player) && this.isValidTarget(player, targetBlock, TravelSource.BLOCK)) {
                return targetBlock;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSelectedTarget(EntityPlayer player) {
        this.selectedCoord = null;
        if (this.candidates.isEmpty()) {
            return;
        }
        double closestDistance = Double.MAX_VALUE;
        for (BlockCoord bc : this.candidates.keySet()) {
            double d;
            if (bc.equals((Object)this.onBlockCoord) || !((d = this.addRatio(bc)) < closestDistance)) continue;
            this.selectedCoord = bc;
            closestDistance = d;
        }
        if (this.selectedCoord != null) {
            Vector3d blockCenter = new Vector3d((double)this.selectedCoord.x + 0.5, (double)this.selectedCoord.y + 0.5, (double)this.selectedCoord.z + 0.5);
            Vector2d blockCenterPixel = this.currentView.getScreenPoint(blockCenter);
            Vector2d screenMidPixel = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
            screenMidPixel.scale(0.5);
            double pixDist = blockCenterPixel.distance(screenMidPixel);
            double rat = pixDist / (double)Minecraft.func_71410_x().field_71440_d;
            if (rat != rat) {
                rat = 0.0;
            }
            if (rat > 0.07) {
                this.selectedCoord = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean onInput(EntityClientPlayerMP player) {
        ITravelAccessable ta;
        MovementInput input = player.field_71158_b;
        BlockCoord target = TravelController.instance.selectedCoord;
        if (target == null) {
            return false;
        }
        TileEntity te = player.field_70170_p.func_147438_o(target.x, target.y, target.z);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword((EntityPlayer)player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return false;
        }
        if (this.isTargetEnderIO()) {
            this.openEnderIO(null, player.field_70170_p, (EntityPlayer)player);
            return true;
        }
        if (Config.travelAnchorEnabled && this.travelToSelectedTarget((EntityPlayer)player, TravelSource.BLOCK, false)) {
            input.field_78901_c = false;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"flyToggleTimer", "field_71101_bC"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public double getScaleForCandidate(Vector3d loc) {
        if (!this.currentView.isValid()) {
            return 1.0;
        }
        BlockCoord bc = new BlockCoord(loc.x, loc.y, loc.z);
        float ratio = -1.0f;
        Float r = this.candidates.get(bc);
        if (r != null) {
            ratio = r.floatValue();
        }
        if (ratio < 0.0f) {
            this.addRatio(bc);
            ratio = this.candidates.get(bc).floatValue();
        }
        float start = 0.2f;
        float end = 0.01f;
        double mix = MathHelper.func_76131_a((float)((start - ratio) / (start - end)), (float)0.0f, (float)1.0f);
        double scale = 1.0;
        if (mix > 0.0) {
            Vector3d eyePoint = Util.getEyePositionEio((EntityPlayer)EnderIO.proxy.getClientPlayer());
            scale = this.tanFovRad * eyePoint.distance(loc);
            scale *= (double)Config.travelAnchorZoomScale;
            float nf = 1.0f - MathHelper.func_76131_a((float)((float)eyePoint.distanceSquared(loc) / (float)TravelSource.STAFF.getMaxDistanceTravelledSq()), (float)0.0f, (float)1.0f);
            scale *= 0.3 + 0.7 * (double)nf;
            scale = scale * mix + (1.0 - mix);
            scale = Math.max(1.0, scale);
        }
        return scale;
    }

    @SideOnly(value=Side.CLIENT)
    private double addRatio(BlockCoord bc) {
        Vector2d sp = this.currentView.getScreenPoint(new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5));
        Vector2d mid = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
        mid.scale(0.5);
        double d = sp.distance(mid);
        if (d != d) {
            d = 0.0;
        }
        float ratio = (float)d / (float)Minecraft.func_71410_x().field_71443_c;
        this.candidates.put(bc, Float.valueOf(ratio));
        return d;
    }

    @SideOnly(value=Side.CLIENT)
    private int getMaxTravelDistanceSqForPlayer(EntityPlayer player) {
        TravelSource source = this.getTravelItemTravelSource(player, false);
        if (source == null) {
            return TravelSource.BLOCK.getMaxDistanceTravelledSq();
        }
        return source.getMaxDistanceTravelledSq();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doClientTeleport(Entity entity, BlockCoord bc, TravelSource source, int powerUse, boolean conserveMomentum) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, bc.x, bc.y, bc.z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        bc = new BlockCoord(evt.targetX, evt.targetY, evt.targetZ);
        PacketTravelEvent p = new PacketTravelEvent(entity, bc.x, bc.y, bc.z, powerUse, conserveMomentum, source);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
        return true;
    }

    private BlockCoord getActiveTravelBlock(EntityPlayer player) {
        int z;
        int y;
        if (player == null) {
            return null;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return null;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        TileEntity tileEntity = world.func_147438_o(x, y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v));
        if (tileEntity instanceof ITravelAccessable && ((ITravelAccessable)tileEntity).isTravelSource()) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }

    public static void showMessage(EntityPlayer player, IChatComponent chatComponent) {
        if (Loader.isModLoaded((String)"gtnhlib")) {
            if (player instanceof EntityPlayerMP) {
                chatComponent.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE));
                GTNHLib.proxy.sendMessageAboveHotbar((EntityPlayerMP)player, chatComponent, 60, true, true);
            } else {
                GTNHLib.proxy.printMessageAboveHotbar(EnumChatFormatting.WHITE + chatComponent.func_150254_d(), 60, true, true);
            }
        } else {
            player.func_146105_b(chatComponent);
        }
    }
}

