/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileExperienceObelisk
extends AbstractMachineEntity
implements IFluidHandler,
IHaveExperience,
ITankAccess {
    private ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.xpObeliskMaxXpLevel));

    public TileExperienceObelisk() {
        super(new SlotDefinition(0, 0, 0));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockExperienceObelisk.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        return false;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull((IFluidHandler)this, (ForgeDirection)dir, (int)Config.fluidConduitMaxIoRate);
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        boolean res = super.doPush(dir);
        FluidUtil.doPush((IFluidHandler)this, (ForgeDirection)dir, (int)Config.fluidConduitMaxIoRate);
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canFill(from, fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.xpCont.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.xpCont.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCont.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.xpCont.getTankInfo(from);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.xpCont.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.xpCont.writeToNBT(nbtRoot);
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }
}

