/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class SolarUpgrade
extends AbstractUpgrade {
    private static final String KEY_LEVEL = "level";
    private static final String UPGRADE_NAME = "speedBoost";
    public static final SolarUpgrade SOLAR_ONE = new SolarUpgrade("enderio.darksteel.upgrade.solar_one", 1, Config.darkSteelSolarOneCost);
    public static final SolarUpgrade SOLAR_TWO = new SolarUpgrade("enderio.darksteel.upgrade.solar_two", 2, Config.darkSteelSolarTwoCost);
    public static final SolarUpgrade SOLAR_THREE = new SolarUpgrade("enderio.darksteel.upgrade.solar_three", 3, Config.darkSteelSolarThreeCost);
    private Render render;
    private byte level;

    public static SolarUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77990_d == null) {
            return null;
        }
        if (!stack.field_77990_d.func_74764_b("enderio.darksteel.upgrade.speedBoost")) {
            return null;
        }
        return new SolarUpgrade((NBTTagCompound)stack.field_77990_d.func_74781_a("enderio.darksteel.upgrade.speedBoost"));
    }

    private static ItemStack createUpgradeItem(int level) {
        return new ItemStack((Block)EnderIO.blockSolarPanel, 1, level - 1);
    }

    public SolarUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.func_74771_c(KEY_LEVEL);
    }

    public SolarUpgrade(String unlocName, byte level, int levelCost) {
        super(UPGRADE_NAME, unlocName, SolarUpgrade.createUpgradeItem(level), levelCost);
        this.level = level;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || !DarkSteelItems.isArmorPart(stack.func_77973_b(), 0) || !EnergyUpgrade.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return this.level == 1;
        }
        return up.level == this.level - 1;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((Block)EnderIO.blockSolarPanel, 1, this.level - 1);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74774_a(KEY_LEVEL, this.level);
    }

    public int getRFPerSec() {
        if (this.level == 0) {
            return Config.darkSteelSolarOneGen;
        }
        if (this.level == 1) {
            return Config.darkSteelSolarTwoGen;
        }
        return Config.darkSteelSolarThreeGen;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        return this.render == null ? (this.render = new Render()) : this.render;
    }

    @SideOnly(value=Side.CLIENT)
    private class Render
    implements IRenderUpgrade {
        private EntityItem item;

        private Render() {
            this.item = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        }

        @Override
        public void render(RenderPlayerEvent event, ItemStack stack, boolean head) {
            if (head) {
                RenderUtil.bindItemTexture();
                GL11.glDepthMask((boolean)true);
                this.item.field_70290_d = 0.0f;
                IRenderUpgrade.Helper.translateToHeadLevel(event.entityPlayer);
                GL11.glTranslated((double)0.0, (double)-0.155, (double)0.0);
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glScalef((float)2.1f, (float)2.1f, (float)2.1f);
                byte level = SolarUpgrade.loadFromItem(stack).level;
                this.item.func_92058_a(new ItemStack((Block)EnderIO.blockSolarPanel, 1, level - 1));
                RenderManager.field_78727_a.func_147940_a((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
        }
    }
}

