/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitRenderer;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.tool.ToolUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class AbstractEnderLiquidConduit
extends AbstractLiquidConduit {
    public static final String ICON_KEY_INPUT = "enderio:itemConduitInput";
    public static final String ICON_KEY_OUTPUT = "enderio:itemConduitOutput";
    public static final String ICON_KEY_IN_OUT_BG = "enderio:itemConduitIoConnector";
    public static final String ICON_KEY_IN_OUT_OUT = "enderio:itemConduitInOut_Out";
    public static final String ICON_KEY_IN_OUT_IN = "enderio:itemConduitInOut_In";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private final Set<BlockCoord> filledFromThisTick = new HashSet<BlockCoord>();
    private EnderLiquidConduitNetwork network;
    private int ticksSinceFailedExtract;
    private final EnumMap<ForgeDirection, FluidFilter> outputFilters = new EnumMap(ForgeDirection.class);
    private final EnumMap<ForgeDirection, FluidFilter> inputFilters = new EnumMap(ForgeDirection.class);
    protected final EnumMap<ForgeDirection, DyeColor> outputColors = new EnumMap(ForgeDirection.class);
    protected final EnumMap<ForgeDirection, DyeColor> inputColors = new EnumMap(ForgeDirection.class);
    private int roundRobin = 0;

    @Override
    public ConduitRenderer getRenderer() {
        return EnderLiquidConduitRenderer.instance.get();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put(AbstractEnderLiquidConduit.ICON_KEY_INPUT, register.func_94245_a(AbstractEnderLiquidConduit.ICON_KEY_INPUT));
                ICONS.put(AbstractEnderLiquidConduit.ICON_KEY_OUTPUT, register.func_94245_a(AbstractEnderLiquidConduit.ICON_KEY_OUTPUT));
                ICONS.put(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_OUT, register.func_94245_a(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_OUT));
                ICONS.put(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_IN, register.func_94245_a(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_IN));
                ICONS.put(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_BG, register.func_94245_a(AbstractEnderLiquidConduit.ICON_KEY_IN_OUT_BG));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public abstract Type getType();

    public abstract int getMetadata();

    protected abstract IIcon getIconKey();

    protected abstract IIcon getIconCoreKey();

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!(n instanceof AbstractEnderLiquidConduit)) {
                        return false;
                    }
                    if (this.getType() != ((AbstractEnderLiquidConduit)n).getType()) {
                        return false;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemLiquidConduit, 1, this.getMetadata());
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public FluidFilter getFilter(ForgeDirection dir, boolean isInput) {
        if (isInput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setFilter(ForgeDirection dir, FluidFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof EnderLiquidConduitNetwork)) {
            return false;
        }
        this.network = (EnderLiquidConduitNetwork)network;
        for (ForgeDirection dir : this.externalConnections) {
            this.network.connectionChanged(this, dir);
        }
        return true;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return this.getIconCoreKey();
        }
        return this.getIconKey();
    }

    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_KEY_INPUT);
    }

    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_KEY_OUTPUT);
    }

    public IIcon getTextureForInOutMode(boolean input) {
        return input ? ICONS.get(ICON_KEY_IN_OUT_IN) : ICONS.get(ICON_KEY_IN_OUT_OUT);
    }

    public IIcon getTextureForInOutBackground() {
        return ICONS.get(ICON_KEY_IN_OUT_BG);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof AbstractEnderLiquidConduit)) {
            return false;
        }
        return this.getType() == ((AbstractEnderLiquidConduit)con).getType();
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnections(dir);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshConnections(dir);
    }

    private void refreshConnections(ForgeDirection dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        this.filledFromThisTick.clear();
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (ForgeDirection dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        if (this.filledFromThisTick.contains(this.getLocation().getLocation(from))) {
            return 0;
        }
        if (doFill) {
            this.filledFromThisTick.add(this.getLocation().getLocation(from));
        }
        return this.network.fillFrom(this, from, resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.network == null) {
            return new FluidTankInfo[0];
        }
        return this.network.getTankInfo(this, from);
    }

    public DyeColor getInputColor(ForgeDirection dir) {
        DyeColor result = this.inputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    public DyeColor getOutputColor(ForgeDirection dir) {
        DyeColor result = this.outputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    public void setInputColor(ForgeDirection dir, DyeColor col) {
        this.inputColors.put(dir, col);
        if (this.network != null) {
            this.network.notifyNetworkOfUpdate();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    public void setOutputColor(ForgeDirection dir, DyeColor col) {
        this.outputColors.put(dir, col);
        if (this.network != null) {
            this.network.notifyNetworkOfUpdate();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        super.readTypeSettings(dir, dataRoot);
        if (dataRoot.func_74764_b("inputColor")) {
            this.setInputColor(dir, DyeColor.values()[dataRoot.func_74765_d("inputColor")]);
        }
        if (dataRoot.func_74764_b("outputColor")) {
            this.setOutputColor(dir, DyeColor.values()[dataRoot.func_74765_d("outputColor")]);
        }
        if (dataRoot.func_74764_b("roundRobin")) {
            this.setRoundRobin(dir, dataRoot.func_74767_n("roundRobin"));
        } else {
            this.setRoundRobin(dir, true);
        }
        if (dataRoot.func_74764_b("outputFilters")) {
            FluidFilter out = new FluidFilter();
            out.readFromNBT(dataRoot.func_74775_l("outputFilters"));
            this.outputFilters.put(dir, out);
        }
        if (dataRoot.func_74764_b("inputFilters")) {
            FluidFilter in = new FluidFilter();
            in.readFromNBT(dataRoot.func_74775_l("inputFilters"));
            this.inputFilters.put(dir, in);
        }
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        FluidFilter in;
        super.writeTypeSettingsToNbt(dir, dataRoot);
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("roundRobin", this.isRoundRobin(dir));
        FluidFilter out = this.outputFilters.get(dir);
        if (out != null) {
            NBTTagCompound outTag = new NBTTagCompound();
            out.writeToNBT(outTag);
            dataRoot.func_74782_a("outputFilters", (NBTBase)outTag);
        }
        if ((in = this.inputFilters.get(dir)) != null) {
            NBTTagCompound inTag = new NBTTagCompound();
            in.writeToNBT(inTag);
            dataRoot.func_74782_a("inputFilters", (NBTBase)inTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        FluidFilter f;
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74768_a("roundRobin", this.roundRobin);
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<ForgeDirection, FluidFilter> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.roundRobin = nbtRoot.func_74764_b("roundRobin") ? nbtRoot.func_74762_e("roundRobin") : 63;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            short ord;
            FluidFilter f;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                f = new FluidFilter();
                f.readFromNBT(filterTag);
                if (!f.isEmpty()) {
                    this.inputFilters.put(dir, f);
                }
            }
            if (nbtRoot.func_74764_b(key = "outFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                f = new FluidFilter();
                f.readFromNBT(filterTag);
                if (!f.isEmpty()) {
                    this.outputFilters.put(dir, f);
                }
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, DyeColor.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "outSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.outputColors.put(dir, DyeColor.values()[ord]);
        }
    }

    public boolean isRoundRobin(ForgeDirection dir) {
        return (this.roundRobin & dir.flag) != 0;
    }

    public void setRoundRobin(ForgeDirection dir, boolean roundRobin) {
        this.roundRobin = roundRobin ? (this.roundRobin |= dir.flag) : (this.roundRobin &= ~dir.flag);
    }

    public static enum Type {
        ENDER(() -> Config.enderFluidConduitExtractRate, () -> Config.enderFluidConduitMaxIoRate),
        CRYSTALLINE(() -> Config.crystallineEnderFluidConduitExtractRate, () -> Config.crystallineEnderFluidConduitMaxIoRate),
        CRYSTALLINE_PINK_SLIME(() -> Config.crystallinePinkSlimeEnderFluidConduitExtractRate, () -> Config.crystallinePinkSlimeEnderFluidConduitMaxIoRate),
        MELODIC(() -> Config.melodicEnderFluidConduitExtractRate, () -> Config.melodicEnderFluidConduitMaxIoRate),
        STELLAR(() -> Config.stellarEnderFluidConduitExtractRate, () -> Config.stellarEnderFluidConduitMaxIoRate);

        private final Supplier<Integer> getMaxExtractPerTick;
        private final Supplier<Integer> getMaxIoPerTick;

        private Type(Supplier<Integer> getMaxExtractPerTick, Supplier<Integer> getMaxIoPerTick) {
            this.getMaxExtractPerTick = getMaxExtractPerTick;
            this.getMaxIoPerTick = getMaxIoPerTick;
        }

        public int getMaxExtractPerTick() {
            return this.getMaxExtractPerTick.get();
        }

        public int getMaxIoPerTick() {
            return this.getMaxIoPerTick.get();
        }
    }
}

