/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.energy.TileEngineIron;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerFuelBelowThreshold
extends BCStatement
implements ITriggerExternal {
    private float threshold;

    public TriggerFuelBelowThreshold(float threshold) {
        super(new String[]{"buildcraft:trigger.fuelLevelBelow." + (int)(threshold * 100.0f)});
        this.threshold = threshold;
    }

    public String getDescription() {
        return String.format(StringUtils.localize((String)"gate.trigger.fuelLevelBelow"), (int)(this.threshold * 100.0f));
    }

    public boolean isTriggerActive(TileEntity target, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(target instanceof TileEngineIron)) {
            return false;
        }
        return ((TileEngineIron)target).hasFuelBelowThreshold(this.threshold);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraftenergy:triggers/trigger_fuel_below_threshold");
    }
}

