/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.fuels;

import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;

public final class FuelManager
implements IFuelManager {
    public static final FuelManager INSTANCE = new FuelManager();
    private final List<IFuel> fuels = new LinkedList<IFuel>();

    private FuelManager() {
    }

    public IFuel addFuel(IFuel fuel) {
        this.fuels.add(fuel);
        return fuel;
    }

    public IFuel addFuel(Fluid fluid, int powerPerCycle, int totalBurningTime) {
        return this.addFuel(new BCFuel(fluid, powerPerCycle, totalBurningTime));
    }

    public Collection<IFuel> getFuels() {
        return this.fuels;
    }

    public IFuel getFuel(Fluid fluid) {
        for (IFuel fuel : this.fuels) {
            if (fuel.getFluid() != fluid) continue;
            return fuel;
        }
        return null;
    }

    private static final class BCFuel
    implements IFuel {
        private final Fluid fluid;
        private final int powerPerCycle;
        private final int totalBurningTime;

        public BCFuel(Fluid fluid, int powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getTotalBurningTime() {
            return this.totalBurningTime;
        }

        public int getPowerPerCycle() {
            return this.powerPerCycle;
        }
    }
}

