/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.api.IInfoType;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public abstract class InfoType
implements IInfoType {
    public ConfigMap configMap = new ConfigMap();
    public static List<InfoType> infoTypes = new ArrayList<InfoType>();
    public boolean isValid = true;
    public Item item;
    public int colour = 0xFFFFFF;
    public String iconPath;
    public Object[] recipe;
    public String[] recipeLine;
    public int recipeOutput = 1;
    public boolean shapeless;
    public String smeltableFrom = null;
    public String name;
    public String shortName;
    public String texture;
    public String modelString;
    public String description;
    public float modelScale = 1.0f;
    public boolean canDrop = true;
    public final String packName;

    public InfoType(TypeFile file) {
        this.packName = file.pack;
        infoTypes.add(this);
        this.configMap.setIdentifiers(file.name, file.pack);
    }

    protected abstract void preRead(TypeFile var1);

    protected abstract void postRead(TypeFile var1);

    public void read(TypeFile file) {
        this.preRead(file);
        boolean readRecipe = false;
        int recipePart = 0;
        while (true) {
            String line = file.readLine();
            if (readRecipe && recipePart <= 2) {
                if (line != null) {
                    if (line.length() == 3) {
                        this.configMap.put("Recipe" + recipePart++, line);
                        continue;
                    }
                    if (line.length() == 2) {
                        this.configMap.put("Recipe" + recipePart++, line + " ");
                        continue;
                    }
                    if (line.length() != 1) continue;
                    this.configMap.put("Recipe" + recipePart++, line + "  ");
                    continue;
                }
                this.configMap.put("Recipe" + recipePart++, "   ");
                continue;
            }
            if (line == null) break;
            if (line.startsWith("//") || line.trim().isEmpty()) continue;
            if (line.startsWith("ShortName") && line.split(" ").length == 2) {
                this.shortName = line.split(" ")[1];
            }
            this.readLine(line.split(" "), file);
            if (!line.contains(" ")) {
                this.configMap.put(line.trim(), "");
                continue;
            }
            int firstSpace = line.indexOf(" ");
            String key = line.substring(0, firstSpace).trim();
            String data = line.substring(firstSpace).trim();
            this.configMap.put(key, data);
            if (!key.equalsIgnoreCase("Recipe")) continue;
            readRecipe = true;
        }
        this.shortName = ConfigUtils.configString(this.configMap, "ShortName", this.shortName);
        if (this.shortName == null) {
            infoTypes.remove(this);
            FlansMod.log("Config without shortname removed pack: %s, filename: %s", file.pack, file.name);
        } else {
            this.read(this.configMap, file);
            this.postRead(file);
            if (!this.isValid) {
                infoTypes.remove(this);
            }
        }
    }

    protected void readLine(String[] split, TypeFile file) {
    }

    protected void read(ConfigMap config, TypeFile file) {
        this.modelString = ConfigUtils.configString(this.configMap, "Model", null);
        this.modelScale = ConfigUtils.configFloat(this.configMap, "ModelScale", this.modelScale);
        this.name = ConfigUtils.configString(this.configMap, "Name", this.name);
        this.description = ConfigUtils.configString(this.configMap, "Description", this.description);
        String[] val = ConfigUtils.getSplitFromKey(this.configMap, new String[]{"Color", "Colour"});
        if (val != null) {
            this.colour = (Integer.parseInt(val[1]) << 16) + (Integer.parseInt(val[2]) << 8) + Integer.parseInt(val[3]);
        }
        this.iconPath = ConfigUtils.configString(this.configMap, "Icon", "Missing-Icon-" + this.shortName);
        if (this.iconPath.isEmpty()) {
            this.iconPath = "Missing-Icon-" + this.shortName;
        }
        this.recipeOutput = ConfigUtils.configInt(config, "RecipeOutput", this.recipeOutput);
        if (config.containsKey("Recipe")) {
            this.recipeLine = ConfigUtils.getSplitFromKey(config, "Recipe");
            this.recipe = new Object[this.recipeLine.length + 2];
            this.recipe[0] = ConfigUtils.configString(config, "recipe0", "");
            this.recipe[1] = ConfigUtils.configString(config, "recipe1", "");
            this.recipe[2] = ConfigUtils.configString(config, "recipe2", "");
        }
        if (config.containsKey("ShapelessRecipe")) {
            this.recipeLine = ConfigUtils.getSplitFromKey(config, "ShapelessRecipe");
            this.shapeless = true;
        }
        this.smeltableFrom = ConfigUtils.configString(this.configMap, "SmeltableFrom", this.smeltableFrom);
        this.canDrop = ConfigUtils.configBool(config, "CanDrop", this.canDrop);
    }

    public void addRecipe() {
        this.addRecipe(this.getItem());
    }

    public void addRecipe(Item par1Item) {
        block24: {
            if (this.smeltableFrom != null) {
                ItemStack recipeElement = InfoType.getRecipeElement(this.smeltableFrom, 0);
                if (recipeElement != null) {
                    GameRegistry.addSmelting((ItemStack)recipeElement, (ItemStack)new ItemStack(this.item), (float)0.0f);
                } else {
                    FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for SmeltableFrom", new String[]{this.smeltableFrom}, null);
                }
            }
            if (this.recipeLine == null) {
                return;
            }
            try {
                if (!this.shapeless) {
                    Object[] newRecipe1;
                    int last;
                    int rows = 3;
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                        if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(1);
                            }
                        }
                    }
                    if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                        }
                        if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                            }
                        }
                    }
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[1];
                        newRecipe[1] = this.recipe[2];
                        this.recipe = newRecipe;
                        --rows;
                        if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[1];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[0];
                        newRecipe[1] = this.recipe[1];
                        this.recipe = newRecipe;
                        if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[0];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                        this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                        ItemStack recipeElement = null;
                        recipeElement = this.recipeLine[i * 2 + 2].contains(".") ? InfoType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.parseInt(this.recipeLine[i * 2 + 2].split("\\.")[1])) : InfoType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                        if (recipeElement == null) {
                            FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for recipe", new String[]{this.recipeLine[i * 2 + 2]}, null);
                        }
                        this.recipe[i * 2 + rows + 1] = recipeElement;
                    }
                    GameRegistry.addRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
                } else {
                    this.recipe = new Object[this.recipeLine.length - 1];
                    for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                        ItemStack recipeElement = null;
                        recipeElement = this.recipeLine[i + 1].contains(".") ? InfoType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.parseInt(this.recipeLine[i + 1].split("\\.")[1])) : InfoType.getRecipeElement(this.recipeLine[i + 1], 0);
                        if (recipeElement == null) {
                            FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for recipe", new String[]{this.recipeLine[i + 1]}, null);
                        }
                        this.recipe[i] = recipeElement;
                    }
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
                }
            }
            catch (Exception e) {
                FlansMod.log("Failed to add recipe for : " + this.shortName);
                if (!FlansMod.printStackTrace) break block24;
                e.printStackTrace();
            }
        }
    }

    public static ItemStack getRecipeElement(String s, int damage) {
        return InfoType.getRecipeElement(s, 1, damage);
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage) {
        return InfoType.getRecipeElement(s, amount, damage, "nothing");
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage, String requester) {
        if (s.equals("doorIron")) {
            return new ItemStack(Items.field_151139_aw, amount);
        }
        if (s.equals("doorWood")) {
            return new ItemStack(Items.field_151135_aq, amount);
        }
        if (s.equals("clayItem")) {
            return new ItemStack(Items.field_151119_aD, amount);
        }
        for (Object object : Item.field_150901_e) {
            Item item = (Item)object;
            if (item == null || item.func_77658_a() == null || !item.func_77658_a().equals("item." + s) && !item.func_77658_a().equals("tile." + s)) continue;
            return new ItemStack(item, amount, damage);
        }
        for (InfoType type : infoTypes) {
            if (type.shortName == null || !type.shortName.equals(s)) continue;
            return new ItemStack(type.item, amount, damage);
        }
        if (s.equals("gunpowder")) {
            return new ItemStack(Items.field_151016_H, amount);
        }
        if (s.equals("iron")) {
            return new ItemStack(Items.field_151042_j, amount);
        }
        return null;
    }

    protected int getDyeDamageValue(String dyeName) {
        int damage = -1;
        for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
            if (!ItemDye.field_150923_a[i].equals(dyeName)) continue;
            damage = i;
        }
        return damage;
    }

    public void reloadModel() {
    }

    public static InfoType getType(String s) {
        for (InfoType type : infoTypes) {
            if (type == null || type.shortName == null) {
                FlansMod.log("This is a bad thing that shouldn't happen. Please report this issue.");
                continue;
            }
            if (!type.shortName.equals(s)) continue;
            return type;
        }
        return null;
    }

    public void onWorldLoad(World world) {
    }

    public abstract float GetRecommendedScale();

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBase GetModel();

    public static InfoType getType(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFlanItem) {
            return ((IFlanItem)item).getInfoType();
        }
        return null;
    }

    public static PotionEffect getPotionEffect(String[] split) {
        int potionID = Integer.parseInt(split[1]);
        int duration = Integer.parseInt(split[2]);
        int amplifier = Integer.parseInt(split[3]);
        return new PotionEffect(potionID, duration, amplifier, false);
    }

    public static Material getMaterial(String material) {
        return Material.field_151578_c;
    }

    @Override
    public String getContentPack() {
        return this.packName;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

