/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.tools;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ToolType
extends InfoType {
    public static HashMap<String, ToolType> tools = new HashMap();
    @SideOnly(value=Side.CLIENT)
    public ModelBase model;
    public boolean healPlayers = false;
    public boolean healDriveables = false;
    public int healAmount = 0;
    public int toolLife = 0;
    public boolean destroyOnEmpty = true;
    public ArrayList<ItemStack> rechargeRecipe = new ArrayList();
    public int EUPerCharge = 0;
    public boolean parachute = false;
    public boolean remote = false;
    public int foodness = 0;
    public boolean key = false;

    public ToolType(TypeFile file) {
        super(file);
    }

    @Override
    protected void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            tools.put(this.shortName, this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            String modelName = ConfigUtils.configString(config, "Model", null);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(modelName, this.shortName, ModelBase.class);
            }
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.parachute = ConfigUtils.configBool(config, "Parachute", this.parachute);
            this.remote = ConfigUtils.configBool(config, "ExplosiveRemote", this.remote);
            this.key = ConfigUtils.configBool(config, "Key", this.key);
            this.healPlayers = ConfigUtils.configBool(config, new String[]{"Heal", "HealPlayers"}, this.healPlayers);
            this.healDriveables = ConfigUtils.configBool(config, new String[]{"Repair", "RepairVehicles"}, this.healDriveables);
            this.healAmount = ConfigUtils.configInt(config, new String[]{"HealAmount", "RepairAmount"}, this.toolLife);
            this.toolLife = ConfigUtils.configInt(config, new String[]{"ToolLife", "ToolUes"}, this.toolLife);
            this.EUPerCharge = ConfigUtils.configInt(config, "EUPerCharge", this.EUPerCharge);
            String[] split = ConfigUtils.getSplitFromKey(config, "RechargeRecipe");
            try {
                if (split != null) {
                    for (int i = 0; i < (split.length - 1) / 2; ++i) {
                        int damage;
                        int amount = Integer.parseInt(split[2 * i + 1]);
                        boolean damaged = split[2 * i + 2].contains(".");
                        String itemName = damaged ? split[2 * i + 2].split("\\.")[0] : split[2 * i + 2];
                        ItemStack recipeElement = ToolType.getRecipeElement(itemName, amount, damage = damaged ? Integer.parseInt(split[2 * i + 2].split("\\.")[1]) : 0, this.shortName);
                        if (recipeElement != null) {
                            this.rechargeRecipe.add(recipeElement);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find item for RechargeRecipe", split, null);
                    }
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't add recharge recipe", split, ex);
            }
            this.destroyOnEmpty = ConfigUtils.configBool(config, "DestroyOnEmpty", this.destroyOnEmpty);
            this.foodness = ConfigUtils.configInt(config, new String[]{"Food", "Foodness"}, this.foodness);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading tool file", null, ex);
            this.isValid = false;
        }
    }

    @Override
    public void addRecipe(Item item) {
        super.addRecipe(item);
        if (this.rechargeRecipe.size() < 1) {
            return;
        }
        this.rechargeRecipe.add(new ItemStack(item, 1, this.toolLife));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(item, 1, 0), (Object[])this.rechargeRecipe.toArray());
    }

    public static ToolType getType(String shortName) {
        return tools.get(shortName);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public float GetRecommendedScale() {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }
}

