/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TeamsMap {
    public static List<TeamsMap> mapList = new ArrayList<TeamsMap>();
    public String shortName;
    public String name;
    public ForgeChunkManager.Ticket chunkLoadingTicket;
    public ArrayList<ITeamBase> bases = new ArrayList();
    public int minPlayers = 0;
    public int maxPlayers = 1000000;

    public TeamsMap(World world, String sn, String n) {
        this.shortName = sn;
        this.name = n;
        this.chunkLoadingTicket = ForgeChunkManager.requestTicket((Object)FlansMod.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.chunkLoadingTicket == null) {
            FlansMod.log("Failed to add chunk loading ticket as Flan's Mod has run out");
            return;
        }
        this.chunkLoadingTicket.getModData().func_74778_a("ShortName", this.shortName);
    }

    public ArrayList<ITeamBase> getBasesPerTeam(int teamID) {
        ArrayList<ITeamBase> basesForThisTeam = new ArrayList<ITeamBase>();
        for (ITeamBase base : this.bases) {
            if (base.getOwnerID() != teamID) continue;
            basesForThisTeam.add(base);
        }
        return basesForThisTeam;
    }

    public void addBase(ITeamBase base) {
        this.bases.add(base);
    }

    public void addBaseFirstTime(ITeamBase base) {
        this.addBase(base);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadingTicket, (ChunkCoordIntPair)new ChunkCoordIntPair((int)base.getPosX() >> 4, (int)base.getPosZ() >> 4));
        FlansMod.log("Added chunk at " + ((int)base.getPosX() >> 4) + ",  " + ((int)base.getPosZ() >> 4) + " to chunk loading ticket for base " + this.name);
    }

    public void removeBase(ITeamBase base) {
        if (this.bases == null) {
            FlansMod.log("Base array for map " + this.name + " null");
            return;
        }
        this.bases.remove(base);
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadingTicket, (ChunkCoordIntPair)new ChunkCoordIntPair((int)base.getPosX() >> 4, (int)base.getPosZ() >> 4));
        FlansMod.log("Removed chunk at " + ((int)base.getPosX() >> 4) + ",  " + ((int)base.getPosZ() >> 4) + " from chunk loading ticket for base " + this.name);
    }

    public void addObject(ITeamObject object) {
    }

    public void addObjectFirstTime(ITeamObject object) {
        if (object.forceChunkLoading()) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadingTicket, (ChunkCoordIntPair)new ChunkCoordIntPair((int)object.getPosX() >> 4, (int)object.getPosZ() >> 4));
        }
    }

    public TeamsMap(World world, NBTTagCompound tags) {
        this.shortName = tags.func_74779_i("ShortName");
        this.name = tags.func_74779_i("Name");
        this.minPlayers = tags.func_74762_e("MinPlayers");
        this.maxPlayers = tags.func_74762_e("MaxPlayers");
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74778_a("ShortName", this.shortName);
        tags.func_74778_a("Name", this.name);
        tags.func_74768_a("MinPlayers", this.minPlayers);
        tags.func_74768_a("MaxPlayers", this.maxPlayers);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        for (ChunkCoordIntPair coord : ticket.getChunkList()) {
            FlansMod.log("Loading chunk at " + coord.field_77276_a + ", " + coord.field_77275_b + " for map : " + this.name);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
    }

    public void deleteMap() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkLoadingTicket);
    }
}

