/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ComparatorExp;
import com.flansmod.common.teams.TeamsManager;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PlayerStats {
    public static final File STATS_DIR = new File(MinecraftServer.func_71276_C().func_130014_f_().func_72860_G().func_75765_b() + "\\FlansMod players statistics\\");
    public String nickname = "NaN";
    public int kills = 0;
    public int deaths = 0;
    public int exp = 0;
    public int totalExp = 0;
    public int rank = 1;
    public double avg = 0.0;
    public double longestKill = 0.0;
    public int playedRounds = 0;
    public double playTime = 0.0;
    public int MVPCount = 0;
    public int capturedFlags = 0;
    public int savedFlags = 0;
    public int vehiclesDestroyed = 0;

    public PlayerStats(EntityPlayerMP player) {
        this.nickname = player.func_70005_c_();
        this.savePlayerStats();
    }

    private PlayerStats() {
    }

    public EntityPlayerMP getPlayer(String username) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
    }

    public void savePlayerStats() {
        STATS_DIR.mkdirs();
        STATS_DIR.setReadable(true);
        STATS_DIR.setWritable(true);
        File file = new File(STATS_DIR, this.nickname + " " + this.getPlayer(this.nickname).func_110124_au().toString() + ".dat");
        STATS_DIR.mkdirs();
        STATS_DIR.setReadable(true);
        STATS_DIR.setWritable(true);
        TeamsManager.checkFileExists(file);
        try {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("Nickname", this.nickname);
            tags.func_74768_a("Kills", this.kills);
            tags.func_74768_a("Deaths", this.deaths);
            tags.func_74768_a("Exp", this.exp);
            tags.func_74768_a("Total Exp", this.totalExp);
            tags.func_74768_a("Rank", this.rank);
            tags.func_74780_a("AVG", this.avg);
            tags.func_74780_a("Longest Kill", this.longestKill);
            tags.func_74768_a("Rounds Played", this.playedRounds);
            tags.func_74780_a("Play Time", this.playTime);
            tags.func_74768_a("MVP Count", this.MVPCount);
            tags.func_74768_a("Flags Captured", this.capturedFlags);
            tags.func_74768_a("Flags Saved", this.savedFlags);
            tags.func_74768_a("Vehicles Destroyed", this.vehiclesDestroyed);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)new DataOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));
        }
        catch (Exception e) {
            FlansMod.log("Failed to save to teams.dat");
            FlansMod.logger.error((Object)e);
        }
    }

    public void addExp(float a) {
        this.exp = (int)((float)this.exp + a);
        this.totalExp = (int)((float)this.totalExp + a);
        if (this.exp >= 1000) {
            ++this.rank;
            this.exp -= 1000;
        }
    }

    public void updateLongestKill(float distance) {
        this.addExp(distance / 10.0f);
        if ((double)distance > this.longestKill) {
            this.longestKill = distance;
        }
    }

    public void updateAVG() {
        this.avg = (double)this.kills / (double)this.playedRounds;
    }

    public static PlayerStats getPlayerStatsFromFile(String name) {
        PlayerStats toSend = new PlayerStats();
        for (File file : STATS_DIR.listFiles()) {
            if (!file.getName().startsWith(name)) continue;
            TeamsManager.checkFileExists(file);
            try {
                NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
                toSend.nickname = tags.func_74779_i("Nickname");
                toSend.kills = tags.func_74762_e("Kills");
                toSend.deaths = tags.func_74762_e("Deaths");
                toSend.exp = tags.func_74762_e("Exp");
                toSend.totalExp = tags.func_74762_e("Total Exp");
                toSend.rank = tags.func_74762_e("Rank");
                toSend.avg = tags.func_74769_h("AVG");
                toSend.longestKill = tags.func_74769_h("Longest Kill");
                toSend.playedRounds = tags.func_74762_e("Rounds Played");
                toSend.playTime = tags.func_74769_h("Play Time");
                toSend.MVPCount = tags.func_74762_e("MVP Count");
                toSend.capturedFlags = tags.func_74762_e("Flags Captured");
                toSend.savedFlags = tags.func_74762_e("Flags Saved");
                toSend.vehiclesDestroyed = tags.func_74762_e("Vehicles Destroyed");
                return toSend;
            }
            catch (Exception e) {
                FlansMod.log("Failed to save to teams.dat");
                FlansMod.logger.error((Object)e);
                return null;
            }
        }
        return null;
    }

    public static void printLeaderboardExp(ICommandSender sender) {
        ArrayList<String> nameList = new ArrayList<String>();
        File dir = new File(MinecraftServer.func_71276_C().func_130014_f_().func_72860_G().func_75765_b() + "\\FlansMod players statistics\\");
        for (File file : dir.listFiles()) {
            TeamsManager.checkFileExists(file);
            try {
                NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
                String nickname = tags.func_74779_i("Nickname");
                nameList.add(nickname);
            }
            catch (Exception e) {
                FlansMod.log("Failed to print leaderboard");
                FlansMod.logger.error((Object)e);
            }
        }
        Collections.sort(nameList, new ComparatorExp());
        int counter = 0;
        for (String name : nameList) {
            PlayerStats stats = PlayerStats.getPlayerStatsFromFile(name);
            if (stats == null) continue;
            switch (counter) {
                case 0: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76\u00a7l1. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 1: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a74\u00a7l2. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 2: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a\u00a7l3. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 3: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l4. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 4: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l5. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 5: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l6. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 6: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l7. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 7: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l8. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 8: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l9. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 9: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7l10. " + name + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                    break;
                }
                case 10: {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7b\u00a7l" + nameList.indexOf(sender.func_70005_c_()) + 1 + ". " + sender.func_70005_c_() + " - Rank " + stats.rank + "(" + stats.totalExp + " Exp)"));
                }
            }
            if (++counter < 11) continue;
            break;
        }
    }

    public static List<PlayerStats> getAllPlayersStats() {
        ArrayList<PlayerStats> listToSend = new ArrayList<PlayerStats>();
        if (STATS_DIR.listFiles() == null) {
            return null;
        }
        for (File file : STATS_DIR.listFiles()) {
            TeamsManager.checkFileExists(file);
            try {
                PlayerStats toSend = new PlayerStats();
                NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
                toSend.nickname = tags.func_74779_i("Nickname");
                toSend.kills = tags.func_74762_e("Kills");
                toSend.deaths = tags.func_74762_e("Deaths");
                toSend.exp = tags.func_74762_e("Exp");
                toSend.totalExp = tags.func_74762_e("Total Exp");
                toSend.rank = tags.func_74762_e("Rank");
                toSend.avg = tags.func_74769_h("AVG");
                toSend.longestKill = tags.func_74769_h("Longest Kill");
                toSend.playedRounds = tags.func_74762_e("Rounds Played");
                toSend.playTime = tags.func_74769_h("Play Time");
                toSend.MVPCount = tags.func_74762_e("MVP Count");
                toSend.capturedFlags = tags.func_74762_e("Flags Captured");
                toSend.savedFlags = tags.func_74762_e("Flags Saved");
                toSend.vehiclesDestroyed = tags.func_74762_e("Vehicles Destroyed");
                listToSend.add(toSend);
            }
            catch (Exception e) {
                FlansMod.logException("Failed to save to teams.dat", e);
                return null;
            }
        }
        return listToSend;
    }

    public static int getPlayerLvl(EntityPlayerMP player) {
        PlayerStats stats = PlayerStats.getPlayerStatsFromFile(player.func_70005_c_());
        if (stats != null) {
            return stats.totalExp / 1000;
        }
        stats = new PlayerStats(player);
        return stats.totalExp / 1000;
    }
}

