/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.parts;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;

public class PartType
extends InfoType {
    public int category = 0;
    public int stackSize = 0;
    public float engineSpeed = 1.0f;
    public float fuelConsumption = 1.0f;
    public float enginePower = 10.0f;
    public int fuel = 0;
    public List<EnumType> worksWith = Arrays.asList(EnumType.mecha, EnumType.plane, EnumType.vehicle);
    public ArrayList<ItemStack> partBoxRecipe = new ArrayList();
    public boolean useRFPower = false;
    public int RFDrawRate = 1;
    public static HashMap<EnumType, PartType> defaultEngines = new HashMap();
    public static List<PartType> parts = new ArrayList<PartType>();

    public PartType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        if (this.category == 2 && !this.useRFPower && this.isValid) {
            for (EnumType type : this.worksWith) {
                if (defaultEngines.containsKey((Object)type)) {
                    PartType possiblyInferiorEngine = defaultEngines.get((Object)type);
                    if (!this.isInferiorEngine(possiblyInferiorEngine)) continue;
                    defaultEngines.put(type, this);
                    continue;
                }
                defaultEngines.put(type, this);
            }
        }
        if (this.shortName != null && this.isValid) {
            parts.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            int i;
            this.category = this.getCategory(ConfigUtils.configString(config, "Category", "Cockpit"));
            this.stackSize = ConfigUtils.configInt(config, "StackSize", this.stackSize);
            this.fuelConsumption = ConfigUtils.configFloat(config, "FuelConsumption", this.engineSpeed);
            this.engineSpeed = ConfigUtils.configFloat(config, "EngineSpeed", this.engineSpeed);
            this.enginePower = ConfigUtils.configFloat(config, "EnginePower", this.enginePower);
            this.useRFPower = ConfigUtils.configBool(config, new String[]{"UseRF", "UseRFPower"}, this.useRFPower);
            this.RFDrawRate = ConfigUtils.configInt(config, "RFDrawRate", this.RFDrawRate);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"WorksWith"});
            try {
                if (splits.size() > 0) {
                    this.worksWith = new ArrayList<EnumType>();
                }
                for (String[] split : splits) {
                    for (i = 1; i < split.length; ++i) {
                        EnumType type = EnumType.get(split[i]);
                        if (type == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "type not found for part WorksWith", split, null);
                            continue;
                        }
                        this.worksWith.add(type);
                    }
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown wile processing WorksWith", null, ex);
            }
            this.fuel = ConfigUtils.configInt(config, "Fuel", this.fuel);
            String[] split = ConfigUtils.getSplitFromKey(config, "PartBoxRecipe");
            try {
                if (split != null) {
                    ItemStack[] stacks = new ItemStack[(split.length - 2) / 2];
                    for (i = 0; i < (split.length - 2) / 2; ++i) {
                        int damage;
                        int amount = Integer.parseInt(split[2 * i + 2]);
                        boolean damaged = split[2 * i + 3].contains(".");
                        String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                        ItemStack recipeElement = PartType.getRecipeElement(itemName, amount, damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0, this.shortName);
                        if (recipeElement == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find item for PartBoxRecipe", split, null);
                        }
                        stacks[i] = recipeElement;
                    }
                    this.partBoxRecipe.addAll(Arrays.asList(stacks));
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while constructing PartBoxRecipe for part", split, ex);
            }
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error thrown while reading part", null, ex);
            this.isValid = false;
        }
    }

    public boolean isInferiorEngine(PartType quitePossiblyAnInferiorEngine) {
        return this.engineSpeed > quitePossiblyAnInferiorEngine.engineSpeed;
    }

    public static PartType getPart(String s) {
        for (PartType part : parts) {
            if (!part.shortName.equals(s)) continue;
            return part;
        }
        return null;
    }

    private int getCategory(String s) {
        switch (s) {
            case "Cockpit": {
                return 0;
            }
            case "Wing": {
                return 1;
            }
            case "Engine": {
                return 2;
            }
            case "Propeller": {
                return 3;
            }
            case "Bay": {
                return 4;
            }
            case "Tail": {
                return 5;
            }
            case "Wheel": {
                return 6;
            }
            case "Chassis": {
                return 7;
            }
            case "Turret": {
                return 8;
            }
            case "Fuel": {
                return 9;
            }
        }
        return 10;
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }
}

