/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class PacketSetPreferredAmmo
extends PacketBase {
    public String ammoName;

    public PacketSetPreferredAmmo() {
    }

    public PacketSetPreferredAmmo(String ammoName) {
        this.ammoName = ammoName;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.writeUTF(data, this.ammoName);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.ammoName = this.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        ItemStack currentItem = playerEntity.field_71071_by.func_70448_g();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemGun) {
            ItemGun itemGun = (ItemGun)currentItem.func_77973_b();
            ShootableType newPreferredAmmo = ShootableType.getShootableType(this.ammoName);
            playerEntity.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + newPreferredAmmo.name + " is new preferred ammo for " + itemGun.type.name));
            itemGun.setPreferredAmmoStack(currentItem, this.ammoName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log("Received set preferred ammo packet on client. Skipping.");
    }
}

