/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class PacketReload
extends PacketBase {
    public boolean left;
    public Integer amount = 0;
    public Integer reloadTime = 0;
    public Boolean singlesReload = false;
    public boolean combineAmmo;
    public boolean ammoToUpperInventory;

    public PacketReload() {
    }

    public PacketReload(boolean l, boolean combineAmmo, boolean ammoToUpperInventory) {
        this.left = l;
        this.combineAmmo = combineAmmo;
        this.ammoToUpperInventory = ammoToUpperInventory;
    }

    public PacketReload(boolean l, int count, int reload, boolean single, boolean combineAmmo, boolean ammoToUpperInventory) {
        this.left = l;
        this.amount = count;
        this.reloadTime = reload;
        this.singlesReload = single;
        this.combineAmmo = combineAmmo;
        this.ammoToUpperInventory = ammoToUpperInventory;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(this.left);
        data.writeInt(this.amount.intValue());
        data.writeInt(this.reloadTime.intValue());
        data.writeBoolean(this.singlesReload.booleanValue());
        data.writeBoolean(this.combineAmmo);
        data.writeBoolean(this.ammoToUpperInventory);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.left = data.readBoolean();
        this.amount = data.readInt();
        this.reloadTime = data.readInt();
        this.singlesReload = data.readBoolean();
        this.combineAmmo = data.readBoolean();
        this.ammoToUpperInventory = data.readBoolean();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)playerEntity);
        ItemStack gunStack = playerEntity.func_71045_bC();
        if (this.left && data.offHandGunSlot != 0) {
            gunStack = playerEntity.field_71071_by.func_70301_a(data.offHandGunSlot - 1);
        }
        if (data != null && gunStack != null && gunStack.func_77973_b() instanceof ItemGun) {
            float reloadTime;
            int reloadCount;
            int maxAmmo;
            boolean singlesReload;
            GunType type = ((ItemGun)gunStack.func_77973_b()).type;
            boolean empty = true;
            for (int i = 0; i < type.getNumAmmoItemsInGun(gunStack); ++i) {
                ItemStack bulletStack = ((ItemGun)gunStack.func_77973_b()).getBulletItemStack(gunStack, i);
                if (bulletStack == null || bulletStack.func_77973_b() == null || bulletStack.func_77960_j() >= bulletStack.func_77958_k()) continue;
                empty = false;
                break;
            }
            boolean bl = singlesReload = (maxAmmo = type.getNumAmmoItemsInGun(gunStack)) > 1;
            if (singlesReload) {
                reloadCount = 0;
                for (int i = 0; i < type.getNumAmmoItemsInGun(gunStack); ++i) {
                    ItemStack oldBulletStack = ((ItemGun)gunStack.func_77973_b()).getBulletItemStack(gunStack, i);
                    if (oldBulletStack != null && oldBulletStack.func_77958_k() - oldBulletStack.func_77960_j() == 0) {
                        ++reloadCount;
                        continue;
                    }
                    if (oldBulletStack != null) continue;
                    ++reloadCount;
                }
            } else {
                reloadCount = 1;
            }
            float f = reloadTime = singlesReload ? type.getReloadTime(gunStack) / (float)maxAmmo * (float)reloadCount : type.getReloadTime(gunStack);
            if (!data.reloadedAfterRespawn && TeamsManager.getInstance().currentMap != null) {
                reloadTime = 0.0f;
            }
            if (((ItemGun)gunStack.func_77973_b()).reload(gunStack, type, playerEntity.field_70170_p, (EntityPlayer)playerEntity, true, this.left, this.combineAmmo, this.ammoToUpperInventory, reloadTime, FlansMod.cancelReloadOnWeaponSwitch)) {
                if (!data.reloadedAfterRespawn && TeamsManager.getInstance().currentMap != null) {
                    data.reloadedAfterRespawn = true;
                }
                data.shootTimeRight += reloadTime;
                data.shootTimeLeft += reloadTime;
                if (this.left) {
                    data.reloadingLeft = true;
                } else {
                    data.reloadingRight = true;
                }
                FlansMod.getPacketHandler().sendTo(new PacketReload(this.left, reloadCount, (int)reloadTime, singlesReload, this.combineAmmo, this.ammoToUpperInventory), playerEntity);
                String soundToPlay = null;
                AttachmentType grip = type.getGrip(gunStack);
                if (type.getSecondaryFire(gunStack) && grip != null && grip.secondaryReloadSound != null) {
                    soundToPlay = grip.secondaryReloadSound;
                } else if (empty && type.reloadSoundOnEmpty != null) {
                    soundToPlay = type.reloadSoundOnEmpty;
                } else if (type.reloadSound != null) {
                    soundToPlay = type.reloadSound;
                }
                if (soundToPlay != null && reloadTime > 0.0f) {
                    PacketPlaySound.sendSoundPacket(playerEntity.field_70165_t, playerEntity.field_70163_u, playerEntity.field_70161_v, type.reloadSoundRange, playerEntity.field_71093_bK, soundToPlay, true, false, playerEntity.func_70005_c_());
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        ItemStack stack = clientPlayer.func_71045_bC();
        PlayerData data = PlayerHandler.getPlayerData(clientPlayer, Side.CLIENT);
        if (this.left) {
            stack = clientPlayer.field_71071_by.func_70301_a(data.offHandGunSlot - 1);
            data.burstRoundsRemainingLeft = 0;
        } else {
            data.burstRoundsRemainingRight = 0;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemGun) {
            GunType type = ((ItemGun)stack.func_77973_b()).type;
            if (this.left) {
                FlansModClient.shootTimeLeft += (float)this.reloadTime.intValue();
            } else {
                FlansModClient.shootTimeRight += (float)this.reloadTime.intValue();
            }
            GunAnimations animations = null;
            if (this.left) {
                if (FlansModClient.gunAnimationsLeft.containsKey(clientPlayer)) {
                    animations = (GunAnimations)FlansModClient.gunAnimationsLeft.get(clientPlayer);
                } else {
                    animations = new GunAnimations();
                    FlansModClient.gunAnimationsLeft.put(clientPlayer, animations);
                }
            } else if (FlansModClient.gunAnimationsRight.containsKey(clientPlayer)) {
                animations = (GunAnimations)FlansModClient.gunAnimationsRight.get(clientPlayer);
            } else {
                animations = new GunAnimations();
                FlansModClient.gunAnimationsRight.put(clientPlayer, animations);
            }
            int pumpDelay = type.model == null ? 0 : type.model.pumpDelayAfterReload;
            int pumpTime = type.model == null ? 1 : type.model.pumpTime;
            int chargeDelay = type.model == null ? 0 : type.model.chargeDelayAfterReload;
            int chargeTime = type.model == null ? 1 : type.model.chargeTime;
            PlayerData playerData = PlayerHandler.getPlayerData(clientPlayer, Side.CLIENT);
            playerData.gunToReload = stack;
            playerData.reloadSlot = clientPlayer.field_71071_by.field_70461_c;
            animations.doReload(this.reloadTime, pumpDelay, pumpTime, chargeDelay, chargeTime, this.amount, this.singlesReload);
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < clientPlayer.field_71071_by.func_70302_i_(); ++j) {
                int bulletsInThisSlot;
                ItemStack item = clientPlayer.field_71071_by.func_70301_a(j);
                if (item == null || !(item.func_77973_b() instanceof ItemShootable) || !type.isAmmo(((ItemShootable)item.func_77973_b()).type, stack) || (bulletsInThisSlot = item.func_77958_k() - item.func_77960_j()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
        }
    }
}

