/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.TickHandlerClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.types.InfoType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketKillMessage
extends PacketBase {
    public InfoType killedBy;
    public int itemDamage;
    public String killerName;
    public String killedName;
    public boolean headshot;
    public float distance;

    public PacketKillMessage() {
    }

    public PacketKillMessage(boolean head, InfoType weapon, int itmDmg, String victim, String murderer, Float dist) {
        this.killedBy = weapon;
        this.itemDamage = itmDmg;
        this.killerName = murderer;
        this.killedName = victim;
        this.headshot = head;
        this.distance = dist.floatValue();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(this.headshot);
        this.writeUTF(data, this.killedBy.shortName);
        data.writeInt(this.itemDamage);
        this.writeUTF(data, this.killerName);
        this.writeUTF(data, this.killedName);
        data.writeFloat(this.distance);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.headshot = data.readBoolean();
        this.killedBy = InfoType.getType(this.readUTF(data));
        this.itemDamage = data.readInt();
        this.killerName = this.readUTF(data);
        this.killedName = this.readUTF(data);
        this.distance = data.readFloat();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log("Player kill Killer: " + this.killerName + " Killed " + this.killedName + " using: " + this.killedBy.shortName + " Headshot: " + this.headshot);
        FlansMod.log("Distance " + this.distance);
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        TickHandlerClient.addKillMessage(this.headshot, this.killedBy, this.itemDamage, this.killerName, this.killedName);
    }
}

