/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.raytracing;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class PlayerHitbox {
    public EntityPlayer player;
    public RotatedAxes axes;
    public Vector3f rP;
    public Vector3f o;
    public Vector3f d;
    public Vector3f vel;
    public EnumHitboxType type;

    public PlayerHitbox(EntityPlayer player, RotatedAxes axes, Vector3f rotationPoint, Vector3f origin, Vector3f dimensions, Vector3f velocity, EnumHitboxType type) {
        this.player = player;
        this.axes = axes;
        this.o = origin;
        this.d = dimensions;
        this.type = type;
        this.vel = velocity;
        this.rP = rotationPoint;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHitbox(World world, Vector3f pos) {
    }

    public PlayerBulletHit raytrace(Vector3f origin, Vector3f motion) {
        float intersectX;
        float intersectZ;
        float intersectTime;
        origin = Vector3f.sub(origin, this.rP, null);
        origin = this.axes.findGlobalVectorLocally(origin);
        motion = this.axes.findGlobalVectorLocally(Vector3f.sub(motion, this.vel, null));
        if (motion.x != 0.0f) {
            float intersectY;
            if (origin.x < this.o.x) {
                intersectTime = (this.o.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.o.y && intersectY <= this.o.y + this.d.y && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.x > this.o.x + this.d.x) {
                intersectTime = (this.o.x + this.d.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.o.y && intersectY <= this.o.y + this.d.y && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            }
        }
        if (motion.z != 0.0f) {
            float intersectY;
            if (origin.z < this.o.z) {
                intersectTime = (this.o.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectY >= this.o.y && intersectY <= this.o.y + this.d.y) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.z > this.o.z + this.d.z) {
                intersectTime = (this.o.z + this.d.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectY >= this.o.y && intersectY <= this.o.y + this.d.y) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            }
        }
        if (motion.y != 0.0f) {
            if (origin.y < this.o.y) {
                intersectTime = (this.o.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.y > this.o.y + this.d.y) {
                intersectTime = (this.o.y + this.d.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new PlayerBulletHit(this, intersectTime);
                }
            }
        }
        return null;
    }

    public float hitByBullet(EntityBullet bullet, float penetratingPower) {
        if (bullet.type.setEntitiesOnFire) {
            this.player.func_70015_d(20);
        }
        for (PotionEffect effect : bullet.type.hitEffects) {
            this.player.func_70690_d(new PotionEffect(effect));
        }
        float headPenRes = this.player.func_82169_q(3) == null || !(this.player.func_82169_q(3).func_77973_b() instanceof ItemTeamArmour) ? 1.0f : ((ItemTeamArmour)this.player.func_82169_q((int)3).func_77973_b()).type.penetrationResistance;
        float chestPenRes = this.player.func_82169_q(2) == null || !(this.player.func_82169_q(2).func_77973_b() instanceof ItemTeamArmour) ? 1.0f : ((ItemTeamArmour)this.player.func_82169_q((int)2).func_77973_b()).type.penetrationResistance;
        float legsPenRes = this.player.func_82169_q(1) == null || !(this.player.func_82169_q(1).func_77973_b() instanceof ItemTeamArmour) ? 0.65f : ((ItemTeamArmour)this.player.func_82169_q((int)1).func_77973_b()).type.penetrationResistance;
        float feetPenRes = this.player.func_82169_q(0) == null || !(this.player.func_82169_q(0).func_77973_b() instanceof ItemTeamArmour) ? 0.35f : ((ItemTeamArmour)this.player.func_82169_q((int)0).func_77973_b()).type.penetrationResistance;
        float totalPenetrationResistance = 0.0f;
        totalPenetrationResistance = this.type == EnumHitboxType.HEAD ? headPenRes : (this.type == EnumHitboxType.LEGS ? legsPenRes + feetPenRes : chestPenRes);
        float damageModifier = 1.0f;
        if (penetratingPower <= 0.7f * totalPenetrationResistance && FlansMod.useNewPenetrationSystem) {
            damageModifier = (float)Math.pow(penetratingPower / (0.7f * totalPenetrationResistance), 2.5);
        } else if (!FlansMod.useNewPenetrationSystem) {
            damageModifier = bullet.type.penetratingPower < 0.1f ? penetratingPower / bullet.type.penetratingPower : 1.0f;
        }
        bullet.lastHitPenAmount = Math.max(bullet.lastHitPenAmount, damageModifier);
        if (this.type == EnumHitboxType.HEAD) {
            damageModifier *= FlansMod.masterHeadshotModifier;
            bullet.lastHitHeadshot = true;
        } else if (this.type == EnumHitboxType.LEGS) {
            damageModifier *= FlansMod.masterLegModifier;
        }
        switch (this.type) {
            case LEGS: 
            case BODY: 
            case HEAD: 
            case LEFTARM: 
            case RIGHTARM: {
                DamageSource damagesource;
                float hitDamage = bullet.getDamageAffectedByPenetration() * bullet.type.damageVsPlayer * damageModifier;
                DamageSource damageSource = bullet.owner == null ? DamageSource.field_76377_j : (damagesource = bullet.getBulletDamage(this.type == EnumHitboxType.HEAD));
                if (!this.player.field_70170_p.field_72995_K && hitDamage == 0.0f && TeamsManager.getInstance().currentRound != null) {
                    TeamsManager.getInstance().currentRound.gametype.playerAttacked((EntityPlayerMP)this.player, damagesource);
                }
                Vector3f motBefore = new Vector3f(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
                if (this.player.func_70097_a(damagesource, hitDamage)) {
                    ++this.player.field_70720_be;
                    this.player.field_70172_ad = this.player.field_70771_an / 2;
                }
                Vector3f motAfter = new Vector3f(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y);
                Vector3f deltav = new Vector3f();
                Vector3f.sub(motAfter, motBefore, deltav);
                deltav.scale(1.0f - bullet.type.knockbackModifier);
                if (bullet.type.knockbackModifier > 2.0f) {
                    deltav.y = (float)Math.sqrt(deltav.y);
                }
                this.player.field_70159_w -= (double)deltav.x;
                this.player.field_70181_x -= (double)deltav.y;
                this.player.field_70179_y -= (double)deltav.z;
                if (FlansMod.useNewPenetrationSystem) {
                    return penetratingPower - totalPenetrationResistance;
                }
                return penetratingPower - 1.0f;
            }
            case RIGHTITEM: {
                ItemStack currentStack = this.player.func_71045_bC();
                if (currentStack != null && currentStack.func_77973_b() instanceof ItemGun) {
                    GunType gunType = ((ItemGun)currentStack.func_77973_b()).type;
                    return penetratingPower - gunType.shieldDamageAbsorption;
                }
                return penetratingPower;
            }
            case LEFTITEM: {
                PlayerData data = PlayerHandler.getPlayerData(this.player);
                if (data.offHandGunSlot == 0) break;
                ItemStack leftHandStack = null;
                leftHandStack = this.player.field_70170_p.field_72995_K && !FlansMod.proxy.isThePlayer(this.player) ? data.offHandGunStack : this.player.field_71071_by.func_70301_a(data.offHandGunSlot - 1);
                if (leftHandStack == null || !(leftHandStack.func_77973_b() instanceof ItemGun)) break;
                GunType leftGunType = ((ItemGun)leftHandStack.func_77973_b()).type;
                return penetratingPower - leftGunType.shieldDamageAbsorption;
            }
        }
        return penetratingPower;
    }
}

