/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;

public abstract class ShootableType
extends InfoType {
    public ModelBase model;
    public boolean trailParticles = false;
    public String trailParticleType = "smoke";
    public boolean hasLight = false;
    public boolean hasDynamicLight = false;
    public int maxStackSize = 1;
    public String dropItemOnReload = null;
    public String dropItemOnShoot = null;
    public String dropItemOnHit = null;
    public int roundsPerItem = 1;
    public float fallSpeed = 1.0f;
    public float throwSpeed = 1.0f;
    public float hitBoxSize = 0.5f;
    public float bounciness = 0.9f;
    public float damageVsPlayer = 1.0f;
    public float damageVsEntity = 1.0f;
    public float damageVsLiving = 1.0f;
    public float damageVsVehicles = 1.0f;
    public float damageVsPlanes = 1.0f;
    public boolean readDamageVsPlayer = false;
    public boolean readDamageVsEntity = false;
    public boolean readDamageVsPlanes = false;
    public boolean breaksGlass = false;
    public float ignoreArmorProbability = 0.0f;
    public float ignoreArmorDamageFactor = 0.0f;
    private float blockPenetrationModifier = -1.0f;
    public int fuse = 0;
    public int despawnTime = 0;
    public boolean explodeOnImpact = false;
    public float fireRadius = 0.0f;
    public float explosionRadius = 0.0f;
    public float explosionPower = 1.0f;
    public boolean explosionBreaksBlocks = true;
    public float explosionDamageVsLiving = 1.0f;
    public float explosionDamageVsPlayer = 1.0f;
    public float explosionDamageVsPlane = 1.0f;
    public float explosionDamageVsVehicle = 1.0f;
    public String dropItemOnDetonate = null;
    public String detonateSound = "";
    public boolean hasSubmunitions = false;
    public String submunition = "";
    public int numSubmunitions = 0;
    public int subMunitionTimer = 0;
    public float submunitionSpread = 1.0f;
    public boolean destroyOnDeploySubmunition = false;
    public int smokeParticleCount = 0;
    public int debrisParticleCount = 0;
    public static HashMap<String, ShootableType> shootables = new HashMap();

    public ShootableType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        if (shootables.containsKey(this.shortName)) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Shootable with shortname already exists!", null, null);
        }
        if (this.shortName != null && this.isValid) {
            shootables.put(this.shortName, this);
        }
        if (!this.readDamageVsPlayer) {
            this.damageVsPlayer = this.damageVsLiving;
        }
        if (!this.readDamageVsEntity) {
            this.damageVsEntity = this.damageVsVehicles;
        }
        if (!this.readDamageVsPlanes) {
            this.damageVsPlanes = this.damageVsVehicles;
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
            }
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.maxStackSize = ConfigUtils.configInt(config, new String[]{"StackSize", "MaxStackSize"}, this.maxStackSize);
            this.dropItemOnShoot = ConfigUtils.configString(config, "DropItemOnShoot", this.dropItemOnShoot);
            this.dropItemOnReload = ConfigUtils.configString(config, "DropItemOnReload", this.dropItemOnReload);
            this.dropItemOnHit = ConfigUtils.configString(config, "DropItemOnHit", this.dropItemOnHit);
            this.roundsPerItem = ConfigUtils.configInt(config, "RoundsPerItem", this.roundsPerItem);
            this.fallSpeed = ConfigUtils.configFloat(config, "FallSpeed", this.fallSpeed);
            this.throwSpeed = ConfigUtils.configFloat(config, new String[]{"ThrowSpeed", "ShootSpeed"}, this.throwSpeed);
            this.hitBoxSize = ConfigUtils.configFloat(config, "HitBoxSize", this.hitBoxSize);
            if (config.containsKey("Damage")) {
                this.damageVsPlanes = this.damageVsVehicles = ConfigUtils.configFloat(config, "Damage", 0.0f);
                this.damageVsEntity = this.damageVsVehicles;
                this.damageVsPlayer = this.damageVsVehicles;
                this.damageVsLiving = this.damageVsVehicles;
            }
            this.damageVsLiving = ConfigUtils.configFloat(config, "DamageVsLiving", this.damageVsLiving);
            if (config.containsKey("DamageVsPlayer")) {
                this.damageVsPlayer = ConfigUtils.configFloat(config, "DamageVsPlayer", this.damageVsPlayer);
                this.readDamageVsPlayer = true;
            }
            if (config.containsKey("DamageVsEntity")) {
                this.damageVsEntity = ConfigUtils.configFloat(config, "DamageVsEntity", this.damageVsEntity);
                this.readDamageVsEntity = true;
            }
            this.damageVsVehicles = ConfigUtils.configFloat(config, "DamageVsVehicles", this.damageVsVehicles);
            if (config.containsKey("DamageVsPlanes")) {
                this.damageVsPlanes = ConfigUtils.configFloat(config, "DamageVsPlanes", this.damageVsPlanes);
                this.readDamageVsPlanes = true;
            }
            this.blockPenetrationModifier = ConfigUtils.configFloat(config, "BlockPenetrationModifier", this.blockPenetrationModifier);
            this.ignoreArmorProbability = ConfigUtils.configFloat(config, "IgnoreArmorProbability", this.ignoreArmorProbability);
            this.ignoreArmorDamageFactor = ConfigUtils.configFloat(config, "IgnoreArmorDamageFactor", this.ignoreArmorDamageFactor);
            this.breaksGlass = ConfigUtils.configBool(config, "BreaksGlass", this.breaksGlass);
            this.bounciness = ConfigUtils.configFloat(config, "Bounciness", this.bounciness);
            this.hasLight = ConfigUtils.configBool(config, "HasLight", this.hasLight);
            this.hasDynamicLight = ConfigUtils.configBool(config, "HasDynamicLight", this.hasDynamicLight);
            this.fuse = ConfigUtils.configInt(config, "Fuse", this.fuse);
            this.despawnTime = ConfigUtils.configInt(config, "DespawnTime", this.despawnTime);
            this.explodeOnImpact = ConfigUtils.configBool(config, new String[]{"ExplodeOnImpact", "DetonateOnImpact"}, this.explodeOnImpact);
            this.fireRadius = ConfigUtils.configFloat(config, new String[]{"FireRadius", "Fire"}, this.fireRadius);
            this.explosionRadius = ConfigUtils.configFloat(config, new String[]{"ExplosionRadius", "Explosion"}, this.explosionRadius);
            this.explosionPower = ConfigUtils.configFloat(config, "ExplosionPower", this.explosionPower);
            this.explosionBreaksBlocks = ConfigUtils.configBool(config, new String[]{"ExplosionBreaksBlocks", "ExplosionsBreaksBlocks", "ExplosionBreakBlocks", "ExplosionsBreakBlocks"}, this.explosionBreaksBlocks);
            this.explosionDamageVsLiving = ConfigUtils.configFloat(config, "ExplosionDamageVsLiving", this.explosionDamageVsLiving);
            this.explosionDamageVsPlayer = ConfigUtils.configFloat(config, "ExplosionDamageVsPlayer", this.explosionDamageVsPlayer);
            this.explosionDamageVsPlane = ConfigUtils.configFloat(config, "ExplosionDamageVsPlane", this.explosionDamageVsPlane);
            this.explosionDamageVsVehicle = ConfigUtils.configFloat(config, "ExplosionDamageVsVehicle", this.explosionDamageVsVehicle);
            this.dropItemOnDetonate = ConfigUtils.configString(config, "DropItemOnDetonate", this.dropItemOnDetonate);
            this.detonateSound = ConfigUtils.configString(config, "DetonateSound", this.detonateSound);
            this.hasSubmunitions = ConfigUtils.configBool(config, "HasSubmunitions", this.hasSubmunitions);
            this.submunition = ConfigUtils.configString(config, "Submunition", this.submunition);
            this.numSubmunitions = ConfigUtils.configInt(config, "NumSubmunitions", this.numSubmunitions);
            this.subMunitionTimer = ConfigUtils.configInt(config, "SubmunitionDelay", this.subMunitionTimer);
            this.submunitionSpread = ConfigUtils.configFloat(config, "SubmunitionSpread", this.submunitionSpread);
            this.smokeParticleCount = ConfigUtils.configInt(config, "FlareParticleCount", this.smokeParticleCount);
            this.debrisParticleCount = ConfigUtils.configInt(config, "DebrisParticleCount", this.debrisParticleCount);
            this.trailParticles = ConfigUtils.configBool(config, new String[]{"TrailParticles", "SmokeTrail"}, this.trailParticles);
            this.trailParticleType = ConfigUtils.configString(config, "TrailParticleType", this.trailParticleType);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error while reading Shootable", null, ex);
            this.isValid = false;
        }
    }

    public static ShootableType getShootableType(String string) {
        return shootables.get(string);
    }

    @Override
    public float GetRecommendedScale() {
        return 0.0f;
    }

    public float getBlockPenetrationModifier() {
        return this.blockPenetrationModifier < 0.0f ? FlansMod.masterBlockPenetrationModifier : this.blockPenetrationModifier;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

