/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.IGunboxDescriptionable;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemBullet
extends ItemShootable
implements IFlanItem,
IGunboxDescriptionable {
    public BulletType type;
    public String originGunbox = "";

    @Override
    public String getOriginGunBox() {
        return this.originGunbox;
    }

    @Override
    public void setOriginGunBox(String e) {
        this.originGunbox = e;
    }

    public ItemBullet(BulletType infoType) {
        super(infoType);
        this.type = infoType;
        this.func_77625_d(this.type.maxStackSize);
        this.func_77627_a(true);
        this.type.item = this;
        switch (this.type.weaponType) {
            case SHELL: 
            case BOMB: 
            case MINE: 
            case MISSILE: {
                this.func_77637_a(FlansMod.tabFlanDriveables);
                break;
            }
            default: {
                this.func_77637_a(FlansMod.tabFlanGuns);
            }
        }
    }

    public boolean isRepairable() {
        return this.canRepair;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        if (this.type.fancyDescription && FlansMod.showItemDescriptions) {
            KeyBinding shift = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (!this.type.packName.isEmpty() && FlansMod.showPackNameInItemDescriptions) {
                lines.add("\u00a7o" + this.type.packName);
            }
            if (this.type.description != null) {
                Collections.addAll(lines, this.type.description.split("_"));
            }
            if (!GameSettings.func_100015_a((KeyBinding)shift)) {
                lines.add("Hold \u00a7b\u00a7o" + GameSettings.func_74298_c((int)shift.func_151463_i()) + "\u00a7r\u00a77 for details");
            } else {
                lines.add("");
                if (this.originGunbox != "") {
                    lines.add("\u00a79Box\u00a77: " + this.originGunbox);
                }
                lines.add("\u00a79Damage\u00a77: " + ItemBullet.roundFloat(this.type.damageVsLiving, 2));
                lines.add("\u00a79Penetration\u00a77: " + ItemBullet.roundFloat(this.type.penetratingPower, 2));
                lines.add("\u00a79Rounds\u00a77: " + this.type.roundsPerItem);
                lines.add("\u00a79Fall Speed\u00a77: " + ItemBullet.roundFloat(this.type.fallSpeed, 2));
                if (this.type.explosionRadius > 0.0f) {
                    lines.add("\u00a79Explosion Radius\u00a77: " + ItemBullet.roundFloat(this.type.explosionRadius, 2));
                    lines.add("\u00a79Explosion Power\u00a77: " + ItemBullet.roundFloat(this.type.explosionPower, 2));
                }
                if (this.type.numBullets > -1) {
                    lines.add("\u00a79Shot\u00a77: " + this.type.numBullets);
                }
                if (this.type.bulletSpread > -1.0f) {
                    lines.add("\u00a79Spread\u00a77: " + this.type.bulletSpread);
                }
                if (this.type.lockOnToLivings || this.type.lockOnToMechas || this.type.lockOnToPlanes || this.type.lockOnToPlayers || this.type.lockOnToVehicles) {
                    lines.add("\u00a79Guidance:\u00a77: LockOn");
                } else if (this.type.manualGuidance) {
                    lines.add("\u00a79Guidance:\u00a77: Manual");
                } else if (this.type.laserGuidance) {
                    lines.add("\u00a79Guidance:\u00a77: Laser");
                } else if (this.type.weaponType == EnumWeaponType.MISSILE) {
                    lines.add("\u00a79Guidance:\u00a77: Unguided");
                }
                lines.add("");
            }
        } else {
            if (!this.type.packName.isEmpty() && FlansMod.showPackNameInItemDescriptions) {
                lines.add(this.type.packName);
            }
            if (this.type.description != null) {
                Collections.addAll(lines, this.type.description.split("_"));
            }
        }
    }

    @Override
    public EntityShootable getEntity(World worldObj, Vec3 origin, float yaw, float pitch, double motionX, double motionY, double motionZ, EntityLivingBase shooter, float gunDamage, int itemDamage, InfoType shotFrom) {
        return new EntityBullet(worldObj, origin, yaw, pitch, motionX, motionY, motionZ, shooter, gunDamage, this.type, shotFrom);
    }

    @Override
    public EntityShootable getEntity(World worldObj, Vector3f origin, Vector3f direction, EntityLivingBase shooter, float spread, float damage, float speed, int itemDamage, InfoType shotFrom) {
        return new EntityBullet(worldObj, origin, direction, shooter, spread, damage, this.type, speed, shotFrom);
    }

    @Override
    public EntityShootable getEntity(World worldObj, Vec3 origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float damage, float speed, int itemDamage, InfoType shotFrom) {
        return new EntityBullet(worldObj, origin, yaw, pitch, shooter, spread, damage, this.type, speed, shotFrom);
    }

    @Override
    public EntityShootable getEntity(World worldObj, EntityLivingBase player, float bulletSpread, float damage, float bulletSpeed, boolean b, int itemDamage, InfoType shotFrom) {
        return new EntityBullet(worldObj, player, bulletSpread, damage, this.type, bulletSpeed, b, shotFrom);
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    public static float roundFloat(float value, int points) {
        int pow = 10;
        for (int i = 1; i < points; ++i) {
            pow *= 10;
        }
        float result = value * (float)pow;
        return (float)((int)(result - (float)((int)result) >= 0.5f ? result + 1.0f : result)) / (float)pow;
    }
}

