/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.EnumAnimationType;
import com.flansmod.client.model.EnumMeleeAnimation;
import com.flansmod.client.model.ModelCasing;
import com.flansmod.client.model.ModelFlash;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMG;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.EnumSecondaryFunction;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GunType
extends PaintableType
implements IScope {
    public static final Random rand = new Random();
    private static final int DEFAULT_SHOOT_DELAY = 2;
    public GunRecoil recoil = new GunRecoil();
    public boolean useFancyRecoil = false;
    public float recoilPitch = 0.0f;
    public float recoilYaw = 0.0f;
    public float rndRecoilPitchRange = 0.5f;
    public float rndRecoilYawRange = 0.3f;
    public float decreaseRecoilPitch = 0.0f;
    public float decreaseRecoilYaw = 0.0f;
    public float recoilSneakingMultiplier = -1.0f;
    public float recoilSprintingMultiplier = 1.0f;
    public float recoilSneakingMultiplierYaw = 0.8f;
    public float recoilSprintingMultiplierYaw = 1.2f;
    public float recoilCounterCoefficient = 0.8f;
    public float recoilCounterCoefficientSprinting = 0.9f;
    public float recoilCounterCoefficientSneaking = 0.7f;
    public List<ShootableType> ammo = new ArrayList<ShootableType>();
    public boolean canForceReload = true;
    public boolean allowRearm = true;
    public int reloadTime;
    public int numPrimaryAmmoItems = 1;
    public float bulletSpread;
    public float sneakSpreadModifier = 0.63f;
    public float sprintSpreadModifier = 1.75f;
    public boolean allowSpreadByBullet = false;
    public float damage = 0.0f;
    public float meleeDamage = 1.0f;
    public float meleeDamageDriveableModifier = 1.0f;
    public float bulletSpeed = 5.0f;
    public int numBullets = 1;
    public boolean allowNumBulletsByBulletType = false;
    public float shootDelay = 0.0f;
    public float roundsPerMin = 0.0f;
    public EnumFireMode mode = EnumFireMode.FULLAUTO;
    public EnumFireMode[] submode = new EnumFireMode[]{EnumFireMode.FULLAUTO};
    public EnumFireMode defaultmode = this.mode;
    public int numBurstRounds = 3;
    public float minigunStartSpeed = 15.0f;
    public boolean canShootUnderwater = true;
    public EnumSecondaryFunction secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
    public EnumSecondaryFunction secondaryFunctionWhenShoot = null;
    private boolean oneHanded = false;
    public boolean consumeGunUponUse = false;
    public boolean showCrosshair = true;
    public String dropItemOnShoot = null;
    public boolean usableByPlayers = true;
    public boolean usableByMechas = true;
    public EnumAction itemUseAction = EnumAction.bow;
    public int hipFireWhileSprinting = 0;
    public int canLockOnAngle = 5;
    public int lockOnSoundTime = 0;
    public String lockOnSound = "";
    public int maxRangeLockOn = 80;
    public boolean canSetPosition = false;
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public boolean shield = false;
    public Vector3f shieldOrigin;
    public Vector3f shieldDimensions;
    public float shieldDamageAbsorption = 0.0f;
    public String shootSound;
    public String bulletInsert = "defaultshellinsert";
    public String actionSound;
    public String lastShootSound;
    public String suppressedShootSound;
    public String lastShootSoundSuppressed;
    public int shootSoundLength;
    public String reloadSound;
    public String reloadSoundOnEmpty;
    public String clickSoundOnEmpty;
    public String clickSoundOnEmptyRepeated;
    public String idleSound;
    public boolean distortSound = true;
    public int idleSoundLength;
    public int idleSoundRange = 50;
    public int meleeSoundRange = 50;
    public int reloadSoundRange = 50;
    public int gunSoundRange = 50;
    public String distantShootSound = "";
    public int distantSoundRange = 100;
    public boolean useLoopingSounds = false;
    public String warmupSound;
    public int warmupSoundLength = 20;
    public String loopedSound;
    public int loopedSoundLength = 20;
    public String cooldownSound;
    public String meleeSound;
    public int meleeTime = 1;
    public ArrayList<Vector3f> meleePath = new ArrayList();
    public ArrayList<Vector3f> meleePathAngles = new ArrayList();
    public ArrayList<Vector3f> meleeDamagePoints = new ArrayList();
    public boolean deployable = false;
    public ModelMG deployableModel;
    public String deployableModelString;
    public String deployableTexture;
    public float standBackDist = 1.5f;
    public float topViewLimit = -60.0f;
    public float bottomViewLimit = 30.0f;
    public float sideViewLimit = 45.0f;
    public float pivotHeight = 0.375f;
    public String defaultScopeTexture;
    public boolean hasScopeOverlay = false;
    public float zoomLevel = 1.0f;
    public float FOVFactor = 1.5f;
    public boolean allowNightVision = false;
    public ModelGun model;
    public ModelCasing casingModel;
    public String casingModelString;
    public ModelFlash flashModel;
    public String flashModelString;
    public String casingTexture;
    public String flashTexture;
    public String hitTexture;
    public String muzzleFlashParticle = "flansmod.muzzleflash";
    public float muzzleFlashParticleSize = 1.0f;
    private Boolean useMuzzleFlashDefaults = true;
    private Boolean showMuzzleFlashParticles = true;
    public Boolean showMuzzleFlashParticlesFirstPerson = false;
    public Vector3f muzzleFlashParticlesHandOffset = new Vector3f();
    public Vector3f muzzleFlashParticlesShoulderOffset = new Vector3f();
    public boolean allowAllAttachments = false;
    public ArrayList<AttachmentType> allowedAttachments = new ArrayList();
    public boolean allowBarrelAttachments = false;
    public boolean allowScopeAttachments = false;
    public boolean allowStockAttachments = false;
    public boolean allowGripAttachments = false;
    public boolean allowGadgetAttachments = false;
    public boolean allowSlideAttachments = false;
    public boolean allowPumpAttachments = false;
    public boolean allowAccessoryAttachments = false;
    public int numGenericAttachmentSlots = 0;
    public static HashMap<String, GunType> guns = new HashMap();
    public static ArrayList<GunType> gunList = new ArrayList();
    public float moveSpeedModifier = 1.0f;
    public float knockbackModifier = 0.0f;
    private float defaultSpread = 0.0f;
    public float adsSpreadModifier = -1.0f;
    public float adsSpreadModifierShotgun = -1.0f;
    public float switchDelay = 0.0f;
    private boolean hasVariableZoom = false;
    private float minZoom = 1.0f;
    private float maxZoom = 4.0f;
    private float zoomAugment = 1.0f;

    public GunType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null & this.isValid) {
            gunList.add(this);
            guns.put(this.shortName, this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            String scopeString;
            this.damage = ConfigUtils.configFloat(config, "Damage", this.damage);
            this.meleeDamageDriveableModifier = ConfigUtils.configFloat(config, "MeleeDamageDriveableModifier", this.meleeDamageDriveableModifier);
            this.recoilCounterCoefficient = ConfigUtils.configFloat(config, "CounterRecoilForce", this.recoilCounterCoefficient);
            this.recoilCounterCoefficientSneaking = ConfigUtils.configFloat(config, "CounterRecoilForceSneaking", this.recoilCounterCoefficientSneaking);
            this.recoilCounterCoefficientSprinting = ConfigUtils.configFloat(config, "CounterRecoilForceSprinting", this.recoilCounterCoefficientSprinting);
            this.sneakSpreadModifier = ConfigUtils.configFloat(config, new String[]{"SneakSpreadModifier", "SneakSpreadMultiplier"}, this.sneakSpreadModifier);
            this.sprintSpreadModifier = ConfigUtils.configFloat(config, new String[]{"SprintSpreadModifier", "SprintSpreadMultiplier"}, this.sprintSpreadModifier);
            this.canForceReload = ConfigUtils.configBool(config, "CanForceReload", this.canForceReload);
            this.allowRearm = ConfigUtils.configBool(config, "AllowRearm", this.allowRearm);
            this.reloadTime = ConfigUtils.configInt(config, "ReloadTime", this.reloadTime);
            this.recoilPitch = ConfigUtils.configFloat(config, "Recoil", this.recoilPitch);
            String[] aSplit = ConfigUtils.getSplitFromKey(config, "FancyRecoil");
            try {
                if (aSplit != null && aSplit.length > 1) {
                    this.recoil.read(aSplit);
                    this.useFancyRecoil = true;
                }
            }
            catch (Exception ex) {
                this.useFancyRecoil = false;
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Failed to read fancy recoil", aSplit, ex);
            }
            this.recoilYaw = ConfigUtils.configFloat(config, "RecoilYaw", this.recoilYaw) / 10.0f;
            this.rndRecoilPitchRange = ConfigUtils.configFloat(config, "RandomRecoilRange", this.rndRecoilPitchRange);
            this.rndRecoilYawRange = ConfigUtils.configFloat(config, "RandomRecoilYawRange", this.rndRecoilYawRange);
            this.decreaseRecoilPitch = ConfigUtils.configFloat(config, "DecreaseRecoil", this.decreaseRecoilPitch);
            this.decreaseRecoilYaw = ConfigUtils.configFloat(config, "DecreaseRecoilYaw", this.decreaseRecoilYaw);
            this.decreaseRecoilYaw = this.decreaseRecoilYaw > 0.0f ? this.decreaseRecoilYaw : 0.5f;
            this.recoilSneakingMultiplier = ConfigUtils.configFloat(config, "RecoilSneakingMultiplier", this.recoilSneakingMultiplier);
            this.recoilSprintingMultiplier = ConfigUtils.configFloat(config, "RecoilSprintingMultiplier", this.recoilSprintingMultiplier);
            this.recoilSneakingMultiplierYaw = ConfigUtils.configFloat(config, "RecoilSneakingMultiplierYaw", this.recoilSneakingMultiplierYaw);
            this.recoilSprintingMultiplierYaw = ConfigUtils.configFloat(config, "RecoilSprintingMultiplierYaw", this.recoilSprintingMultiplierYaw);
            this.defaultSpread = this.bulletSpread = ConfigUtils.configFloat(config, new String[]{"Accuracy", "Spread"}, this.defaultSpread);
            this.adsSpreadModifier = ConfigUtils.configFloat(config, "ADSSpreadModifier", this.adsSpreadModifier);
            this.adsSpreadModifierShotgun = ConfigUtils.configFloat(config, "ADSSpreadModifierShotgun", this.adsSpreadModifierShotgun);
            this.numBullets = ConfigUtils.configInt(config, "NumBullets", this.numBullets);
            this.allowNumBulletsByBulletType = ConfigUtils.configBool(config, "AllowNumBulletsByBulletType", this.allowNumBulletsByBulletType);
            this.allowSpreadByBullet = ConfigUtils.configBool(config, "AllowSpreadByBullet", this.allowSpreadByBullet);
            this.canLockOnAngle = ConfigUtils.configInt(config, "CanLockAngle", this.canLockOnAngle);
            this.lockOnSoundTime = ConfigUtils.configInt(config, "LockOnSoundTime", this.lockOnSoundTime);
            if (config.containsKey("LockOnToDriveables")) {
                this.lockOnToVehicles = this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToDriveables", false);
                this.lockOnToPlanes = this.lockOnToMechas;
            }
            this.lockOnToVehicles = ConfigUtils.configBool(config, "LockOnToVehicles", this.lockOnToVehicles);
            this.lockOnToPlanes = ConfigUtils.configBool(config, "LockOnToPlanes", this.lockOnToPlanes);
            this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToMechas", this.lockOnToMechas);
            this.lockOnToPlayers = ConfigUtils.configBool(config, "LockOnToPlayers", this.lockOnToPlayers);
            this.lockOnToLivings = ConfigUtils.configBool(config, "LockOnToLivings", this.lockOnToLivings);
            this.maxRangeLockOn = ConfigUtils.configInt(config, "MaxRangeLockOn", this.maxRangeLockOn);
            this.consumeGunUponUse = ConfigUtils.configBool(config, "ConsumeGunOnUse", this.consumeGunUponUse);
            this.showCrosshair = ConfigUtils.configBool(config, "ShowCrosshair", this.showCrosshair);
            this.dropItemOnShoot = ConfigUtils.configString(config, "DropItemOnShoot", null);
            this.numBurstRounds = ConfigUtils.configInt(config, "NumBurstRounds", this.numBurstRounds);
            this.minigunStartSpeed = ConfigUtils.configFloat(config, "MinigunStartSpeed", this.minigunStartSpeed);
            String line = ConfigUtils.configString(config, "ItemUseAction", null);
            try {
                if (line != null) {
                    this.itemUseAction = EnumAction.valueOf((String)line.toLowerCase());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "ItemUseAction not recognised in gun", new String[]{"ItemUseAction", line}, ex);
            }
            if (config.containsKey("HipFireWhileSprinting")) {
                this.hipFireWhileSprinting = ConfigUtils.configBool(config, "HipFireWhileSprinting", false) ? 1 : 2;
            }
            this.shootDelay = ConfigUtils.configFloat(config, "ShootDelay", this.shootDelay);
            this.roundsPerMin = ConfigUtils.configFloat(config, "RoundsPerMin", this.roundsPerMin);
            this.shootSoundLength = ConfigUtils.configInt(config, "SoundLength", this.shootSoundLength);
            this.distortSound = ConfigUtils.configBool(config, "DistortSound", this.distortSound);
            this.idleSoundRange = ConfigUtils.configInt(config, "IdleSoundRange", this.idleSoundRange);
            this.meleeSoundRange = ConfigUtils.configInt(config, "MeleeSoundRange", this.meleeSoundRange);
            this.reloadSoundRange = ConfigUtils.configInt(config, "ReloadSoundRange", this.reloadSoundRange);
            this.gunSoundRange = ConfigUtils.configInt(config, "GunSoundRange", this.gunSoundRange);
            this.shootSound = ConfigUtils.configGunSound(this.packName, config, "ShootSound", this.shootSound);
            this.bulletInsert = ConfigUtils.configGunSound(this.packName, config, "BulletInsertSound", this.bulletInsert);
            this.actionSound = ConfigUtils.configGunSound(this.packName, config, "ActionSound", this.actionSound);
            this.lastShootSound = ConfigUtils.configGunSound(this.packName, config, "LastShootSound", this.lastShootSound);
            this.suppressedShootSound = ConfigUtils.configGunSound(this.packName, config, "SuppressedShootSound", this.suppressedShootSound);
            this.lastShootSoundSuppressed = ConfigUtils.configGunSound(this.packName, config, "LastSuppressedShootSound", this.lastShootSoundSuppressed);
            this.reloadSound = ConfigUtils.configGunSound(this.packName, config, "ReloadSound", this.reloadSound);
            this.reloadSoundOnEmpty = ConfigUtils.configGunSound(this.packName, config, "EmptyReloadSound", this.reloadSoundOnEmpty);
            this.clickSoundOnEmpty = ConfigUtils.configGunSound(this.packName, config, "EmptyClickSound", this.clickSoundOnEmpty);
            this.clickSoundOnEmptyRepeated = ConfigUtils.configGunSound(this.packName, config, "EmptyClickSoundRepeated", this.clickSoundOnEmptyRepeated);
            this.idleSound = ConfigUtils.configGunSound(this.packName, config, "IdleSound", this.idleSound);
            this.idleSoundLength = ConfigUtils.configInt(config, "IdleSoundLength", this.idleSoundLength);
            this.meleeSound = ConfigUtils.configGunSound(this.packName, config, "MeleeSound", this.meleeSound);
            this.warmupSound = ConfigUtils.configGunSound(this.packName, config, "WarmupSound", this.warmupSound);
            this.warmupSoundLength = ConfigUtils.configInt(config, "WarmupSoundLength", this.warmupSoundLength);
            this.loopedSound = ConfigUtils.configGunSound(this.packName, config, new String[]{"LoopedSound", "SpinSound"}, this.loopedSound);
            if (this.loopedSound != null && !this.loopedSound.isEmpty()) {
                this.useLoopingSounds = true;
            }
            this.loopedSoundLength = ConfigUtils.configInt(config, new String[]{"LoopedSoundLength", "SpinSoundLength"}, this.loopedSoundLength);
            this.cooldownSound = ConfigUtils.configGunSound(this.packName, config, "CooldownSound", this.cooldownSound);
            this.lockOnSound = ConfigUtils.configGunSound(this.packName, config, "LockOnSound", this.lockOnSound);
            this.distantShootSound = ConfigUtils.configGunSound(this.packName, config, new String[]{"DistantSound", "DistantShootSound"}, this.distantShootSound);
            this.distantSoundRange = ConfigUtils.configInt(config, "DistantSoundRange", this.distantSoundRange);
            aSplit = ConfigUtils.getSplitFromKey(config, "Mode");
            if (aSplit != null) {
                try {
                    this.defaultmode = this.mode = EnumFireMode.getFireMode(aSplit[1]);
                    this.submode = new EnumFireMode[aSplit.length - 1];
                    for (int i = 0; i < this.submode.length; ++i) {
                        this.submode[i] = EnumFireMode.getFireMode(aSplit[1 + i]);
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while setting gun mode", aSplit, ex);
                }
            }
            if ((scopeString = ConfigUtils.configString(config, "Scope", null)) == null || scopeString.equalsIgnoreCase("None")) {
                this.hasScopeOverlay = false;
            } else {
                this.hasScopeOverlay = true;
                this.defaultScopeTexture = scopeString;
            }
            this.allowNightVision = ConfigUtils.configBool(config, "AllowNightVision", this.allowNightVision);
            this.deployable = ConfigUtils.configBool(config, "Deployable", this.deployable);
            this.deployableModelString = ConfigUtils.configString(this.configMap, "DeployedModel", null);
            this.casingModelString = ConfigUtils.configString(config, "CasingModel", null);
            this.flashModelString = ConfigUtils.configString(config, "FlashModel", null);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.deployableModel = FlansMod.proxy.loadModel(this.deployableModelString, this.shortName, ModelMG.class);
                this.casingModel = FlansMod.proxy.loadModel(this.casingModelString, this.shortName, ModelCasing.class);
                this.flashModel = FlansMod.proxy.loadModel(this.flashModelString, this.shortName, ModelFlash.class);
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelGun.class);
            }
            this.casingTexture = ConfigUtils.configString(config, "CasingTexture", null);
            this.flashTexture = ConfigUtils.configString(config, "FlashTexture", null);
            this.muzzleFlashParticle = ConfigUtils.configString(config, "MuzzleFlashParticle", this.muzzleFlashParticle);
            this.muzzleFlashParticleSize = ConfigUtils.configFloat(config, "MuzzleFlashParticleSize", this.muzzleFlashParticleSize);
            this.useMuzzleFlashDefaults = !config.containsKey("ShowMuzzleFlashParticle");
            this.showMuzzleFlashParticles = ConfigUtils.configBool(config, "ShowMuzzleFlashParticle", (boolean)this.showMuzzleFlashParticles);
            this.showMuzzleFlashParticlesFirstPerson = ConfigUtils.configBool(config, "ShowMuzzleFlashParticleFirstPerson", (boolean)this.showMuzzleFlashParticlesFirstPerson);
            this.muzzleFlashParticlesShoulderOffset = ConfigUtils.configVector(config, "MuzzleFlashParticleShoulderOffset", this.muzzleFlashParticlesShoulderOffset);
            this.muzzleFlashParticlesHandOffset = ConfigUtils.configVector(config, "MuzzleFlashParticleHandOffset", this.muzzleFlashParticlesHandOffset);
            this.modelScale = ConfigUtils.configFloat(config, "ModelScale", this.modelScale);
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.hitTexture = ConfigUtils.configString(config, "HitTexture", this.hitTexture);
            this.deployableTexture = ConfigUtils.configString(config, "DeployedTexture", this.deployableTexture);
            this.topViewLimit = ConfigUtils.configFloat(config, "TopViewLimit", this.modelScale);
            this.bottomViewLimit = ConfigUtils.configFloat(config, "BottomViewLimit", this.modelScale);
            this.sideViewLimit = ConfigUtils.configFloat(config, "SideViewLimit", this.modelScale);
            this.pivotHeight = ConfigUtils.configFloat(config, "PivotHeight", this.modelScale);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Ammo"});
            for (String[] split : splits) {
                try {
                    ShootableType type = ShootableType.getShootableType(split[1]);
                    if (type == null) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't find shootable type for adding Ammo to gun", split, null);
                        continue;
                    }
                    this.ammo.add(type);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding Ammo for gun", split, ex);
                }
            }
            this.numPrimaryAmmoItems = ConfigUtils.configInt(config, new String[]{"NumAmmoSlots", "NumAmmoItemsInGun", "LoadIntoGun"}, this.numPrimaryAmmoItems);
            this.bulletSpeed = ConfigUtils.configFloat(config, "BulletSpeed", this.bulletSpeed);
            this.canShootUnderwater = ConfigUtils.configBool(config, "CanShootUnderwater", this.canShootUnderwater);
            this.canSetPosition = ConfigUtils.configBool(config, "CanSetPosition", this.canSetPosition);
            this.oneHanded = ConfigUtils.configBool(config, "OneHanded", this.oneHanded);
            this.usableByPlayers = ConfigUtils.configBool(config, "UsableByPlayers", this.usableByPlayers);
            this.usableByMechas = ConfigUtils.configBool(config, "UsableByMechas", this.usableByMechas);
            if (ConfigUtils.configBool(config, "UseCustomMeleeWhenShoot", false)) {
                this.secondaryFunctionWhenShoot = EnumSecondaryFunction.CUSTOM_MELEE;
            }
            this.meleeTime = ConfigUtils.configInt(config, "MeleeTime", this.meleeTime);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddNode"});
            for (String[] split : splits) {
                try {
                    this.meleePath.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
                    this.meleePathAngles.add(new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6])));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown during AddNode", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"MeleeDamagePoint", "MeleeDamageOffset"});
            for (String[] split : splits) {
                try {
                    this.meleeDamagePoints.add(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown during MeleeDamagePoint", split, ex);
                }
            }
            this.moveSpeedModifier = ConfigUtils.configFloat(config, new String[]{"MoveSpeedModifier", "Slowness"}, this.moveSpeedModifier);
            this.knockbackModifier = ConfigUtils.configFloat(config, new String[]{"KnockbackReduction", "KnockbackModifier"}, this.knockbackModifier);
            this.switchDelay = ConfigUtils.configFloat(config, "SwitchDelay", this.switchDelay);
            this.allowAllAttachments = ConfigUtils.configBool(config, "AllowAllAttachments", this.allowAllAttachments);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AllowAttachments"});
            try {
                for (String[] split : splits) {
                    for (int i = 1; i < split.length; ++i) {
                        AttachmentType type = AttachmentType.getAttachment(split[i]);
                        if (type != null) {
                            this.allowedAttachments.add(type);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Attachment type not found for AllowAttachments (" + split[i] + ")", split, null);
                    }
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Failed to add allowed attachment with AllowAttachments", aSplit, ex);
            }
            this.allowBarrelAttachments = ConfigUtils.configBool(config, "AllowBarrelAttachments", this.allowBarrelAttachments);
            this.allowScopeAttachments = ConfigUtils.configBool(config, "AllowScopeAttachments", this.allowScopeAttachments);
            this.allowStockAttachments = ConfigUtils.configBool(config, "AllowStockAttachments", this.allowStockAttachments);
            this.allowGripAttachments = ConfigUtils.configBool(config, "AllowGripAttachments", this.allowGripAttachments);
            this.allowGadgetAttachments = ConfigUtils.configBool(config, "AllowGadgetAttachments", this.allowGadgetAttachments);
            this.allowSlideAttachments = ConfigUtils.configBool(config, "AllowSlideAttachments", this.allowSlideAttachments);
            this.allowPumpAttachments = ConfigUtils.configBool(config, "AllowPumpAttachments", this.allowPumpAttachments);
            this.allowAccessoryAttachments = ConfigUtils.configBool(config, "AllowAccessoryAttachments", this.allowAccessoryAttachments);
            this.numGenericAttachmentSlots = ConfigUtils.configInt(config, "NumGenericAttachmentSlots", this.numGenericAttachmentSlots);
            String[] split = ConfigUtils.getSplitFromKey(config, "Shield");
            try {
                if (split != null) {
                    this.shield = true;
                    this.shieldDamageAbsorption = Float.parseFloat(split[1]);
                    this.shieldOrigin = new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f);
                    this.shieldDimensions = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Failed to config Shield", split, ex);
            }
            this.zoomLevel = ConfigUtils.configFloat(config, "ZoomLevel", this.zoomLevel);
            if (config.containsKey("ZoomLevel") && this.zoomLevel > 1.0f) {
                this.secondaryFunction = EnumSecondaryFunction.ZOOM;
            }
            this.FOVFactor = ConfigUtils.configFloat(config, "FOVZoomLevel", this.FOVFactor);
            if (config.containsKey("FOVZoomLevel") && this.FOVFactor > 1.0f) {
                this.secondaryFunction = EnumSecondaryFunction.ADS_ZOOM;
            }
            this.hasVariableZoom = ConfigUtils.configBool(config, "HasVariableZoom", this.hasVariableZoom);
            this.minZoom = ConfigUtils.configFloat(config, "MinZoom", this.minZoom);
            this.maxZoom = ConfigUtils.configFloat(config, "MaxZoom", this.maxZoom);
            if (this.maxZoom > 1.0f && this.hasVariableZoom) {
                this.secondaryFunction = EnumSecondaryFunction.ZOOM;
            }
            this.zoomAugment = ConfigUtils.configFloat(config, "ZoomAugment", this.zoomAugment);
            this.meleeDamage = ConfigUtils.configFloat(config, "MeleeDamage", this.meleeDamage);
            EnumSecondaryFunction enumSecondaryFunction = this.secondaryFunction = this.meleeDamage > 0.0f && config.containsKey("MeleeDamage") && !this.hasZoomOverlay() ? EnumSecondaryFunction.MELEE : this.secondaryFunction;
            if (ConfigUtils.configBool(config, "UseCustomMelee", false)) {
                this.secondaryFunction = EnumSecondaryFunction.CUSTOM_MELEE;
            }
            String secondaryFunctionString = ConfigUtils.configString(config, "SecondaryFunction", this.secondaryFunction.toString());
            this.secondaryFunction = EnumSecondaryFunction.get(secondaryFunctionString);
            if (FMLCommonHandler.instance().getSide().isClient() && this.model != null) {
                this.processAnimationConfigs(config);
            }
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.shortName, this.packName, "Fatal error while loading gun", null, ex);
            this.isValid = false;
        }
    }

    public void processAnimationConfigs(ConfigMap config) {
        this.model.minigunBarrelOrigin = ConfigUtils.configVector(config, "animMinigunBarrelOrigin", this.model.minigunBarrelOrigin);
        this.model.barrelAttachPoint = ConfigUtils.configVector(config, "animBarrelAttachPoint", this.model.barrelAttachPoint);
        this.model.scopeAttachPoint = ConfigUtils.configVector(config, "animScopeAttachPoint", this.model.scopeAttachPoint);
        this.model.stockAttachPoint = ConfigUtils.configVector(config, "animStockAttachPoint", this.model.stockAttachPoint);
        this.model.gripAttachPoint = ConfigUtils.configVector(config, "animGripAttachPoint", this.model.gripAttachPoint);
        this.model.gadgetAttachPoint = ConfigUtils.configVector(config, "animGadgetAttachPoint", this.model.gadgetAttachPoint);
        this.model.slideAttachPoint = ConfigUtils.configVector(config, "animSlideAttachPoint", this.model.slideAttachPoint);
        this.model.pumpAttachPoint = ConfigUtils.configVector(config, "animPumpAttachPoint", this.model.pumpAttachPoint);
        this.model.accessoryAttachPoint = ConfigUtils.configVector(config, "animAccessoryAttachPoint", this.model.accessoryAttachPoint);
        this.model.defaultBarrelFlashPoint = ConfigUtils.configVector(config, "animDefaultBarrelFlashPoint", this.model.defaultBarrelFlashPoint);
        this.model.muzzleFlashPoint = ConfigUtils.configVector(config, "animMuzzleFlashPoint", this.model.muzzleFlashPoint);
        this.model.hasFlash = ConfigUtils.configBool(config, "animHasFlash", this.model.hasFlash);
        this.model.hasArms = ConfigUtils.configBool(config, "animHasArms", this.model.hasArms);
        this.model.easyArms = ConfigUtils.configBool(config, "easyArms", this.model.easyArms);
        this.model.armScale = ConfigUtils.configVector(config, "armScale", this.model.armScale);
        this.model.leftArmPos = ConfigUtils.configVector(config, "animLeftArmPos", this.model.leftArmPos);
        this.model.leftArmRot = ConfigUtils.configVector(config, "animLeftArmRot", this.model.leftArmRot);
        this.model.leftArmScale = ConfigUtils.configVector(config, "animLeftArmScale", this.model.leftArmScale);
        this.model.rightArmPos = ConfigUtils.configVector(config, "animRightArmPos", this.model.rightArmPos);
        this.model.rightArmRot = ConfigUtils.configVector(config, "animRightArmRot", this.model.rightArmRot);
        this.model.rightArmScale = ConfigUtils.configVector(config, "animRightArmScale", this.model.rightArmScale);
        this.model.rightArmReloadPos = ConfigUtils.configVector(config, "animRightArmReloadPos", this.model.rightArmReloadPos);
        this.model.rightArmReloadRot = ConfigUtils.configVector(config, "animRightArmReloadRot", this.model.rightArmReloadRot);
        this.model.leftArmReloadPos = ConfigUtils.configVector(config, "animLeftArmReloadPos", this.model.leftArmReloadPos);
        this.model.leftArmReloadRot = ConfigUtils.configVector(config, "animLeftArmReloadRot", this.model.leftArmReloadRot);
        this.model.rightArmChargePos = ConfigUtils.configVector(config, "animRightArmChargePos", this.model.rightArmChargePos);
        this.model.rightArmChargeRot = ConfigUtils.configVector(config, "animRightArmChargeRot", this.model.rightArmChargeRot);
        this.model.leftArmChargePos = ConfigUtils.configVector(config, "animLeftArmChargePos", this.model.leftArmChargePos);
        this.model.leftArmChargeRot = ConfigUtils.configVector(config, "animLeftArmChargeRot", this.model.leftArmChargeRot);
        this.model.stagedrightArmReloadPos = ConfigUtils.configVector(config, "animStagedRightArmReloadPos", this.model.stagedrightArmReloadPos);
        this.model.stagedrightArmReloadRot = ConfigUtils.configVector(config, "animStagedRightArmReloadRot", this.model.stagedrightArmReloadRot);
        this.model.stagedleftArmReloadPos = ConfigUtils.configVector(config, "animStagedLeftArmReloadPos", this.model.stagedleftArmReloadPos);
        this.model.stagedleftArmReloadRot = ConfigUtils.configVector(config, "animStagedLeftArmReloadRot", this.model.stagedleftArmReloadRot);
        this.model.rightHandAmmo = ConfigUtils.configBool(config, "animRightHandAmmo", this.model.rightHandAmmo);
        this.model.leftHandAmmo = ConfigUtils.configBool(config, "animLeftHandAmmo", this.model.leftHandAmmo);
        this.model.gunSlideDistance = ConfigUtils.configFloat(config, "animGunSlideDistance", this.model.gunSlideDistance);
        this.model.altgunSlideDistance = ConfigUtils.configFloat(config, "animAltGunSlideDistance", this.model.altgunSlideDistance);
        this.model.RecoilSlideDistance = ConfigUtils.configFloat(config, "animRecoilSlideDistance", this.model.RecoilSlideDistance);
        this.model.RotateSlideDistance = ConfigUtils.configFloat(config, "animRotatedSlideDistance", this.model.RotateSlideDistance);
        this.model.ShakeDistance = ConfigUtils.configFloat(config, "animShakeDistance", this.model.ShakeDistance);
        this.model.recoilAmount = ConfigUtils.configFloat(config, "animRecoilAmount", this.model.recoilAmount);
        this.model.casingAnimDistance = ConfigUtils.configVector(config, "animCasingAnimDistance", this.model.casingAnimDistance);
        this.model.casingAnimSpread = ConfigUtils.configVector(config, "animCasingAnimSpread", this.model.casingAnimSpread);
        this.model.casingAnimTime = ConfigUtils.configInt(config, "animCasingAnimTime", this.model.casingAnimTime);
        this.model.casingRotateVector = ConfigUtils.configVector(config, "animCasingRotateVector", this.model.casingRotateVector);
        this.model.casingAttachPoint = ConfigUtils.configVector(config, "animCasingAttachPoint", this.model.casingAttachPoint);
        this.model.casingDelay = ConfigUtils.configInt(config, "animCasingDelay", this.model.casingDelay);
        this.model.caseScale = ConfigUtils.configFloat(config, "animCasingScale", this.model.caseScale);
        this.model.flashScale = ConfigUtils.configFloat(config, "animFlashScale", this.model.flashScale);
        this.model.chargeHandleDistance = ConfigUtils.configFloat(config, "animChargeHandleDistance", this.model.chargeHandleDistance);
        this.model.chargeDelay = ConfigUtils.configInt(config, "animChargeDelay", this.model.chargeDelay);
        this.model.chargeDelayAfterReload = ConfigUtils.configInt(config, "animChargeDelayAfterReload", this.model.chargeDelayAfterReload);
        this.model.chargeTime = ConfigUtils.configInt(config, "animChargeTime", this.model.chargeTime);
        this.model.countOnRightHandSide = ConfigUtils.configBool(config, "animCountOnRightHandSide", this.model.countOnRightHandSide);
        this.model.isBulletCounterActive = ConfigUtils.configBool(config, "animIsBulletCounterActive", this.model.isBulletCounterActive);
        this.model.isAdvBulletCounterActive = ConfigUtils.configBool(config, "animIsAdvBulletCounterActive", this.model.isAdvBulletCounterActive);
        String[] split = ConfigUtils.getSplitFromKey(config, "animAnimationType");
        if (split != null) {
            if (split[1].equalsIgnoreCase("NONE")) {
                this.model.animationType = EnumAnimationType.NONE;
            } else if (split[1].equalsIgnoreCase("BOTTOM_CLIP")) {
                this.model.animationType = EnumAnimationType.BOTTOM_CLIP;
            } else if (split[1].equalsIgnoreCase("CUSTOMBOTTOM_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMBOTTOM_CLIP;
            } else if (split[1].equalsIgnoreCase("PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.PISTOL_CLIP;
            } else if (split[1].equalsIgnoreCase("CUSTOMPISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMPISTOL_CLIP;
            } else if (split[1].equalsIgnoreCase("TOP_CLIP")) {
                this.model.animationType = EnumAnimationType.TOP_CLIP;
            } else if (split[1].equalsIgnoreCase("CUSTOMTOP_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMTOP_CLIP;
            } else if (split[1].equalsIgnoreCase("SIDE_CLIP")) {
                this.model.animationType = EnumAnimationType.SIDE_CLIP;
            } else if (split[1].equalsIgnoreCase("CUSTOMSIDE_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMSIDE_CLIP;
            } else if (split[1].equalsIgnoreCase("P90")) {
                this.model.animationType = EnumAnimationType.P90;
            } else if (split[1].equalsIgnoreCase("CUSTOMP90")) {
                this.model.animationType = EnumAnimationType.CUSTOMP90;
            } else if (split[1].equalsIgnoreCase("SHOTGUN")) {
                this.model.animationType = EnumAnimationType.SHOTGUN;
            } else if (split[1].equalsIgnoreCase("CUSTOMSHOTGUN")) {
                this.model.animationType = EnumAnimationType.CUSTOMSHOTGUN;
            } else if (split[1].equalsIgnoreCase("RIFLE")) {
                this.model.animationType = EnumAnimationType.RIFLE;
            } else if (split[1].equalsIgnoreCase("CUSTOMRIFLE")) {
                this.model.animationType = EnumAnimationType.CUSTOMRIFLE;
            } else if (split[1].equalsIgnoreCase("REVOLVER")) {
                this.model.animationType = EnumAnimationType.REVOLVER;
            } else if (split[1].equalsIgnoreCase("CUSTOMREVOLVER")) {
                this.model.animationType = EnumAnimationType.CUSTOMREVOLVER;
            } else if (split[1].equalsIgnoreCase("REVOLVER2")) {
                this.model.animationType = EnumAnimationType.REVOLVER;
            } else if (split[1].equalsIgnoreCase("CUSTOMREVOLVER2")) {
                this.model.animationType = EnumAnimationType.CUSTOMREVOLVER;
            } else if (split[1].equalsIgnoreCase("END_LOADED")) {
                this.model.animationType = EnumAnimationType.END_LOADED;
            } else if (split[1].equalsIgnoreCase("CUSTOMEND_LOADED")) {
                this.model.animationType = EnumAnimationType.CUSTOMEND_LOADED;
            } else if (split[1].equalsIgnoreCase("RIFLE_TOP")) {
                this.model.animationType = EnumAnimationType.RIFLE_TOP;
            } else if (split[1].equalsIgnoreCase("CUSTOMRIFLE_TOP")) {
                this.model.animationType = EnumAnimationType.CUSTOMRIFLE_TOP;
            } else if (split[1].equalsIgnoreCase("BULLPUP")) {
                this.model.animationType = EnumAnimationType.BULLPUP;
            } else if (split[1].equalsIgnoreCase("CUSTOMBULLPUP")) {
                this.model.animationType = EnumAnimationType.CUSTOMBULLPUP;
            } else if (split[1].equalsIgnoreCase("ALT_PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.ALT_PISTOL_CLIP;
            } else if (split[1].equalsIgnoreCase("CUSTOMALT_PISTOL_CLIP")) {
                this.model.animationType = EnumAnimationType.CUSTOMALT_PISTOL_CLIP;
            } else if (split[1].equalsIgnoreCase("GENERIC")) {
                this.model.animationType = EnumAnimationType.GENERIC;
            } else if (split[1].equalsIgnoreCase("CUSTOMGENERIC")) {
                this.model.animationType = EnumAnimationType.CUSTOMGENERIC;
            } else if (split[1].equalsIgnoreCase("BACK_LOADED")) {
                this.model.animationType = EnumAnimationType.BACK_LOADED;
            } else if (split[1].equalsIgnoreCase("CUSTOMBACK_LOADED")) {
                this.model.animationType = EnumAnimationType.CUSTOMBACK_LOADED;
            } else if (split[1].equalsIgnoreCase("STRIKER")) {
                this.model.animationType = EnumAnimationType.STRIKER;
            } else if (split[1].equalsIgnoreCase("CUSTOMSTRIKER")) {
                this.model.animationType = EnumAnimationType.CUSTOMSTRIKER;
            } else if (split[1].equalsIgnoreCase("BREAK_ACTION")) {
                this.model.animationType = EnumAnimationType.BREAK_ACTION;
            } else if (split[1].equalsIgnoreCase("CUSTOMBREAK_ACTION")) {
                this.model.animationType = EnumAnimationType.CUSTOMBREAK_ACTION;
            } else if (split[1].equalsIgnoreCase("CUSTOM")) {
                this.model.animationType = EnumAnimationType.CUSTOM;
            }
        }
        if ((split = ConfigUtils.getSplitFromKey(config, "animMeleeAnimation")) != null) {
            if (split[1].equalsIgnoreCase("DEFAULT")) {
                this.model.meleeAnimation = EnumMeleeAnimation.DEFAULT;
            } else if (split[1].equalsIgnoreCase("NONE")) {
                this.model.meleeAnimation = EnumMeleeAnimation.NONE;
            } else if (split[1].equalsIgnoreCase("BLUNT_SWING")) {
                this.model.meleeAnimation = EnumMeleeAnimation.BLUNT_SWING;
            } else if (split[1].equalsIgnoreCase("BLUNT_BASH")) {
                this.model.meleeAnimation = EnumMeleeAnimation.BLUNT_BASH;
            } else if (split[1].equalsIgnoreCase("STAB_UNDERARM")) {
                this.model.meleeAnimation = EnumMeleeAnimation.STAB_UNDERARM;
            } else if (split[1].equalsIgnoreCase("STAB_OVERARM")) {
                this.model.meleeAnimation = EnumMeleeAnimation.STAB_OVERARM;
            }
        }
        this.model.tiltGunTime = ConfigUtils.configFloat(config, "animTiltGunTime", this.model.tiltGunTime);
        this.model.unloadClipTime = ConfigUtils.configFloat(config, "animUnloadClipTime", this.model.unloadClipTime);
        this.model.loadClipTime = ConfigUtils.configFloat(config, "animLoadClipTime", this.model.loadClipTime);
        this.model.scopeIsOnSlide = ConfigUtils.configBool(config, "animScopeIsOnSlide", this.model.scopeIsOnSlide);
        this.model.scopeIsOnBreakAction = ConfigUtils.configBool(config, "animScopeIsOnBreakAction", this.model.scopeIsOnBreakAction);
        this.model.numBulletsInReloadAnimation = ConfigUtils.configFloat(config, "animNumBulletsInReloadAnimation", this.model.numBulletsInReloadAnimation);
        this.model.pumpDelay = ConfigUtils.configInt(config, "animPumpDelay", this.model.pumpDelay);
        this.model.pumpDelayAfterReload = ConfigUtils.configInt(config, "animPumpDelayAfterReload", this.model.pumpDelayAfterReload);
        this.model.pumpTime = ConfigUtils.configInt(config, "animPumpTime", this.model.pumpTime);
        this.model.hammerDelay = ConfigUtils.configInt(config, "animHammerDelay", this.model.hammerDelay);
        this.model.pumpHandleDistance = ConfigUtils.configFloat(config, "animPumpHandleDistance", this.model.pumpHandleDistance);
        this.model.endLoadedAmmoDistance = ConfigUtils.configFloat(config, "animEndLoadedAmmoDistance", this.model.endLoadedAmmoDistance);
        this.model.breakActionAmmoDistance = ConfigUtils.configFloat(config, "animBreakActionAmmoDistance", this.model.breakActionAmmoDistance);
        this.model.scopeIsOnBreakAction = ConfigUtils.configBool(config, "animScopeIsOnBreakAction", this.model.scopeIsOnBreakAction);
        this.model.gripIsOnPump = ConfigUtils.configBool(config, "animGripIsOnPump", this.model.gripIsOnPump);
        this.model.gripIsOnPump = ConfigUtils.configBool(config, "animGadgetsOnPump", this.model.gripIsOnPump);
        this.model.barrelBreakPoint = ConfigUtils.configVector(config, "animBarrelBreakPoint", this.model.barrelBreakPoint);
        this.model.altbarrelBreakPoint = ConfigUtils.configVector(config, "animAltBarrelBreakPoint", this.model.altbarrelBreakPoint);
        this.model.revolverFlipAngle = ConfigUtils.configFloat(config, "animRevolverFlipAngle", this.model.revolverFlipAngle);
        this.model.revolver2FlipAngle = ConfigUtils.configFloat(config, "animRevolver2FlipAngle", this.model.revolver2FlipAngle);
        this.model.revolverFlipPoint = ConfigUtils.configVector(config, "animRevolverFlipPoint", this.model.revolverFlipPoint);
        this.model.revolver2FlipPoint = ConfigUtils.configVector(config, "animRevolver2FlipPoint", this.model.revolver2FlipPoint);
        this.model.breakAngle = ConfigUtils.configFloat(config, "animBreakAngle", this.model.breakAngle);
        this.model.altbreakAngle = ConfigUtils.configFloat(config, "animAltBreakAngle", this.model.altbreakAngle);
        this.model.spinningCocking = ConfigUtils.configBool(config, "animSpinningCocking", this.model.spinningCocking);
        this.model.spinPoint = ConfigUtils.configVector(config, "animSpinPoint", this.model.spinPoint);
        this.model.hammerSpinPoint = ConfigUtils.configVector(config, "animHammerSpinPoint", this.model.hammerSpinPoint);
        this.model.althammerSpinPoint = ConfigUtils.configVector(config, "animAltHammerSpinPoint", this.model.althammerSpinPoint);
        this.model.hammerAngle = ConfigUtils.configFloat(config, "animHammerAngle", this.model.hammerAngle);
        this.model.althammerAngle = ConfigUtils.configFloat(config, "animAltHammerAngle", this.model.althammerAngle);
        this.model.isSingleAction = ConfigUtils.configBool(config, "animIsSingleAction", this.model.isSingleAction);
        this.model.slideLockOnEmpty = ConfigUtils.configBool(config, "animSlideLockOnEmpty", this.model.slideLockOnEmpty);
        this.model.lefthandPump = ConfigUtils.configBool(config, "animLeftHandPump", this.model.lefthandPump);
        this.model.righthandPump = ConfigUtils.configBool(config, "animRightHandPump", this.model.righthandPump);
        this.model.leftHandCharge = ConfigUtils.configBool(config, "animLeftHandCharge", this.model.leftHandCharge);
        this.model.rightHandCharge = ConfigUtils.configBool(config, "animRightHandCharge", this.model.rightHandCharge);
        this.model.leftHandBolt = ConfigUtils.configBool(config, "animLeftHandBolt", this.model.leftHandBolt);
        this.model.rightHandBolt = ConfigUtils.configBool(config, "animRightHandBolt", this.model.rightHandBolt);
        this.model.pumpModifier = ConfigUtils.configFloat(config, "animPumpModifier", this.model.pumpModifier);
        this.model.chargeModifier = ConfigUtils.configVector(config, "animChargeModifier", this.model.chargeModifier);
        this.model.gunOffset = ConfigUtils.configFloat(config, "animGunOffset", this.model.gunOffset);
        this.model.crouchZoom = ConfigUtils.configFloat(config, "animCrouchZoom", this.model.crouchZoom);
        this.model.fancyStance = ConfigUtils.configBool(config, "animFancyStance", this.model.fancyStance);
        this.model.stanceTranslate = ConfigUtils.configVector(config, "animTranslateClip", this.model.stanceTranslate);
        this.model.stanceRotate = ConfigUtils.configVector(config, "animStanceRotate", this.model.stanceRotate);
        this.model.rotateGunVertical = ConfigUtils.configFloat(config, "animRotateGunVertical", this.model.rotateGunVertical);
        this.model.rotateGunHorizontal = ConfigUtils.configFloat(config, "animRotateGunHorizontal", this.model.rotateGunHorizontal);
        this.model.tiltGun = ConfigUtils.configFloat(config, "animTiltGun", this.model.tiltGun);
        this.model.translateGun = ConfigUtils.configVector(config, "animTranslateGun", this.model.translateGun);
        this.model.rotateClipVertical = ConfigUtils.configFloat(config, "animRotateClipVertical", this.model.rotateClipVertical);
        this.model.stagedrotateClipVertical = ConfigUtils.configFloat(config, "animStagedRotateClipVertical", this.model.stagedrotateClipVertical);
        this.model.rotateClipVertical = ConfigUtils.configFloat(config, "animRotateClipHorizontal", this.model.rotateClipVertical);
        this.model.stagedrotateClipVertical = ConfigUtils.configFloat(config, "animStagedRotateClipHorizontal", this.model.stagedrotateClipVertical);
        this.model.tiltClip = ConfigUtils.configFloat(config, "animTiltClip", this.model.tiltClip);
        this.model.stagedtiltClip = ConfigUtils.configFloat(config, "animStagedTiltClip", this.model.stagedtiltClip);
        this.model.translateClip = ConfigUtils.configVector(config, "animTranslateClip", this.model.translateClip);
        this.model.stagedtranslateClip = ConfigUtils.configVector(config, "animStagedTranslateClip", this.model.stagedtranslateClip);
        this.model.stagedReload = ConfigUtils.configBool(config, "animStagedReload", this.model.stagedReload);
        this.model.thirdPersonOffset = ConfigUtils.configVector(config, "animThirdPersonOffset", this.model.thirdPersonOffset);
        this.model.itemFrameOffset = ConfigUtils.configVector(config, "animItemFrameOffset", this.model.itemFrameOffset);
        this.model.stillRenderGunWhenScopedOverlay = ConfigUtils.configBool(config, "animStillRenderGunWhenScopedOverlay", this.model.stillRenderGunWhenScopedOverlay);
        this.model.adsEffectMultiplier = ConfigUtils.configFloat(config, "animAdsEffectMultiplier", this.model.adsEffectMultiplier);
    }

    public boolean isAmmo(ShootableType type) {
        return this.ammo.contains(type);
    }

    public boolean isAmmo(ShootableType type, ItemStack stack) {
        boolean result = this.ammo.contains(type);
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            ArrayList<ShootableType> t = new ArrayList<ShootableType>();
            for (String s : this.getGrip((ItemStack)stack).secondaryAmmo) {
                ShootableType shoot = ShootableType.getShootableType(s);
                if (type == null) continue;
                t.add(shoot);
            }
            result = t.contains(type);
        }
        return result;
    }

    public ShootableType getDefaultAmmo() {
        if (!this.ammo.isEmpty()) {
            return this.ammo.get(0);
        }
        return null;
    }

    public boolean getOneHanded() {
        return !FlansMod.masterDualWieldDisable && this.oneHanded;
    }

    public boolean isAmmo(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBullet) {
            return this.isAmmo(((ItemBullet)stack.func_77973_b()).type, stack);
        }
        if (stack.func_77973_b() instanceof ItemGrenade) {
            return this.isAmmo(((ItemGrenade)stack.func_77973_b()).type, stack);
        }
        return false;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelGun.class);
        this.deployableModel = FlansMod.proxy.loadModel(this.deployableModelString, this.shortName, ModelMG.class);
        this.casingModel = FlansMod.proxy.loadModel(this.casingModelString, this.shortName, ModelCasing.class);
        this.flashModel = FlansMod.proxy.loadModel(this.flashModelString, this.shortName, ModelFlash.class);
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.defaultScopeTexture;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVFactor;
    }

    public IScope getCurrentScope(ItemStack gunStack) {
        AttachmentType attachedScope = this.getScope(gunStack);
        return attachedScope == null ? this : attachedScope;
    }

    public ArrayList<AttachmentType> getCurrentAttachments(ItemStack gun) {
        this.checkForTags(gun);
        ArrayList<AttachmentType> attachments = new ArrayList<AttachmentType>();
        NBTTagCompound attachmentTags = gun.field_77990_d.func_74775_l("attachments");
        NBTTagList genericsList = attachmentTags.func_150295_c("generics", 10);
        for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
            this.appendToList(gun, "generic_" + i, attachments);
        }
        this.appendToList(gun, "barrel", attachments);
        this.appendToList(gun, "scope", attachments);
        this.appendToList(gun, "stock", attachments);
        this.appendToList(gun, "grip", attachments);
        this.appendToList(gun, "gadget", attachments);
        this.appendToList(gun, "slide", attachments);
        this.appendToList(gun, "pump", attachments);
        this.appendToList(gun, "accessory", attachments);
        return attachments;
    }

    private void appendToList(ItemStack gun, String name, ArrayList<AttachmentType> attachments) {
        AttachmentType type = this.getAttachment(gun, name);
        if (type != null) {
            attachments.add(type);
        }
    }

    public AttachmentType getBarrel(ItemStack gun) {
        return this.getAttachment(gun, "barrel");
    }

    public AttachmentType getScope(ItemStack gun) {
        return this.getAttachment(gun, "scope");
    }

    public AttachmentType getStock(ItemStack gun) {
        return this.getAttachment(gun, "stock");
    }

    public AttachmentType getGrip(ItemStack gun) {
        return this.getAttachment(gun, "grip");
    }

    public AttachmentType getGadget(ItemStack gun) {
        return this.getAttachment(gun, "gadget");
    }

    public AttachmentType getSlide(ItemStack gun) {
        return this.getAttachment(gun, "slide");
    }

    public AttachmentType getPump(ItemStack gun) {
        return this.getAttachment(gun, "pump");
    }

    public AttachmentType getAccessory(ItemStack gun) {
        return this.getAttachment(gun, "accessory");
    }

    public AttachmentType getGeneric(ItemStack gun, int i) {
        return this.getAttachment(gun, "generic_" + i);
    }

    public ItemStack getBarrelItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "barrel");
    }

    public ItemStack getScopeItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "scope");
    }

    public ItemStack getStockItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "stock");
    }

    public ItemStack getGripItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "grip");
    }

    public ItemStack getGadgetItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "gadget");
    }

    public ItemStack getSlideItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "slide");
    }

    public ItemStack getPumpItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "pump");
    }

    public ItemStack getAccessoryItemStack(ItemStack gun) {
        return this.getAttachmentItemStack(gun, "accessory");
    }

    public ItemStack getGenericItemStack(ItemStack gun, int i) {
        return this.getAttachmentItemStack(gun, "generic_" + i);
    }

    public AttachmentType getAttachment(ItemStack gun, String name) {
        if (gun == null || !(gun.func_77973_b() instanceof ItemGun)) {
            return null;
        }
        this.checkForTags(gun);
        return AttachmentType.getFromNBT(gun.field_77990_d.func_74775_l("attachments").func_74775_l(name));
    }

    public ItemStack getAttachmentItemStack(ItemStack gun, String name) {
        this.checkForTags(gun);
        return ItemStack.func_77949_a((NBTTagCompound)gun.field_77990_d.func_74775_l("attachments").func_74775_l(name));
    }

    public void checkForTags(ItemStack gun) {
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound();
        }
        if (!gun.field_77990_d.func_74764_b("attachments")) {
            NBTTagCompound attachmentTags = new NBTTagCompound();
            for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
                attachmentTags.func_74782_a("generic_" + i, (NBTBase)new NBTTagCompound());
            }
            attachmentTags.func_74782_a("barrel", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("scope", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("stock", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("grip", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("gadget", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("slide", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("pump", (NBTBase)new NBTTagCompound());
            attachmentTags.func_74782_a("accessory", (NBTBase)new NBTTagCompound());
            gun.field_77990_d.func_74782_a("attachments", (NBTBase)attachmentTags);
        }
    }

    public float getMeleeDamage(ItemStack stack, boolean driveable) {
        float stackMeleeDamage = this.meleeDamage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMeleeDamage *= attachment.meleeDamageMultiplier;
        }
        return stackMeleeDamage * (driveable ? this.meleeDamageDriveableModifier : 1.0f);
    }

    public float getDamage(ItemStack stack) {
        float stackDamage = this.damage;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackDamage = this.getGrip((ItemStack)stack).secondaryDamage;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackDamage *= attachment.damageMultiplier;
        }
        return stackDamage * FlansMod.masterDamageModifier;
    }

    public float getSpread(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackSpread = this.bulletSpread;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackSpread = this.getGrip((ItemStack)stack).secondarySpread;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        if (sprinting) {
            stackSpread *= this.sprintSpreadModifier;
        } else if (sneaking) {
            stackSpread *= this.sneakSpreadModifier;
        }
        return stackSpread;
    }

    public float getDefaultSpread(ItemStack stack) {
        float stackSpread = this.defaultSpread;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackSpread = this.getGrip((ItemStack)stack).secondaryDefaultSpread;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        return stackSpread;
    }

    public float getRecoilDisplay(ItemStack stack) {
        float stackRecoil = this.recoilPitch;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        return stackRecoil;
    }

    public float getRecoilPitch(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackRecoil = this.recoilPitch + rand.nextFloat() * this.rndRecoilPitchRange;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        if (sneaking) {
            stackRecoil = this.decreaseRecoilPitch != 0.0f ? (stackRecoil -= this.decreaseRecoilPitch) : (this.recoilSneakingMultiplier == -1.0f ? (stackRecoil < 0.5f ? 0.0f : stackRecoil - 0.5f) : (stackRecoil *= this.recoilSneakingMultiplier));
        } else if (sprinting) {
            stackRecoil *= this.recoilSprintingMultiplier;
        }
        return stackRecoil * FlansMod.masterRecoilModifier;
    }

    public float getRecoilYaw(ItemStack stack, boolean sneaking, boolean sprinting) {
        float stackRecoilYaw = this.recoilYaw + (rand.nextFloat() - 0.5f) * this.rndRecoilYawRange;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoilYaw *= attachment.recoilMultiplier;
        }
        if (sneaking) {
            stackRecoilYaw = this.decreaseRecoilYaw < 0.0f ? (stackRecoilYaw /= this.decreaseRecoilYaw) : (stackRecoilYaw *= this.recoilSneakingMultiplierYaw);
        } else if (sprinting) {
            stackRecoilYaw *= this.recoilSprintingMultiplierYaw;
        }
        return stackRecoilYaw * FlansMod.masterRecoilModifier;
    }

    public float getBulletSpeed(ItemStack stack, ItemStack bulletStack) {
        float stackBulletSpeed = bulletStack != null && bulletStack.func_77973_b() != null && bulletStack.func_77973_b() instanceof ItemBullet ? this.bulletSpeed * ((ItemBullet)bulletStack.func_77973_b()).type.speedMultiplier : this.bulletSpeed;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackBulletSpeed = this.getGrip((ItemStack)stack).secondarySpeed;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getBulletSpeed(ItemStack stack) {
        float stackBulletSpeed = this.bulletSpeed;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackBulletSpeed = this.getGrip((ItemStack)stack).secondarySpeed;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getReloadTime(ItemStack stack) {
        float stackReloadTime = this.reloadTime;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            stackReloadTime = this.getGrip((ItemStack)stack).secondaryReloadTime;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackReloadTime *= attachment.reloadTimeMultiplier;
        }
        return stackReloadTime;
    }

    public float getShootDelay(ItemStack stack) {
        if (this.roundsPerMin != 0.0f) {
            float fireRate = this.roundsPerMin;
            if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
                fireRate = this.getGrip((ItemStack)stack).secondaryShootDelay;
            }
            return 1200.0f / fireRate;
        }
        if (this.shootDelay != 0.0f) {
            float fireRate = this.shootDelay;
            if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
                fireRate = this.getGrip((ItemStack)stack).secondaryShootDelay;
            }
            return fireRate;
        }
        return 2.0f;
    }

    public float getShootDelay() {
        if (this.roundsPerMin != 0.0f) {
            return 1200.0f / this.roundsPerMin;
        }
        if (this.shootDelay != 0.0f) {
            return this.shootDelay;
        }
        return 2.0f;
    }

    public int getNumBullets(ItemStack stack) {
        int amount = this.numBullets;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            amount = this.getGrip((ItemStack)stack).secondaryNumBullets;
        }
        return amount;
    }

    public float getMovementSpeed(ItemStack stack) {
        float stackMovement = this.moveSpeedModifier;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMovement *= attachment.moveSpeedMultiplier;
        }
        return stackMovement;
    }

    public float getRecoilControl(ItemStack stack, boolean isSprinting, boolean isSneaking) {
        float control = isSprinting ? this.recoilCounterCoefficientSprinting : (isSneaking ? this.recoilCounterCoefficientSneaking : this.recoilCounterCoefficient);
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (isSprinting) {
                control *= attachment.recoilControlMultiplierSprinting;
                continue;
            }
            if (isSneaking) {
                control *= attachment.recoilControlMultiplierSneaking;
                continue;
            }
            control *= attachment.recoilControlMultiplier;
        }
        return Math.max(0.0f, Math.min(1.0f, control));
    }

    public void setFireMode(ItemStack stack, int fireMode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (fireMode < EnumFireMode.values().length) {
            stack.func_77978_p().func_74774_a("GunMode", (byte)fireMode);
        } else {
            stack.func_77978_p().func_74774_a("GunMode", (byte)this.mode.ordinal());
        }
    }

    public EnumFireMode getFireMode(ItemStack stack) {
        byte gm;
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            return this.getGrip((ItemStack)stack).secondaryFireMode;
        }
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            if (attachment.modeOverride == null) continue;
            return attachment.modeOverride;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("GunMode") && (gm = stack.func_77978_p().func_74771_c("GunMode")) < EnumFireMode.values().length) {
            for (EnumFireMode enumFireMode : this.submode) {
                if (gm != enumFireMode.ordinal()) continue;
                return EnumFireMode.values()[gm];
            }
        }
        this.setFireMode(stack, this.mode.ordinal());
        return this.mode;
    }

    public void setSecondaryFire(ItemStack stack, boolean mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("secondaryFire", mode);
    }

    public boolean getSecondaryFire(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("secondaryFire")) {
            stack.field_77990_d.func_74757_a("secondaryFire", false);
            return stack.func_77978_p().func_74767_n("secondaryFire");
        }
        return stack.func_77978_p().func_74767_n("secondaryFire");
    }

    public int getNumAmmoItemsInGun(ItemStack stack) {
        if (this.getGrip(stack) != null && this.getSecondaryFire(stack)) {
            return this.getGrip((ItemStack)stack).numSecAmmoItems;
        }
        return this.numPrimaryAmmoItems;
    }

    public static GunType getGun(String s) {
        return guns.get(s);
    }

    public Paintjob getPaintjob(String s) {
        for (Paintjob paintjob : this.paintjobs) {
            if (!paintjob.iconName.equals(s)) continue;
            return paintjob;
        }
        return this.defaultPaintjob;
    }

    public boolean getShouldShowMuzzleFlash() {
        return this.useMuzzleFlashDefaults != false ? FlansMod.showMuzzleFlashParticlesDefault : this.showMuzzleFlashParticles;
    }

    @Override
    public float GetRecommendedScale() {
        return 60.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    public GunRecoil getRecoil(ItemStack stack) {
        GunRecoil stackRecoil = this.recoil.copy();
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil.applyModifier(attachment.recoilMultiplier);
        }
        return stackRecoil;
    }

    @Override
    public float getMinZoom() {
        return this.hasVariableZoom ? this.minZoom : -1.0f;
    }

    @Override
    public float getMaxZoom() {
        return this.hasVariableZoom ? this.maxZoom : -1.0f;
    }

    @Override
    public float getZoomAugment() {
        return this.hasVariableZoom ? this.zoomAugment : -1.0f;
    }

    @Override
    public boolean hasVariableZoom() {
        return this.hasVariableZoom;
    }

    public static class GunRecoil {
        public static final Random rand = new Random();
        public float vertical;
        public float horizontal;
        public float recovery;
        public float recoveryScope;
        public float fall;
        public float increase;
        public float sneak;
        public float speed;
        public float sprayLength;
        public float antiRecoil;

        public GunRecoil(float vertical, float horizontal, float recovery, float recoveryScope, float fall, float increase, float sneak, float speed) {
            this.vertical = vertical;
            this.horizontal = horizontal;
            this.recovery = recovery;
            this.recoveryScope = recoveryScope;
            this.fall = fall;
            this.increase = increase;
            this.sneak = sneak;
            this.speed = speed;
        }

        public GunRecoil() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public GunRecoil(GunRecoil gunRecoil) {
            this(gunRecoil.vertical, gunRecoil.horizontal, gunRecoil.recovery, gunRecoil.recoveryScope, gunRecoil.fall, gunRecoil.increase, gunRecoil.sneak, gunRecoil.speed);
        }

        public GunRecoil read(String[] split) {
            this.vertical = this.read(split, 1, this.vertical);
            this.horizontal = this.read(split, 2, this.horizontal);
            this.recovery = this.read(split, 3, this.recovery);
            this.recoveryScope = this.read(split, 4, this.recoveryScope);
            this.fall = this.read(split, 5, this.fall);
            this.increase = this.read(split, 6, this.increase);
            this.sneak = this.read(split, 7, this.sneak);
            this.speed = this.read(split, 8, this.speed);
            if (split.length < 2) {
                this.horizontal = this.vertical * 0.3f;
            }
            return this;
        }

        private float read(String[] split, int i, float alt) {
            return split.length > i ? Float.parseFloat(split[i].indexOf(61) == -1 ? split[i] : split[i].substring(split[i].indexOf(61) + 1)) : alt;
        }

        public GunRecoil copy() {
            String rc = "Recoil 1.9 horizontal=1.9 recovery=1 recoveryScope=1 fall=0.9 increase=2 sneak=1 speed=1.2";
            return new GunRecoil(this);
        }

        public void applyModifier(float recoilMultiplier) {
            this.vertical *= recoilMultiplier;
            this.horizontal *= recoilMultiplier;
        }

        public void addRecoil(GunRecoil recoil) {
            this.vertical += recoil.vertical;
            this.horizontal += 0.2f * (float)(rand.nextBoolean() ? -1 : 1) * recoil.horizontal;
            this.recovery = recoil.recovery;
            this.recoveryScope = recoil.recoveryScope;
            this.increase = recoil.increase;
            this.sneak = recoil.sneak;
            this.fall = recoil.fall;
            this.speed = recoil.speed;
            this.sprayLength = (float)((double)this.sprayLength + 0.05);
            this.vertical *= 1.0f + this.sprayLength * 2.0f * recoil.increase;
            this.horizontal *= 1.0f + this.sprayLength * 2.0f * recoil.increase;
            this.antiRecoil *= rand.nextFloat() * 0.1f;
        }

        public float update(boolean sneaking, boolean scoping, float playerSpeed) {
            float recov = 0.5f * this.recovery;
            if (sneaking) {
                recov *= 0.9f * this.sneak;
            }
            if (scoping) {
                recov *= 0.8f * this.recoveryScope;
            }
            if (this.vertical > 0.0f) {
                this.vertical *= recov;
            }
            if (this.horizontal != 0.0f) {
                this.horizontal *= recov;
            }
            this.sprayLength *= 0.95f;
            if (playerSpeed > 0.0f) {
                float speedMod = 1.0f + playerSpeed * this.speed;
                this.vertical *= speedMod;
                this.horizontal *= speedMod;
            }
            float anti = this.antiRecoil * 0.2f;
            this.antiRecoil *= 0.8f;
            this.antiRecoil += this.vertical * Math.max(0.0f, Math.min(1.0f, 1.0f - rand.nextFloat() * 0.2f - (this.fall - 1.0f)));
            float add = -this.vertical + anti;
            return add;
        }
    }
}

