/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.network.PacketExplosion;
import com.flansmod.common.network.PacketHitMarker;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.types.InfoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class FlansModExplosion
extends Explosion {
    private static final int boomRadius = 16;
    private static final Random explosionRNG = new Random();
    private HashMap<EntityPlayer, Vec3> playerLocations = new HashMap();
    private World worldObj;
    public InfoType type;
    public EntityPlayer player;
    private float radius;
    private float power;
    private final float damageVsLiving;
    private final float damageVsPlayer;
    private final float damageVsPlane;
    private final float damageVsVehicle;
    public boolean breakBlocks;
    public boolean canceled = false;
    public boolean canDamageSelf;

    public FlansModExplosion(World w, Entity e, EntityPlayer p, InfoType t, double x, double y, double z, float explosionRadius, float explosionPower, boolean breakBlocks, float damageLiving, float damagePlayer, float damagePlane, float damageVehicle, int smokeCount, int debrisCount, boolean damageSelf) {
        super(w, e, x, y, z, explosionRadius);
        this.radius = explosionRadius;
        this.power = explosionPower;
        this.worldObj = w;
        this.type = t;
        this.player = p;
        this.field_77286_a = false;
        this.field_82755_b = true;
        this.breakBlocks = breakBlocks;
        this.damageVsPlayer = damagePlayer;
        this.damageVsLiving = damageLiving;
        this.damageVsPlane = damagePlane;
        this.damageVsVehicle = damageVehicle;
        this.canDamageSelf = damageSelf;
        this.func_77278_a();
        this.func_77279_a(true);
        this.spawnParticle(smokeCount, debrisCount);
        this.canceled = ForgeEventFactory.onExplosionStart((World)this.worldObj, (Explosion)this);
        if (!this.worldObj.field_72995_K) {
            for (Object playerEntity : this.worldObj.field_73010_i) {
                EntityPlayerMP entityplayer;
                if (!(playerEntity instanceof EntityPlayerMP) || !((entityplayer = (EntityPlayerMP)playerEntity).func_70092_e(x, y, z) < 4096.0)) continue;
                FlansMod.getPacketHandler().sendTo(new PacketExplosion(x, y, z, explosionRadius), entityplayer);
            }
        }
    }

    public void func_77278_a() {
        double d2;
        double d1;
        double d0;
        int k;
        int j;
        float f = this.field_77280_f;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        float largeRadius = this.radius * 2.0f;
        int i = 0;
        while ((float)i < largeRadius) {
            j = 0;
            while ((float)j < largeRadius) {
                k = 0;
                while ((float)k < largeRadius) {
                    if (i == 0 || (float)i == largeRadius - 1.0f || j == 0 || (float)j == largeRadius - 1.0f || k == 0 || (float)k == largeRadius - 1.0f) {
                        double d3 = (float)i / (largeRadius - 1.0f) * 2.0f - 1.0f;
                        double d4 = (float)j / (largeRadius - 1.0f) * 2.0f - 1.0f;
                        double d5 = (float)k / (largeRadius - 1.0f) * 2.0f - 1.0f;
                        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                        d3 /= d6;
                        d4 /= d6;
                        d5 /= d6;
                        d0 = this.field_77284_b;
                        d1 = this.field_77285_c;
                        d2 = this.field_77282_d;
                        float f2 = 0.3f;
                        for (float f1 = this.power * this.radius * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                            int l = MathHelper.func_76128_c((double)d0);
                            int i1 = MathHelper.func_76128_c((double)d1);
                            int j1 = MathHelper.func_76128_c((double)d2);
                            Block block = this.worldObj.func_147439_a(l, i1, j1);
                            float f3 = this.field_77283_e != null ? this.field_77283_e.func_145772_a((Explosion)this, this.worldObj, l, i1, j1, block) : block.getExplosionResistance(this.field_77283_e, this.worldObj, l, i1, j1, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                            double distFactor = Math.sqrt(Math.pow(d0 - this.field_77284_b, 2.0) + Math.pow(d1 - this.field_77285_c, 2.0) + Math.pow(d2 - this.field_77282_d, 2.0));
                            f1 = distFactor + 0.5 < (double)this.radius ? (f1 -= (f3 + 0.3f) * f2) : (float)((double)f1 - (double)((f3 + 0.3f) * f2) * Math.pow(distFactor - (double)this.radius + 2.0, 3.0) * 20.0);
                            if (f1 > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_145774_a((Explosion)this, this.worldObj, l, i1, j1, block, f1))) {
                                hashset.add(new ChunkPosition(l, i1, j1));
                            }
                            d0 += d3 * (double)f2;
                            d1 += d4 * (double)f2;
                            d2 += d5 * (double)f2;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (!this.canceled) {
            this.field_77281_g.addAll(hashset);
        }
        this.field_77280_f *= 2.0f;
        i = MathHelper.func_76128_c((double)(this.field_77284_b - (double)this.field_77280_f - 1.0));
        j = MathHelper.func_76128_c((double)(this.field_77284_b + (double)this.field_77280_f + 1.0));
        k = MathHelper.func_76128_c((double)(this.field_77285_c - (double)this.field_77280_f - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)this.field_77280_f + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)this.field_77280_f - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)this.field_77280_f + 1.0));
        List list = this.canDamageSelf ? this.worldObj.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2)) : this.worldObj.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)this.field_77280_f);
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (Object aList : list) {
            double d8;
            Entity entity = (Entity)aList;
            double d7 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)this.field_77280_f;
            if (!(d7 <= 1.0) || (d8 = (double)MathHelper.func_76133_a((double)((d0 = entity.field_70165_t - this.field_77284_b) * d0 + (d1 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d1 + (d2 = entity.field_70161_v - this.field_77282_d) * d2))) == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d9 = this.getBlockDensity(vec3, entity.field_70121_D);
            double d10 = (1.0 - d7) * d9;
            EntityDriveable entityDriveable = null;
            float damage = (float)((d10 * d10 + d10) / 2.0 * 8.0 * (double)this.field_77280_f + 1.0);
            if (entity instanceof EntityPlayer) {
                damage *= this.damageVsPlayer;
            } else if (entity instanceof EntityLivingBase) {
                damage *= this.damageVsLiving;
            } else if (entity instanceof EntityPlane) {
                damage *= this.damageVsPlane;
            } else if (entity instanceof EntityVehicle) {
                damage *= this.damageVsVehicle;
            } else if (entity instanceof EntityWheel) {
                entityDriveable = ((EntityWheel)entity).vehicle;
                damage *= FlansMod.vehicleWheelSeatExplosionModifier;
            } else if (entity instanceof EntitySeat) {
                entityDriveable = ((EntitySeat)entity).driveable;
                damage *= FlansMod.vehicleWheelSeatExplosionModifier;
            }
            if (entityDriveable instanceof EntityPlane) {
                damage *= this.damageVsPlane;
            }
            if (entityDriveable instanceof EntityVehicle) {
                damage *= this.damageVsVehicle;
            }
            if (damage > 0.5f) {
                boolean b = entity.func_70097_a(this.player == null || this.type == null ? DamageSource.func_94539_a((Explosion)this) : new EntityDamageSourceFlans(this.type.shortName, entity, this.player, this.type, false, false).func_94540_d(), damage);
                if (b && !this.worldObj.field_72995_K && this.player instanceof EntityPlayerMP) {
                    FlansMod.getPacketHandler().sendTo(new PacketHitMarker(false, 1.0f, true), (EntityPlayerMP)this.player);
                }
                double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
                entity.field_70159_w += d0 * d11;
                entity.field_70181_x += d1 * d11;
                entity.field_70179_y += d2 * d11;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            this.playerLocations.put((EntityPlayer)entity, Vec3.func_72443_a((double)(d0 * d10), (double)(d1 * d10), (double)(d2 * d10)));
        }
        this.field_77280_f = f;
        if (!this.breakBlocks) {
            this.field_77281_g.clear();
        }
    }

    public void spawnParticle(int numSmoke, int numDebris) {
        float smokeRand;
        float mod = this.radius * 0.1f;
        for (int smoke = 0; smoke < numSmoke; ++smoke) {
            smokeRand = (float)Math.random();
            if ((double)smokeRand < 0.25) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.25 && (double)smokeRand < 0.5) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.5 && (double)smokeRand < 0.75) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if (!((double)smokeRand > 0.75)) continue;
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
        }
        for (int debris = 0; debris < numDebris; ++debris) {
            smokeRand = (float)Math.random();
            if ((double)smokeRand < 0.25) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.25 && (double)smokeRand < 0.5) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.5 && (double)smokeRand < 0.75) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if (!((double)smokeRand > 0.75)) continue;
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
        }
    }

    public float getBlockDensity(Vec3 p_72842_1_, AxisAlignedBB p_72842_2_) {
        double d0 = 1.0 / ((p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * 2.0 + 1.0);
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d3 = p_72842_2_.field_72340_a + (p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * (double)f;
                        double d4 = p_72842_2_.field_72338_b + (p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * (double)f1;
                        double d5 = p_72842_2_.field_72339_c + (p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * (double)f2;
                        if (this.worldObj.func_147447_a(Vec3.func_72443_a((double)d3, (double)d4, (double)d5), p_72842_1_, false, true, false) == null) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public Map func_77277_b() {
        return this.playerLocations;
    }

    public EntityLivingBase func_94613_c() {
        return this.field_77283_e == null ? null : (this.field_77283_e instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.field_77283_e).func_94083_c() : (this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null));
    }

    public static void clientExplosion(World worldObj, float explosionSize, double explosionX, double explosionY, double explosionZ) {
        double d7;
        double d6;
        double d5;
        int k;
        int j;
        int i;
        ArrayList affectedBlockPositions = new ArrayList();
        Entity exploder = null;
        Explosion explosion = new Explosion(worldObj, exploder, explosionX, explosionY, explosionZ, explosionSize);
        if (explosionSize < 2.0f) {
            explosionX += (double)(explosionRNG.nextFloat() - 0.5f);
            explosionZ += (double)(explosionRNG.nextFloat() - 0.5f);
        }
        boolean isSmoking = true;
        float f = explosionSize;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    d5 = explosionX;
                    d6 = explosionY;
                    d7 = explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = explosionSize * (0.7f + worldObj.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1 = MathHelper.func_76128_c((double)d5);
                        int k1 = MathHelper.func_76128_c((double)d6);
                        int l1 = MathHelper.func_76128_c((double)d7);
                        Block block = worldObj.func_147439_a(j1, k1, l1);
                        float f3 = 0.0f;
                        if ((f1 -= (f3 + 0.3f) * f2) > 0.0f && (exploder == null || exploder.func_145774_a(explosion, worldObj, j1, k1, l1, block, f1))) {
                            hashset.add(new ChunkPosition(j1, k1, l1));
                        }
                        d5 += d0 * (double)f2;
                        d6 += d1 * (double)f2;
                        d7 += d2 * (double)f2;
                    }
                }
            }
        }
        affectedBlockPositions.addAll(hashset);
        i = MathHelper.func_76128_c((double)(explosionX - (double)(explosionSize *= 2.0f) - 1.0));
        j = MathHelper.func_76128_c((double)(explosionX + (double)explosionSize + 1.0));
        k = MathHelper.func_76128_c((double)(explosionY - (double)explosionSize - 1.0));
        int i2 = MathHelper.func_76128_c((double)(explosionY + (double)explosionSize + 1.0));
        int l = MathHelper.func_76128_c((double)(explosionZ - (double)explosionSize - 1.0));
        int j2 = MathHelper.func_76128_c((double)(explosionZ + (double)explosionSize + 1.0));
        List list = worldObj.func_72839_b(exploder, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        Vec3 vec3 = Vec3.func_72443_a((double)explosionX, (double)explosionY, (double)explosionZ);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f(explosionX, explosionY, explosionZ) / (double)explosionSize;
            if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - explosionX) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - explosionY) * d6 + (d7 = entity.field_70161_v - explosionZ) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            double d10 = worldObj.func_72842_a(vec3, entity.field_70121_D);
            double d11 = (1.0 - d4) * d10;
            double d8 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
            entity.field_70159_w += d5 * d8;
            entity.field_70181_x += d6 * d8;
            entity.field_70179_y += d7 * d8;
        }
        explosionSize = f;
        if (explosionSize >= 2.0f && isSmoking) {
            worldObj.func_72869_a("hugeexplosion", explosionX, explosionY, explosionZ, 1.0, 0.0, 0.0);
        } else {
            worldObj.func_72869_a("largeexplode", explosionX, explosionY, explosionZ, 1.0, 0.0, 0.0);
        }
        Iterator iterator = affectedBlockPositions.iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            ++cnt;
            ChunkPosition chunkposition = (ChunkPosition)iterator.next();
            int i3 = chunkposition.field_151329_a;
            int j3 = chunkposition.field_151327_b;
            int k2 = chunkposition.field_151328_c;
            Block block = worldObj.func_147439_a(i3, j3, k2);
            double d0 = (float)i3 + worldObj.field_73012_v.nextFloat();
            double d1 = (float)j3 + worldObj.field_73012_v.nextFloat();
            double d2 = (float)k2 + worldObj.field_73012_v.nextFloat();
            double d3 = d0 - explosionX;
            double d4 = d1 - explosionY;
            double d52 = d2 - explosionZ;
            double d62 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d52 * d52));
            d3 /= d62;
            d4 /= d62;
            d52 /= d62;
            double d72 = 0.5 / (d62 / (double)explosionSize + 0.1);
            d3 *= (d72 *= (double)(worldObj.field_73012_v.nextFloat() * worldObj.field_73012_v.nextFloat() + 0.3f));
            d4 *= d72;
            d52 *= d72;
            if (explosionSize <= 1.0f && cnt % 4 == 0 || explosionSize > 1.0f) {
                FlansMod.proxy.spawnParticle("explode", (d0 + explosionX * 1.0) / 2.0, (d1 + explosionY * 1.0) / 2.0, (d2 + explosionZ * 1.0) / 2.0, d3, d4, d52);
            }
            block = Blocks.field_150350_a;
            if (explosionSize <= 2.0f) {
                if (cnt % 8 == 0) {
                    block = FlansModExplosion.getNearBlock(worldObj, i3, j3, k2);
                }
            } else {
                block = FlansModExplosion.getNearBlock(worldObj, i3, j3, k2);
            }
            if (block == Blocks.field_150350_a) continue;
            float m = explosionSize;
            m = m <= 1.0f ? (m *= 2.0f) : (m *= 0.5f);
            String pname = "blockdust_" + Block.func_149682_b((Block)block) + "_" + worldObj.func_72805_g(i3, j3, k2);
            FlansMod.proxy.spawnParticle(pname, (d0 + explosionX * 1.0) / 2.0, (d1 + explosionY * 1.0) / 2.0, (d2 + explosionZ * 1.0) / 2.0, d3 * (double)m, d4 * (double)m, d52 * (double)m);
        }
    }

    public static Block getNearBlock(World w, int x, int y, int z) {
        int[][] offset = new int[][]{{0, -1, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}};
        for (int i = 0; i < offset.length; ++i) {
            Block block;
            if (y <= 1 && offset[i][1] != 0 || (block = w.func_147439_a(x + offset[i][0], y + offset[i][1], z + offset[i][2])) == Blocks.field_150350_a) continue;
            return block;
        }
        return Blocks.field_150350_a;
    }
}

